"use strict";var e=require("vue"),t={name:"Knob",emits:["update:modelValue","change"],props:{modelValue:{type:Number,default:null},size:{type:Number,default:100},disabled:{type:Boolean,default:!1},readonly:{type:Boolean,default:!1},step:{type:Number,default:1},min:{type:Number,default:0},max:{type:Number,default:100},valueColor:{type:String,default:"var(--primary-color, Black)"},rangeColor:{type:String,default:"var(--surface-border, LightGray)"},textColor:{type:String,default:"var(--text-color-secondary, Black)"},strokeWidth:{type:Number,default:14},showValue:{type:Boolean,default:!0},valueTemplate:{type:String,default:"{value}"},tabindex:{type:Number,default:0},"aria-labelledby":{type:String,default:null},"aria-label":{type:String,default:null}},data:()=>({radius:40,midX:50,midY:50,minRadians:4*Math.PI/3,maxRadians:-Math.PI/3}),methods:{updateValue(e,t){let a=e-this.size/2,i=this.size/2-t,s=Math.atan2(i,a),n=-Math.PI/2-Math.PI/6;this.updateModel(s,n)},updateModel(e,t){let a;if(e>this.maxRadians)a=this.mapRange(e,this.minRadians,this.maxRadians,this.min,this.max);else{if(!(e<t))return;a=this.mapRange(e+2*Math.PI,this.minRadians,this.maxRadians,this.min,this.max)}let i=Math.round((a-this.min)/this.step)*this.step+this.min;this.$emit("update:modelValue",i),this.$emit("change",i)},updateModelValue(e){e>this.max?this.$emit("update:modelValue",this.max):e<this.min?this.$emit("update:modelValue",this.min):this.$emit("update:modelValue",e)},mapRange:(e,t,a,i,s)=>(e-t)*(s-i)/(a-t)+i,onClick(e){this.disabled||this.readonly||this.updateValue(e.offsetX,e.offsetY)},onMouseDown(e){this.disabled||this.readonly||(window.addEventListener("mousemove",this.onMouseMove),window.addEventListener("mouseup",this.onMouseUp),e.preventDefault())},onMouseUp(e){this.disabled||this.readonly||(window.removeEventListener("mousemove",this.onMouseMove),window.removeEventListener("mouseup",this.onMouseUp),e.preventDefault())},onTouchStart(e){this.disabled||this.readonly||(window.addEventListener("touchmove",this.onTouchMove),window.addEventListener("touchend",this.onTouchEnd),e.preventDefault())},onTouchEnd(e){this.disabled||this.readonly||(window.removeEventListener("touchmove",this.onTouchMove),window.removeEventListener("touchend",this.onTouchEnd),e.preventDefault())},onMouseMove(e){this.disabled||this.readonly||(this.updateValue(e.offsetX,e.offsetY),e.preventDefault())},onTouchMove(e){if(!this.disabled&&!this.readonly&&1==e.touches.length){const t=this.$el.getBoundingClientRect(),a=e.targetTouches.item(0),i=a.clientX-t.left,s=a.clientY-t.top;this.updateValue(i,s)}},onKeyDown(e){if(!this.disabled&&!this.readonly)switch(e.code){case"ArrowRight":case"ArrowUp":e.preventDefault(),this.updateModelValue(this.modelValue+1);break;case"ArrowLeft":case"ArrowDown":e.preventDefault(),this.updateModelValue(this.modelValue-1);break;case"Home":e.preventDefault(),this.$emit("update:modelValue",this.min);break;case"End":e.preventDefault(),this.$emit("update:modelValue",this.max);break;case"PageUp":e.preventDefault(),this.updateModelValue(this.modelValue+10);break;case"PageDown":e.preventDefault(),this.updateModelValue(this.modelValue-10)}}},computed:{containerClass(){return["p-knob p-component",{"p-disabled":this.disabled}]},rangePath(){return`M ${this.minX} ${this.minY} A ${this.radius} ${this.radius} 0 1 1 ${this.maxX} ${this.maxY}`},valuePath(){return`M ${this.zeroX} ${this.zeroY} A ${this.radius} ${this.radius} 0 ${this.largeArc} ${this.sweep} ${this.valueX} ${this.valueY}`},zeroRadians(){return this.min>0&&this.max>0?this.mapRange(this.min,this.min,this.max,this.minRadians,this.maxRadians):this.mapRange(0,this.min,this.max,this.minRadians,this.maxRadians)},valueRadians(){return this.mapRange(this.modelValue,this.min,this.max,this.minRadians,this.maxRadians)},minX(){return this.midX+Math.cos(this.minRadians)*this.radius},minY(){return this.midY-Math.sin(this.minRadians)*this.radius},maxX(){return this.midX+Math.cos(this.maxRadians)*this.radius},maxY(){return this.midY-Math.sin(this.maxRadians)*this.radius},zeroX(){return this.midX+Math.cos(this.zeroRadians)*this.radius},zeroY(){return this.midY-Math.sin(this.zeroRadians)*this.radius},valueX(){return this.midX+Math.cos(this.valueRadians)*this.radius},valueY(){return this.midY-Math.sin(this.valueRadians)*this.radius},largeArc(){return Math.abs(this.zeroRadians-this.valueRadians)<Math.PI?0:1},sweep(){return this.valueRadians>this.zeroRadians?0:1},valueToDisplay(){return this.valueTemplate.replace(/{value}/g,this.modelValue)}}};const a=["width","height","tabindex","aria-valuemin","aria-valuemax","aria-valuenow","aria-labelledby","aria-label"],i=["d","stroke-width","stroke"],s=["d","stroke-width","stroke"],n=["fill"];!function(e,t){void 0===t&&(t={});var a=t.insertAt;if(e&&"undefined"!=typeof document){var i=document.head||document.getElementsByTagName("head")[0],s=document.createElement("style");s.type="text/css","top"===a&&i.firstChild?i.insertBefore(s,i.firstChild):i.appendChild(s),s.styleSheet?s.styleSheet.cssText=e:s.appendChild(document.createTextNode(e))}}("\n@keyframes dash-frame {\n100% {\n        stroke-dashoffset: 0;\n}\n}\n.p-knob-range {\n    fill: none;\n    transition: stroke 0.1s ease-in;\n}\n.p-knob-value {\n    animation-name: dash-frame;\n    animation-fill-mode: forwards;\n    fill: none;\n}\n.p-knob-text {\n    font-size: 1.3rem;\n    text-align: center;\n}\n"),t.render=function(t,o,l,d,r,h){return e.openBlock(),e.createElementBlock("div",{class:e.normalizeClass(h.containerClass)},[(e.openBlock(),e.createElementBlock("svg",{viewBox:"0 0 100 100",role:"slider",width:l.size,height:l.size,tabindex:l.readonly||l.disabled?-1:l.tabindex,"aria-valuemin":l.min,"aria-valuemax":l.max,"aria-valuenow":l.modelValue,"aria-labelledby":t.ariaLabelledby,"aria-label":t.ariaLabel,onClick:o[0]||(o[0]=(...e)=>h.onClick&&h.onClick(...e)),onKeydown:o[1]||(o[1]=(...e)=>h.onKeyDown&&h.onKeyDown(...e)),onMousedown:o[2]||(o[2]=(...e)=>h.onMouseDown&&h.onMouseDown(...e)),onMouseup:o[3]||(o[3]=(...e)=>h.onMouseUp&&h.onMouseUp(...e)),onTouchstart:o[4]||(o[4]=(...e)=>h.onTouchStart&&h.onTouchStart(...e)),onTouchend:o[5]||(o[5]=(...e)=>h.onTouchEnd&&h.onTouchEnd(...e))},[e.createElementVNode("path",{d:h.rangePath,"stroke-width":l.strokeWidth,stroke:l.rangeColor,class:"p-knob-range"},null,8,i),e.createElementVNode("path",{d:h.valuePath,"stroke-width":l.strokeWidth,stroke:l.valueColor,class:"p-knob-value"},null,8,s),l.showValue?(e.openBlock(),e.createElementBlock("text",{key:0,x:50,y:57,"text-anchor":"middle",fill:l.textColor,class:"p-knob-text"},e.toDisplayString(h.valueToDisplay),9,n)):e.createCommentVNode("",!0)],40,a))],2)},module.exports=t;
