import {ref} from 'vue';

export function useResize() {
	
	let resize = ref({
		resize: async (imgEvent, imgQuality = 0.9, imgMaxWidth = 1200, imgMaxHeight = 768) => {
			var file = imgEvent.target.files[0];
			var type = file.type;
			if(!file.type.includes('image/')) {
				return null;
			}
			var maxWidth = imgMaxWidth;
			var maxHeight = imgMaxHeight;
			var quality = imgQuality;
			return new Promise((resolve, reject) => {
				let reader = new FileReader();
				reader.onload = function(readerEvent) {
					let img = new Image();
					img.onload = function(imageEvent) {
						let canvas = document.createElement('canvas');
						let width = img.width;
						let height = img.height;
						if(width > height) {
							if(width > maxWidth) {
								height *= maxWidth / width;
								width = maxWidth;
							}
						} else {
							if(height > maxHeight) {
								width *= maxHeight / height;
								height = maxHeight;
							}
						}
						canvas.width = width;
						canvas.height = height;
						canvas.getContext('2d').drawImage(img, 0, 0, width, height);
						resolve(canvas.toDataURL('image/jpeg', quality));
					}
					img.src = readerEvent.target.result;
				}
				reader.readAsDataURL(file);
			});
		}
	});
	
	return resize;
	
}