import {ref} from 'vue';

/**
 * Contiene funciones y propiedades de un objeto de formulario.
 */
export function useForm(config) {
	
	// Se define un objeto form.
	let form = ref({
		// Método del formulario.
		method: config['method'] ? config['method'].toUpperCase() : 'GET',
		// URL a la que retorna el formulario. 
		urlBack: config['urlBack'] ? config['urlBack'] : '/',
	    // Indicates if form is ready to be used.
		ready: false,
		// Devuelve el texto del botón de acción de un formulario. 
		getBtnSubmit: function() {
			let btn = 'Aceptar';
			switch(this.method) {
				case 'POST': btn = 'Guardar'; break;
				case 'PUT': btn = 'Actualizar'; break;
				case 'PATCH': btn = 'Actualizar'; break;
				case 'DELETE': btn = 'Eliminar'; break;
			}
			return btn;
		},
		// Valida si el formulario está deshabilitado.
		isDisabled() {
			return !['POST', 'PUT', 'PATCH'].includes(this.method);
		},
		// Validates if form is ready.
		isReady() {
			return this.ready;
		},
		// Devuelve el texto de un botón de regresar de un formulario.
		getBtnBack: function() {
			return 'Regresar';
		},
		// Enfoca el campo con el primer error encontrado (no modificar).
		invalidSubmit: function() {
			const error = document.querySelector("[role=alert]:first-of-type").scrollIntoView({block: "center", behavior: "smooth"});
		},
		// Valida si se puede realizar un envío de información.
		allowSubmit: function() {
			return ['POST', 'PUT', 'PATCH', 'DELETE'].includes(this.method);
		},
	});
	
	// Se devuelve el objeto.
	return form;
	
}