import PrimeDialog from 'primevue/dialog';

/**
 * Component for generating a dialog to confirm the exit in a multistep form.
 */
export default {
	components: {
		PrimeDialog
	},
	props: [
		// Composable object that keeps the multistep state.
		'multistep',
		// URL where user is redirected when click on accept exit.
		'redirect'
	],
	template: `
		<prime-dialog v-model:visible="multistep.visibleDialogExit" :modal="true" :show-header="false" :dismissable-mask="true" 
			:closable="false" :draggable="false" :breakpoints="{'1400px': '50vw', '992px': '95vw'}">
			<div class="row my-3">
    			<div class="col-12 text-center">
    				<h3>¿Seguro que desea salir?</h3>
    			</div>
    		</div>
    		<div class="row mx-2">
    			<div class="col-12 text-center">
    				<p v-if="multistep.updated == true">Hay cambios que no se han guardado, si sale del formulario los cambios se perderán y los tendrá que capturar nuevamente. ¿Seguro que desea salir?</p>
					<p v-if="multistep.updated == false && multistep.nextStep <= multistep.steps.length">No se han completado todos los pasos del formulario, solo quedará guardada la información de los pasos completados o actualizados. ¿Seguro que desea salir?</p>
					<p v-if="multistep.updated == false && multistep.nextStep > multistep.steps.length">¿Seguro que desea salir del formulario?</p>
    			</div>
			</div>
			<div class="row my-3">
    			<div class="col-6 text-center mb-2">
    				<a class="btn btn-primary" :href="multistep.urlBack">Aceptar</a>
    			</div>
    			<div class="col-6 text-center mb-2">
    				<button type="button" class="btn btn-danger" @click="multistep.visibleDialogExit=false">Cancelar</button>
    			</div>
    		</div>
		</prime-dialog>
		<prime-dialog v-model:visible="multistep.visibleDialogSave" :modal="true" :show-header="false" :dismissable-mask="true" 
			:closable="false" :draggable="false" :breakpoints="{'1400px': '50vw', '992px': '95vw'}">
			<div class="row my-3">
    			<div class="col-12 text-center">
    				<h3>Debe guardar los cambios antes de continuar</h3>
    			</div>
    		</div>
    		<div class="row mx-2">
    			<div class="col-12 text-center">
					<button type="button" class="btn btn-primary" @click="multistep.visibleDialogSave=false">Aceptar</button>
				</div>
			</div>
		</prime-dialog>
	`
}