/**
 * Componente para la generación de los botones de un formulario multistep.
 */
export default {
	props: [
		// Composable del multistep que tiene el estado del formulario.
		'multistep'
	],
	template: `
		<div class="row mt-3" v-if="multistep.formMethod != 'DELETE'">
    		<div class="col-12 text-center col-md-2">
    			<button type="button" class="btn btn-sm btn-danger form-control mb-2" @click="multistep.visibleDialogExit=true">
    				{{ multistep.btnExit }}
    			</button>
    		</div>
    		<div class="col-12 text-center col-md-10 text-md-end">
    			<div class="row">
    				<div class="col-12 col-md-6"></div>
    				<div class="col-12 col-md-3">
    					<button type="button" class="btn btn-sm btn-danger form-control mb-2" @click="multistep.previousTab()" v-if="multistep.currentStep != 1">
		    				{{ multistep.btnBack }}
		    			</button>
    				</div>
    				<div class="col-12 col-md-3">
    					<button type="submit" class="btn btn-sm btn-primary form-control mb-2">
		    				{{ multistep.btnNext }}
		    			</button>
    				</div>
    			</div>
    		</div>
    	</div>
    	<div class="row mt-3" v-if="multistep.formMethod == 'DELETE'">
    		<div class="col-12 col-md-6 text-center">
    			<button type="submit" class="btn btn-sm btn-primary mb-2">
    				{{ multistep.btnDelete }}
    			</button>
    		</div>
    		<div class="col-12 col-md-6 text-center">
    			<a :href="multistep.urlBack" class="btn btn-sm btn-danger mb-2">
    				{{ multistep.btnReturn }}
    			</a>
    		</div>
    	</div>
	`
}