import {VueFinalModal, ModalsContainer} from 'vue-final-modal';

/**
 * Componente para la generación de una pantalla de bloqueo.
 */
export default {
	components: {
		VueFinalModal, 
		ModalsContainer
	},
	data() {
		return {
			// Bandera que controla si se muestra o no la pantalla de bloqueo.
			visible: false
		}
	},
	methods: {
		show() {
			this.visible = true;
		},
		hide() {
			this.visible = false;
		}
	},
	template: `
		<vue-final-modal v-model="visible" :z-index="100000" :click-to-close="false">
			<div class="text-center" style="color: white">Por favor espere...&nbsp;
	            <img src="/img/module_img/Application/ajax-loader.gif" style="height:20px; width:20px">
			</div>
		</vue-final-modal>
	`
}