/**
 * Component for alerts generation.
 */
export default {
	data() {
		return {
			// Server response.
			response: {},
			// Response success.
			success: true
		}
	},
	methods: {
		async show(response, redirect = null) {
			let r = response;
			if(response.status >= 400 && response.status <= 599) {
				this.success = false;
				await response.json().then(response => {
	        		r = response;
	            });
			}
			this.response = r;
			window.scrollTo({top:0, behavior: 'smooth'});
            if(redirect !== false && (response.status == 200 || response.status == 201 || response.status == 204)) {
                setTimeout(function() { window.location.href = redirect ? redirect : window.location.href; }, 1500);
            }
		},
		hide() {
			this.response =  {}
		}
	},
	template: `
		<div class="row" v-if="response['status'] || response['error']">
			<div class="col-12">
				<div class="alert" role="alert" :class="response['status'] == 200 || response['status'] == 201 || response['status'] == 204 ? 'alert-success' : 'alert-danger'">
					{{response['status'] == 200 || response['status'] == 201 || response['status'] == 204 ? 'Transaccion exitosa' : (response['status'] != 500 && response['error'] ? response['error']['message'] : 'No se pudo realizar la acción')}}
				</div>
			</div>
		</div>
	`
}