$(function() {

    $(document).ajaxSend(function() {
        $("#overlay").fadeIn(300);
    });


    $('#formPaseMovilidad').on('submit', function (e) {
        e.preventDefault();

        let form = this;

        const correoInput = $('#correo');
        const correo = correoInput.val();

        if (!validarCorreo(correo)) {
            correoInput[0].setCustomValidity('Correo no válido');
            correoInput.next('.invalid-feedback').text('Correo no válido');
        } else {
            correoInput[0].setCustomValidity('');
            correoInput.next('.invalid-feedback').text('Todo bien');
        }

        const tiposPermitidos = ['image/png'];
        const maxSize = 1 * 1024 * 1024; // 2 MB
        let formularioValido = true;

        $('.archivo-input').each(function () {
            const input = this;
            const archivo = input.files[0];

            input.setCustomValidity('');
            $(input).removeClass('is-valid is-invalid');
            $(input).next('.invalid-feedback').text('');

            if (archivo) {
                if (!tiposPermitidos.includes(archivo.type)) {
                    input.setCustomValidity('Solo se permiten archivos PNG');
                    $(input).addClass('is-invalid');
                    $(input).next('.invalid-feedback').text('Solo se permiten archivos PNG');
                    formularioValido = false;
                } else if (archivo.size > maxSize) {
                    input.setCustomValidity('El archivo debe pesar menos de 1 MB');
                    $(input).addClass('is-invalid');
                    $(input).next('.invalid-feedback').text('El archivo debe pesar menos de 1 MB');
                    formularioValido = false;
                } else {
                    $(input).addClass('is-valid');
                }
            }
        });

        const fechaInput = $('#fecha_regreso');
        const fechaSeleccionada = fechaInput.val();
        const fechaHoy = new Date().toISOString().split('T')[0];

        fechaInput[0].setCustomValidity('');
        fechaInput.removeClass('is-valid is-invalid');
        fechaInput.next('.invalid-feedback').text('');

        if (fechaSeleccionada && fechaSeleccionada < fechaHoy) {
            fechaInput[0].setCustomValidity('La fecha no puede ser menor a hoy');
            fechaInput.addClass('is-invalid');
            fechaInput.next('.invalid-feedback').text('La fecha no puede ser menor a hoy');
            formularioValido = false;
        } else {
            fechaInput.addClass('is-valid');
        }

        if (form.checkValidity() && formularioValido) {
            const formData = new FormData(form);

            $('#mensajeInicial').show();

            setTimeout(() => {
                $.ajax({
                    type: 'POST',
                    url: '/servicios/form-pase-movilidad',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(response){
                        if (response.success === true) {
                            cleanForm();
                            $('#modalPase').modal('show');
                            $('#urlPase').attr('href', response.url);
                            $('#mensajeInicial').hide();
                        } else {
                            $('#mensajeInicial').hide();
                            toastr.warning(response.message);
                        }
                    },
                    error: function(){
                        toastr.error('Ocurrió un error, contacte al área de servicio o intente más tarde.');
                    },
                    complete: function(){
                        setTimeout(function(){
                            $("#overlay").fadeOut(300);
                        }, 500);
                    }
                });
            }, 4000);


        } else {
            $(form).addClass('was-validated');
        }
    });

});

function validarCorreo(correo) {
    const regex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    return regex.test(correo);
}



function cleanForm(){
    $('#formPaseMovilidad')[0].reset();
    $('#formPaseMovilidad')
        .removeClass('was-validated')
        .find('.is-valid, .is-invalid')
        .removeClass('is-valid is-invalid');

    $('#formPaseMovilidad .invalid-feedback').text('');
    $('#formPaseMovilidad input[type="file"]').val('');
    $('#formPaseMovilidad select').val('').trigger('change');

}


function HabilitaCampos() {
    if (document.getElementById('NoApareceArrendador').checked == true) {
        document.getElementById('nombre_arrendadora').disabled = false;
        document.getElementById('id_arrendadora').disabled = true;

        // $('#formPaseMovilidad').data('bootstrapValidator').enableFieldValidators('id_arrendadora', true);
    } else if (document.getElementById('NoApareceArrendador').checked == false) {
        document.getElementById('nombre_arrendadora').disabled = true;
        document.getElementById('id_arrendadora').disabled = false;

        // $('#formPaseMovilidad').data('bootstrapValidator').enableFieldValidators('nombre_arrendadora', false);
    }
}