$(function () {
    if (typeof _prestadores !== 'undefined' && _prestadores.length > 0) {
        getPrestadoresServicios(_prestadores).then(() => {
            // Inicializa List.js sobre los items ya generados
            window.listaPrestadores = new List('cards-wrapper', {
                valueNames: ['nombre', 'giro', 'destino'],
                page: 9,
                pagination: true
            });
        });
    } else {
        console.error('No hay datos para inicializar la lista');
    }

    $('#btn-filter').on('click', function () {
        const textoBusqueda = $('#filter-name').val().toLowerCase().trim();

        const destinoSeleccionado = $('#filter-destinos option:selected').text().trim();
        const giroSeleccionado = $('#filter-giros option:selected').text().trim();

        const destinoFiltro = (destinoSeleccionado && destinoSeleccionado !== 'Seleccionar opción')
            ? destinoSeleccionado
            : '';

        const giroFiltro = (giroSeleccionado && giroSeleccionado !== 'Seleccionar opción')
            ? giroSeleccionado
            : '';

        listaPrestadores.filter(function (item) {
            const nombre = item.values().nombre.toLowerCase();
            const destino = item.values().destino;
            const giro = item.values().giro;

            const coincideNombre = !textoBusqueda || nombre.includes(textoBusqueda);
            const coincideDestino = !destinoFiltro || destino === destinoFiltro;
            const coincideGiro = !giroFiltro || giro === giroFiltro;

            return coincideNombre && coincideDestino && coincideGiro;
        });
    });

    $('#btn-reset').on('click', function () {
        $('#filter-name').val('');
        $('#filter-destinos').val('');
        $('#filter-giros').val('');
        listaPrestadores.filter(); // Limpia todos los filtros
    });

    const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    tooltipTriggerList.forEach(function (tooltipTriggerEl) {
        new bootstrap.Tooltip(tooltipTriggerEl);
    });

});

function getPrestadoresServicios(_prestadores) {
    return new Promise((resolve) => {

        $('#overlay').fadeIn(200);

        $('#container-cards').empty();

        $.each(_prestadores, function (index, value) {

            /** Contenedor principal */
            let _cell = $('<div>', {
                id: 'cell-' + value.id,
                class: 'item col col-md-4 col-sm-12 d-flex align-items-center justify-content-center my-3 d-flex'
            });

            /** Card */
            let _card = $('<div>', {
                class: 'card shadow-sm border-0 flex-fill',
                style: 'width: 18rem;'
            });

            let _cardBody = $('<div>', {class: 'card-body'});

            let _cardFooter = $('<div>', {
                class: 'card-footer d-flex justify-content-between'
            })
                .css('background-color', '#ffffff')
                .css('border', 'none')
                .css('padding-top', '0px');

            /** Titulo e imagen */

            let _cardSectionTittle = $('<div>', {class: 'section-title d-flex align-items-center justify-content-between'});

            let _containTittle = $('<a>', {
                class: 'title-name flex-grow-1'
            });

            let _cardTitle = $('<h3>', {
                class: 'card-title mb-2 text-body-primary nombre',
                text: value.nombre_comercial
            });

            _containTittle.append(_cardTitle);

            let _containImg = $('<div>', {
                class: 'logo-container',
            });

            if(value.logo != 'No disponible'){

                let _img = $('<img>', {
                    src: value.logo,
                    class: 'icon w-100 h-100 object-fit-contain',
                    alt: 'Logo de ' + value.nombre_comercial
                });

                _containImg.append(_img);
            }

            _cardSectionTittle.append(_containTittle, _containImg);

            /** Giro comercial */

            let _cardGiro = $('<div>', {
                class: 'subtitle giro',
                text: value.giro_comercial
            });

            /** Texto del card body */

            let _cardBodyText = $('<div>', {
                class: 'description',
                text: 'Información de contacto:'
            });

            let _cardTelefono = $('<b>', {
                class: '',
                text: 'Teléfono: '
            });

            let _cardCorreo = $('<b>', {
                class: '',
                text: 'Correo: '
            });

            let _cardDestinoActual = $('<b>', {
                text: 'Destino actual: '
            });

            let _textDestinoActual = $('<span>', {
                class: 'destino',
                text: value.destino
            }).css('font-weight','normal');

            _cardDestinoActual.append(_textDestinoActual)

            _cardBodyText.append('<br>', _cardTelefono, value.telefono, '<br>', _cardCorreo, value.telefono, '<br>', _cardDestinoActual);

            /** Horario */

            let _tittleHorario = $('<div>', {
                class: 'subtitle',
                text: 'Horario de atención: '
            });

            let _valueHorario = $('<div>', {
                class: 'description',
                text: value.horario_atencion
            });

            let _cardSectionHorario = $('<div>');

            _cardSectionHorario.append(_tittleHorario, _valueHorario);

            /** Redes sociales e iconos */

            let _containRedesSociales = $('<div>', {class: 'social'});

            let _web = value.sitio_web;

            if (_web && _web.startsWith('http')) {

                let _linkWeb = $('<a>', {
                    target: '_blank',
                    href: value.sitio_web
                });

                let _iconWeb = $('<img>', {
                    src: '/img/icons/social-media/web.svg',
                    class: '',
                    alt: 'icono sitio web'
                });

                _linkWeb.append(_iconWeb)

                _containRedesSociales.append(_linkWeb)
            }

            let _insta = value.instagram;

            if (_insta && _insta.startsWith('http')) {

                let _linkInsta = $('<a>', {
                    target: '_blank',
                    href: value.instagram
                });

                let _iconInsta = $('<img>', {
                    src: '/img/icons/social-media/insta.svg',
                    class: '',
                    alt: 'icono de instagram'
                });

                _linkInsta.append(_iconInsta)

                _containRedesSociales.append(_linkInsta)
            }

            let _fb = value.facebook;

            if (_fb && _fb.startsWith('http')) {

                let _linkFace = $('<a>', {
                    target: '_blank',
                    href: value.facebook
                });

                let _iconFace = $('<img>', {
                    src: '/img/icons/social-media/face.svg',
                    class: '',
                    alt: 'icono de facebook'
                });

                _linkFace.append(_iconFace)

                _containRedesSociales.append(_linkFace)
            }

            /** Estacionamiento, mascotas,  espacio para discapacitados */

            let _containDataCommerce = $('<div>', {class: 'social data_commerce'});

            if(value.estacionamiento == '1'){

                let _iconEstacionamiento = $('<img>', {
                    src: '/img/icons/data-commerce/estacionamiento.svg',
                    title: 'Estacionamiento',
                    alt: 'icono estacionamiento'
                });

                _containDataCommerce.append(_iconEstacionamiento)
            }

            if(value.petfriendly == '1'){

                let _iconPets = $('<img>', {
                    src: '/img/icons/data-commerce/mascotas.svg',
                    title: 'Permite mascotas',
                    alt: 'icono petfriendly'
                });

                _containDataCommerce.append(_iconPets)

            }

            if(value.silla_ruedas == '1'){

                let _iconSilla = $('<img>', {
                    src: '/img/icons/data-commerce/capacidad_diferente.svg',
                    title: 'Acceso silla de ruedas',
                    alt: 'icono acceso silla de ruedas'
                });

                _containDataCommerce.append(_iconSilla)
            }


            _cardFooter.append(_containRedesSociales, _containDataCommerce)

            _cardBody.append(_cardSectionTittle, _cardGiro, _cardBodyText, _cardSectionHorario);
            _card.append(_cardBody, _cardFooter);
            _cell.append(_card);

            $('#container-cards').append(_cell);
        });
        $('#overlay').fadeOut(200);

        resolve();
    });
}


