<?php

namespace TemplateBase;

use TemplateBase\Controller\TemplateBaseController;
use Laminas\ServiceManager\Factory\InvokableFactory;
use Laminas\Router\Http\Segment;


return [
    'router' => [
        'routes' => [
            'template' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/template-base[/:action[/:id]]',
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'id' => '[1-9]\d*',
                    ],
                    'defaults' => [
                        'controller' => TemplateBaseController::class,
                        'action' => 'index'
                    ],
                ]
            ]
        ]
    ],
    'controllers' => [
        'factories' => [
            TemplateBaseController::class => InvokableFactory::class
        ]
    ],
    'view_manager' => [
        'display_not_found_reason' => true,
        'display_exceptions' => true,
        'doctype' => 'HTML5',
        'template_map' => [
            'layout/layout' => __DIR__ . '/../view/layout/layout.phtml',
        ],
        'template_path_stack' => [
            __DIR__ . '/../view',
        ]
    ]
];