<?php
namespace Reports\Controller;

use Laminas\Mvc\Controller\AbstractActionController;
use Laminas\View\Model\ViewModel;
use Application\Controller\MainController;
use Laminas\ServiceManager\ServiceManager;
use Application\Library\Api\Api;
use Laminas\Http\Request;
use Laminas\Http\Headers;

/**
 * It handles the actions for committee reports.
 * @author workstation2
 */
class CommitteesController extends MainController
{
    
    /**
     * Constructor.
     * @param ServiceManager $sm
     */
    public function __construct(ServiceManager $sm)
    {
        parent::__construct($sm);
        $this->module = $this->translator->translate('Reportes');
        $this->controller = $this->translator->translate('Comités');
    }
    
    /**
     * Datatable view.
     * {@inheritDoc}
     * @see \Laminas\Mvc\Controller\AbstractActionController::indexAction()
     */
    public function indexAction()
    {
        return new ViewModel();
    }

    /**
     * Committee report.
     * @return \Laminas\Stdlib\ResponseInterface
     */
    public function reportAction()
    {
        $reportResult = Api::request('/committee-members-report', Request::METHOD_POST, $_POST);
        if($reportResult->getStatusCode() != 200) {
            return $this->redirect()->toRoute('reportCommittees');
        }
        $headers = new Headers();
        $headers->addHeaders([
            'Content-Type' => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
            'Content-Disposition' => 'attachment;filename=Report.xlsx'
        ]);
        $this->getResponse()->setHeaders($headers);
        $this->getResponse()->setContent($reportResult->getBody());
        return $this->getResponse();
    }
    
}
