<?php
namespace General\Controller;

use Laminas\View\Model\ViewModel;
use Application\Controller\MainController;
use Application\Library\Api\Api;
use Application\Library\Complements\BodyMap;
use Application\Library\SocialNetworks\AppleHandler;
use Application\Library\SocialNetworks\EmailHandler;
use Application\Library\SocialNetworks\FacebookHandler;
use Application\Library\SocialNetworks\GoogleHandler;
use Laminas\Http\Request;
use Laminas\Router\RouteMatch;
use Laminas\ServiceManager\ServiceManager;

use function PHPUnit\Framework\returnSelf;

/**
 * It handles the actions for managing users data.
 * @author workstation2
 */
class AuthSocialNetworkController extends MainController
{
    
    /**
     * Constructor.
     * @param ServiceManager $sm
     */
    public function __construct(ServiceManager $sm)
    {
        parent::__construct($sm);
        $this->module = $this->translator->translate('Publico');
        $this->controller = $this->translator->translate('General');
    }

    /**
     * Login view.
     */
    public function indexAction()
    {

        $params = [
            'where' => 'frmIdIdioma eq ' . $_COOKIE['idIdioma']
        ];

        $fetch = Api::request('/generos', Request::METHOD_GET, $params);
        $json = json_decode($fetch->getBody(), true);
        $genero = $json['data'];

        $masculino = $genero[0]['frmNombreGenero'];
        $femenino = $genero[1]['frmNombreGenero'];

        $viewModel = new ViewModel();
        $viewModel->setVariables([
            'generoM' => $masculino,
            'generoF' => $femenino
        ]);
        return $viewModel;
    }

    /**
     * Login with email action.
     */
    public function iniciarSesionAction()
    {
        $request = $this->getRequest();
        $data = $request->getPost();
        $emailHandler = new EmailHandler($data['email'], $data['password']);
        $handlerResponse = $emailHandler->inciarSesion();
        $response = $this->getResponse();
        $response->setContent(json_encode($handlerResponse));
        return $response;
    }

    /**
     * Register and login with email action.
     */
    public function crearCuentaAction()
    {
        $request = $this->getRequest();
        $data = $request->getPost();
        $emailHandler = new EmailHandler($data['email'], $data['password'], $data['nombre'], $data['apellidoPaterno'], $data['apellidoMaterno'],
                        $data['idGenero'], $data['fechaNacimiento']);
        $handlerResponse = $emailHandler->registrar();
        $response = $this->getResponse();
        $response->setContent(json_encode($handlerResponse));

        return $response;
    }

    /**
     * Login with facebook action.
     */
    public function facebookAccountAction(){
        $facebookSignInHandler = new FacebookHandler();
        $request = $this->getRequest();
        if($request->getMethod() == 'GET'){
            $authorize_url = $facebookSignInHandler->generateAuthorizationUrl();
            $body = [
                "code" => "1",
                "content" => $authorize_url
            ];
            $response = $this->getResponse();
            $response->setContent(json_encode($body));
            return $response;
        } 
    }

    /**
     * Login with facebook is successfull action.
     */
    public function facebookSuccessfullAction(){
        $facebookSignInHandler = new FacebookHandler();
        $handlerResponse = $facebookSignInHandler->handleSignInResponse();
        return $this->redirect()->toRoute('/');
    }
    
    /**
     * Login with google account action.
     */
    public function googleAccountAction(){
        $googleSignInHandler = new GoogleHandler();
        $request = $this->getRequest();
        if($request->getMethod() == 'GET'){
            $authorize_url = $googleSignInHandler->generateAuthorizationUrl();
            $body = [
                "code" => "1",
                "content" => $authorize_url
            ];
            $response = $this->getResponse();
            $response->setContent(json_encode($body));
            return $response;
        }
    }

    /**
     * Login with google account is successfull action.
     */
    public function googleSuccessfullAction(){
        $googleSignInHandler = new GoogleHandler();
        $handlerResponse = $googleSignInHandler->handleSignInResponse();
        return $this->redirect()->toRoute('/');
    }

    /**
     * Login with apple account action.
     */
    public function appleAccountAction(){
        $appleSignInHandler = new AppleHandler();
        $request = $this->getRequest();
        if($request->getMethod() == 'GET'){
            $authorize_url = $appleSignInHandler->generateAuthorizationUrl();
            $body = [
                "code" => "1",
                "content" => $authorize_url
            ];
            $response = $this->getResponse();
            $response->setContent(json_encode($body));
            return $response;
        } 
    }

    /**
     * Login with apple account is successfull action.
     */
    public function appleSuccessfullAction(){
        $appleSignInHandler = new AppleHandler();
        $handlerResponse = $appleSignInHandler->handleSignInResponse();
        return $this->redirect()->toRoute('/');
    }
}
