<?php
namespace Catalogs\Controller;

use Laminas\Mvc\Controller\AbstractActionController;
use Laminas\View\Model\ViewModel;
use Application\Controller\MainController;
use Laminas\ServiceManager\ServiceManager;
use Application\Library\Api\Api;
use Laminas\Http\Request;
use Laminas\Http\Headers;

/**
 * It handles the actions for managing committees.
 * @author workstation2
 */
class CommitteesController extends MainController
{
    
    /**
     * Constructor.
     * @param ServiceManager $sm
     */
    public function __construct(ServiceManager $sm)
    {
        parent::__construct($sm);
        $this->module = $this->translator->translate('Catálogos');
        $this->controller = $this->translator->translate('Comités');
    }
    
    /**
     * Datatable view.
     * {@inheritDoc}
     * @see \Laminas\Mvc\Controller\AbstractActionController::indexAction()
     */
    public function indexAction()
    {
        return new ViewModel();
    }
    
    /**
     * Create view.
     * @return \Laminas\View\Model\ViewModel
     */
    public function createAction()
    {
        return new ViewModel();
    }
    
    /**
     * Edit view.
     * @return \Laminas\View\Model\ViewModel
     */
    public function editAction()
    {
        return new ViewModel();
    }
    
    /**
     * Details view.
     * @return \Laminas\View\Model\ViewModel
     */
    public function detailsAction()
    {
        return new ViewModel();
    }
    
    /**
     * Delete view.
     * @return \Laminas\View\Model\ViewModel
     */
    public function deleteAction()
    {
        return new ViewModel();
    }
    
    /**
     * Committee report.
     * @return \Laminas\Stdlib\ResponseInterface
     */
    public function reportAction()
    {
        $reportResult = Api::request('/committee-report/'.$this->params()->fromRoute('id'), Request::METHOD_GET);
        if($reportResult->getStatusCode() != 200) {
            return $this->redirect()->toRoute('committees');
        }
        $headers = new Headers();
        $headers->addHeaders([
            'Content-Type' => 'application/pdf',
            'Content-Disposition' => 'inline;filename=Report.pdf',
            'Cache-Control' => 'private, max-age=0, must-revalidate',
            'Pragma' => 'public'
        ]);
        $this->getResponse()->setHeaders($headers);
        $this->getResponse()->setContent($reportResult->getBody());
        return $this->getResponse();
    }
    
}
