<?php

namespace Application\Library\SocialNetworks;

use Application\Library\Api\Api;
use Exception;
use Facebook\Facebook;
use Laminas\Http\Request;

/**
 * It manages login google Account.
 * @author desarrollo01
 */
class FacebookHandler
{
    private $appId;
    private $appSecret;
    private $faceBookClient;
    private $helper;
    private $redirectUri;
    private $permissions;


    public function __construct(
        $appId = '1126842354983364',
        $appSecret = '3bd79df37402b76b04dfb8f3e9bc29a0',
        $redirectUri = 'auth-social-network/facebook-successfull',
        $permissions = ['email', 'user_birthday', 'user_gender']
    ) {
        $this->appId = $appId;
        $this->appSecret = $appSecret;
        $this->redirectUri = (empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://$_SERVER[HTTP_HOST]/" . $redirectUri;
        $this->permissions = $permissions;
        $this->initializeFacebookClient();
    }

    private function initializeFacebookClient()
    {
        $this->faceBookClient = new Facebook([
            'app_id' => $this->appId,
            'app_secret' => $this->appSecret,
            'default_graph_version' => 'v2.10',
        ]);

        $this->helper = $this->faceBookClient->getRedirectLoginHelper();
    }

    public function generateAuthorizationUrl()
    {
        return $this->helper->getLoginUrl($this->redirectUri, $this->permissions);
    }


    public function handleSignInResponse()
    {
        if (isset($_GET['code'])) {

            try {
                $accessToken = $this->helper->getAccessToken();
                $this->faceBookClient->setDefaultAccessToken($accessToken);
                $profileRequest = $this->faceBookClient->get('/me?fields=name,first_name,last_name,email,birthday,gender');
                $userInfo = $profileRequest->getGraphUser();

                $idRedSocial = 2;
                $uId = $userInfo['id'];
                $nombre = $userInfo['first_name'];
                $apellido = $userInfo['last_name'];
                $correoElectronico = $userInfo['email'];
                $fechaNacimiento = $userInfo['birthday'];
                $genero = $userInfo['gender'];
                $fechaNacimientoObject = $userInfo['birthday'];
                $fechaNacimientoFormat = $fechaNacimientoObject->format('Y-m-d');

                $params = [
                    'where' => 'frmUidUsuariosRedesSociales eq ' . $uId .
                    '|or|frmIdNombreUsuarioUsuario eq '.$correoElectronico
                ];
                $existente = Api::request('/validate-uid', request::METHOD_GET, $params);
                $body = json_decode($existente->getBody(), true);
                $loginData = [
                    'frmCorreo' => $correoElectronico,
                    'frmContraseña' => null,
                    'frmIdRedSocial' => $idRedSocial,
                    'frmNombre' => $nombre,
                    'frmApellidoPaterno' => $apellido,
                    'frmApellidoMaterno' => null,
                    'frmIdGenero' => $genero == 'male' ? '1' : '2',
                    'frmFechaNacimiento' => $fechaNacimientoFormat,
                    'frmUidRedSocial' => $uId
                ];

                foreach (@$body['data']  as $k => $v) {
                    if (@$v['frmUidUsuariosRedesSociales'] == $uId) {
                        $loginResult = Api::request('/login', request::METHOD_POST, $loginData, false);
                        $login = json_decode($loginResult->getBody(), true);
                        setcookie('datosUsuario', serialize($login['datosUsuario']), 0, '/');
                        $response = [
                            'code' => '1',
                            'message' => 'Inicio de sesion exitoso'
                        ];
                        return $response;
                    }
                }
                $registroApiResult = Api::request('/registro', request::METHOD_POST, $loginData, false);
                $registroResult = json_decode($registroApiResult->getBody(), true);
                if (isset($registroResult['error'])) {
                    $response = [
                        'code' => '-1',
                        'message' => $registroResult['error']['message']
                    ];
                    return $response;
                }
                $loginResult = Api::request('/login', request::METHOD_POST, $loginData, false);
                $login = json_decode($loginResult->getBody(), true);
                setcookie('datosUsuario', serialize($login['datosUsuario']), 0, '/');
                $response = [
                    'code' => '1',
                    'message' => 'Inicio de sesion exitoso'
                ];
                return $response;
            } catch (Exception $e) {
                return $response = [
                    'code' => '-1',
                    'message' => 'Inicio de sesion incorrecto'
                ];
            }
        } else {
            return $response = [
                'code' => '-1',
                'message' => 'Inicio de sesion incorrecto'
            ];
        }
    }
}
