<?php

namespace Application\Library\SocialNetworks;

use Application\Library\Api\Api;
use Exception;
use Firebase\JWT\JWT;
use Laminas\Http\Request;

/**
 * It manages login google Account.
 * @author desarrollo01
 */
class AppleHandler
{
    private $clientId;
    private $redirectUri;
    private $teamId;
    private $keyId;
    private $sub;
    private $aud;

    public function __construct(
        $clientId = 'mx.bemira.dev.client',
        $redirectUri = 'auth-social-network/apple-successfull',
        $teamId = 'N6V48N653P',
        $keyId = 'UHU2FK7J2W',
        $sub = 'mx.bemira.dev.client',
        $aud = 'https://appleid.apple.com'
    ) {
        $this->clientId = $clientId;
        $this->redirectUri = (empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://$_SERVER[HTTP_HOST]/" . $redirectUri;
        $this->teamId = $teamId;
        $this->keyId = $keyId;
        $this->sub = $sub;
        $this->aud = $aud;
    }

    public function generateClientSecret()
    {
        return $this->generateJWT($this->teamId, $this->keyId, $this->sub, $this->aud);
    }

    public function handleSignInResponse()
    {
        if (isset($_POST['code'])) {
            try {
                $idRedSocial       = 4;
                $uId               = 0;
                $nombre            = '';
                $apellido          = '';
                $correoElectronico = '';
                $fechaNacimiento   = '';
                $genero            = '';


                if (isset($_POST['user'])) {
                    $userInfo          = json_decode($_POST['user']);
                    $nombre            = $userInfo->name->firstName;
                    $apellido          = $userInfo->name->lastName;
                }

                $idToken = $_POST['id_token'];
                $claims =
                    explode('.', $idToken)[1];
                $claims = json_decode(base64_decode($claims));
                $uId = $claims->sub;
                $correoElectronico = $claims->email;
                $params = [
                    'where' => 'frmUidUsuariosRedesSociales eq ' . $uId .
                    '|or|frmIdNombreUsuarioUsuario eq '.$correoElectronico
                ];
                $existente = Api::request('/validate-uid', request::METHOD_GET, $params);
                $body = json_decode($existente->getBody(), true);

                $loginData = [
                    'frmCorreo' => $correoElectronico,
                    'frmContraseña' => null,
                    'frmIdRedSocial' => $idRedSocial,
                    'frmNombre' => $nombre,
                    'frmApellidoPaterno' => $apellido,
                    'frmApellidoMaterno' => null,
                    'frmIdGenero' => null,
                    'frmFechaNacimiento' => null,
                    'frmUidRedSocial' => $uId
                ];

                foreach (@$body['data']  as $k => $v) {
                    if (@$v['frmUidUsuariosRedesSociales'] == $uId) {
                        $loginResult = Api::request('/login', request::METHOD_POST, $loginData, false);
                        $login = json_decode($loginResult->getBody(), true);
                        setcookie('datosUsuario', serialize($login['datosUsuario']), 0, '/');
                        $response = [
                            'code' => '1',
                            'message' => 'Inicio de sesion exitoso'
                        ];
                        return $response;
                    }
                }
                $registroApiResult = Api::request('/registro', request::METHOD_POST, $loginData, false);
                $registroResult = json_decode($registroApiResult->getBody(), true);
                if (isset($registroResult['error'])) {
                    $response = [
                        'code' => '-1',
                        'message' => $registroResult['error']['message']
                    ];
                    return $response;
                }
                $loginResult = Api::request('/login', request::METHOD_POST, $loginData, false);
                $login = json_decode($loginResult->getBody(), true);
                setcookie('datosUsuario', serialize($login['datosUsuario']), 0, '/');
                $response = [
                    'code' => '1',
                    'message' => 'Inicio de sesion exitoso'
                ];
                return $response;
            } catch (Exception $e) {
                return $response = [
                    'code' => '-1',
                    'message' => 'Inicio de sesion incorrecto'
                ];
            }
        } else
            return $response = [
                'code' => '-1',
                'message' => 'Inicio de sesion incorrecto'
            ];
    }

    public function generateAuthorizationUrl()
    {
        $_SESSION['state'] = bin2hex(random_bytes(5));

        return 'https://appleid.apple.com/auth/authorize' . '?' . http_build_query([
            'response_type' => 'code id_token',
            'response_mode' => 'form_post',
            'client_id' => $this->clientId,
            'redirect_uri' => $this->redirectUri,
            'state' => $_SESSION['state'],
            'scope' => 'name email',
        ]);
    }

    private function generateJWT($teamId, $keyId, $sub, $aud)
    {
        $iat = strtotime('now');
        $exp = strtotime('+60days');

        try {
            $keyContent = file_get_contents('key.txt');
            if ($keyContent === false) {
                throw new Exception('Error reading key content');
            }

            $token = JWT::encode([
                'iss' => $teamId,
                'iat' => $iat,
                'exp' => $exp,
                'aud' => $aud,
                'sub' => $sub,
            ], $keyContent, 'ES256', $keyId);

            return $token;
        } catch (Exception $e) {
            // Log or handle the error accordingly
            return null;
        }
    }
}
