<?php 

namespace Application\Library\Data;

class Huracanes {
    /**
     * @var array $data Lista con el contenido para la página de Temporada de huracanes por idioma
     */
    private $data;

    /**
     * 
     */
    const LANG_ESP = 1;
    const LANG_ENG = 2;
    const LANG_FRA = 3;
    const LANG_DEU = 4;
    const LANG_POR = 5;
    const LANG_RUS = 6;
    const LANG_FALLBACK = 1;
    const BASE_PATH = "https://apiga.bemira.mx:443/";

    public function __construct()
    {
        $this->data =
        [
            [
                "frmIdIdioma" => self::LANG_ESP,
                "frmBasePath" => self::BASE_PATH,
                "frmInfo" => [
                    "subMenu" => "Temporada de huracanes en el caribe mexicano",
                    "contenido" => [
                        "texto1" => "Debido a su localización, el Caribe Mexicano es vulnerable al impacto de huracanes tropicales en la temporada del 01 de junio al 30 de noviembre cada año. \n\nEl estado de Quintana Roo cuenta con una sólida cultura de protección civil, especialmente con protocolos para actuar en caso del impacto de un huracán y preservar la seguridad y el bienestar de la población y turistas..\n\n El sector hotelero está eficazmente preparado para atender a todos los turistas ante cualquier contingencia hidrometereológica.  Los hoteles deben de contar con un manual interno de protección civil que deben de actualizar cada año, además de que regularmente revisan sus instalaciones y capacitan a su personal para preservar la seguridad de los huéspedes, y de ser necesario, aplicar protocolos de evacuación y primeros auxilios.\n\n Existen diferentes agencias meteorológicas que monitorean el desarrollo de los huracanes para elaborar pronósticos. De esta manera, las autoridades pueden emitir una alerta a la población y llevar a cabo medidas preventivas.\n Ante la posibilidad de un huracán en el Caribe Mexicano, saber cómo mantenerse seguro es fundamental. La prevención es la mejor herramienta para estar bien preparado.",

                        "texto2" => "Les compartimos algunas recomendaciones para la temporada de huracanes:",

                        "list1" => [
                            "1. Conserva la calma y tranquiliza a tus familiares. Una persona alterada puede cometer muchos errores.",
                            "2. Mantente informado respecto a la evolución del fenómeno hidrometeorológico a través de los canales oficiales del gobierno de Quintana Roo.",
                            "3. No divulgue ni haga caso a rumores.",
                            "4. Sigue y atiende las instrucciones de las autoridades de Protección Civil.",
                            "5. Sigue y atiende las instrucciones del medio de hospedaje dónde estés.",
                            "6. Guarda documentos personales en bolsas de plástico.",
                            "7. Lleva siempre una identificación oficial con fotografía y copia del pasaporte, así como una copia electrónica de los mismos.",
                            "8. Informa a familiares y amigos sobre tu itinerario de viaje.",
                            "9. Antes de ir al aeropuerto, confirma la operación del vuelo con la aerolínea, ya que dadas las circunstancias los itinerarios podrían verse afectados. No acudir al aeropuerto si no tienes un vuelo comprado y confirmado.",
                            "10. Lleva siempre contigo los medicamentos que necesites de forma regular.",
                            "11. Si estás en un medio de hospedaje tradicional, estos cuentan con refugios propios para sus huéspedes y harán la evacuación correspondiente en caso de ser necesario.",
                            "12. Si estás en otro medio de hospedaje, infórmate de la seguridad de la zona y la ubicación de los refugios temporales. Sigue las instrucciones de la autoridad caso sea necesario evacuar.",
                            "13. Ten a la mano artículos de emergencia como botiquín de primeros auxilios, alimentos enlatados, agua purificada y linterna y radio de pilas.",
                            "14. En caso de estar en algún refugio permanezca en él hasta que las autoridades indiquen que puede regresar.",
                            "15. Use botas o los zapatos más cerrados que tenga.",
                        ],

                        "subtitulo1" => "Sistema de alerta temprana para ciclones tropicales (SIAT CT)",

                        "texto4" => "Es una guía utilizada por las autoridades de Protección Civil, para la determinación de fases de acercamiento por ciclón tropical en cualquiera de sus modalidades (depresión tormenta tropical o huracán) en la República Mexicana. Cada una de las etapas del aviso es representada por un color.\n\n Se compone de dos fases de alertamiento, dependiendo si el ciclón se encuentra acercándose a un área afectable o si se encuentra alejándose de la misma.",

                        "acordeon" => [
                            [
                                "titulo" => "ALERTA AZUL",
                                "contenido" => [
                                    "texto1" =>  "Peligro mínimo",
                                    "texto2" => [
                                        "etiqueta" => "Acercamiento: ",
                                        "valor" => "Aviso",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Alejamiento: ",
                                        "valor" => "Aviso",
                                    ], 
                                    "texto4" => "La alerta azul se establece cuando se ha detectado la presencia de una perturbación tropical o cuando éste permanece a 72 horas de posibilidad de que la línea de vientos de 63 km/h del ciclón comience a afectar. Se emitirán boletines cada 24 hrs.",
                                    "color" => "#0f87ff",

                                ]
                            ],
                            [
                                "titulo" => "ALERTA VERDE",
                                "contenido" => [
                                    "texto1" =>  "Peligro bajo",
                                    "texto2" => [
                                        "etiqueta" => "Acercamiento: ",
                                        "valor" => "Prevención”",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Alejamiento: ",
                                        "valor" => "Vigilancia”",
                                    ], 
                                    "texto4" => "La alerta verde se establece cuando una perturbación tropical se ha acercado a una distancia tal que haga prever el impacto de la línea de vientos de 63km/h en un área afectable en un tiempo de entre 72 y 24 hrs. dependiendo de su intensidad. Se emitirán boletines cada 12 hrs. ",
                                    "color" => "#02cc46",

                                ]
                            ], [
                                "titulo" => "ALERTA AMARILLA",
                                "contenido" => [
                                    "texto1" =>  "Peligro moderado",
                                    "texto2" => [
                                        "etiqueta" => "Acercamiento: ",
                                        "valor" => "Preparación",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Alejamiento: ",
                                        "valor" => "Seguimiento",
                                    ], 
                                    "texto4" => "La alerta amarilla se establece cuando una perturbación tropical se ha acercado a una distancia tal que haga prever el impacto de la línea de vientos de 63 km/h en un área afectada en un tiempo de entre 60 y 12 hrs. dependiendo de su intensidad. Se emitirán boletines cada 6 hrs. ",
                                    "color" => "#ffee0b",

                                ]
                            ], [
                                "titulo" => "ALERTA NARANJA",
                                "contenido" => [
                                    "texto1" =>  "Peligro alto",
                                    "texto2" => [
                                        "etiqueta" => "Acercamiento: ",
                                        "valor" => "Alarma",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Alejamiento: ",
                                        "valor" => "Alarma",
                                    ], 
                                    "texto4" => "La alerta naranja se establece cuando una perturbación tropical se ha acercado a una distancia tal que haga prever el impacto de línea de vientos de 63 km/h en un área afectable en un tiempo de entre 36 y 6 hrs. dependiendo de su intensidad. Se emitirán boletines cada 3 hrs.",
                                    "color" => "#fc7c01",

                                ]
                            ], [
                                "titulo" => "ALERTA ROJA",
                                "contenido" => [
                                    "texto1" =>  "Peligro máximo",
                                    "texto2" => [
                                        "etiqueta" => "Acercamiento: ",
                                        "valor" => "Afectación",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Alejamiento: ",
                                        "valor" => "Afectación",
                                    ], 
                                    "texto4" => "La alerta roja se establece cuando una perturbación tropical se ha acercado a una distancia tal que haga prever el impacto de la línea de vientos de 63 km /h en un área afectable, o bien que pueda afectar en un tiempo igual o menor a 18 hrs. Se emitirán boletines cada 3 hrs.",
                                    "color" => "#fd0304",

                                ]
                            ],
                        ],
                    ]
                ]
            ],
            [
                "frmIdIdioma" => self::LANG_ENG,
                "frmBasePath" => self::BASE_PATH,
                "frmInfo" => [
                    "subMenu" => "Hurricane season in the mexican caribbean",
                    "contenido" => [
                        "texto1" => "Due to its location, the Mexican Caribbean is vulnerable to the impact of tropical hurricanes in the season from June 1 to November 30 each year.\n The state of Quintana Roo has a solid culture of civil protection, especially with protocols to act in the event of the impact of a hurricane and preserve the safety and well-being of the population and tourists.\n The hotel sector is effectively prepared to serve all tourists in the event of any hydro meteorological contingency. Hotels must have an internal civil protection manual that must be updated every year, in addition to regularly reviewing their facilities and training their staff to preserve the safety of guests, and if necessary, apply evacuation and first aid protocols. aids.\n There are different meteorological agencies that monitor the development of hurricanes to prepare forecasts. In this way, the authorities can issue an alert to the population and carry out preventive measures.\n Given the possibility of a hurricane in the Mexican Caribbean, knowing how to stay safe is essential. Prevention is the best tool to be well prepared.",

                        "texto2" => "We share some recommendations for hurricane season:",

                        "list1" => [
                            "1. Stay calm and reassure your family members. An upset person can make many mistakes.",
                            "2. Stay informed regarding the evolution of the hydro meteorological phenomenon through the official channels of the government of Quintana Roo.",
                            "3. Do not spread or listen to rumors.",
                            "4. Follow and comply with the instructions of the Civil Protection authorities.",
                            "5. Follow and follow the instructions of the accommodation where you are.",
                            "6. Store personal documents in plastic bags.",
                            "7. Always carry an official identification with a photo and a copy of your passport, as well as an electronic copy of them.",
                            "8. Inform family and friends about your travel itinerary.",
                            "9. Before going to the airport, confirm the flight operation with the airline, since given the circumstances the itineraries could be affected. Do not go to the airport if you do not have a purchased and confirmed flight.",
                            "10. Always carry the medications you need regularly with you.",
                            "11. If you are in a traditional lodging environment, they have their own shelters for their guests and will carry out the corresponding evacuation if necessary.",
                            "12. If you are in another accommodation, find out about the security of the area and the location of temporary shelters. Follow the instructions of the authority if it is necessary to evacuate.",
                            "13. Have emergency items on hand such as a first aid kit, canned food, purified water, and a flashlight and battery-powered radio.",
                            "14. If you are in a shelter, stay there until the authorities indicate that you can return.",
                            "15. Wear boots or the closest shoes you have.",
                        ],

                        "subtitulo1" => "Early warning system for tropical cyclones (SIAT CT)",

                        "texto4" => "It is a guide used by Civil Protection authorities to determine the approach phases of a tropical cyclone in any of its forms (tropical storm depression or hurricane) in the Mexican Republic. Each of the stages of the notice is represented by a color.\n It is made up of two warning phases, depending on whether the cyclone is approaching an affected area or whether it is moving away from it.",

                        "acordeon" => [
                            [
                                "titulo" => "BLUE ALERT",
                                "contenido" => [
                                    "texto1" =>  "Minimal danger",
                                    "texto2" => [
                                        "etiqueta" => "Approach: ",
                                        "valor" => "Notice",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Removal: ",
                                        "valor" => "Notice",
                                    ], 
                                    "texto4" => "The blue alert is established when the presence of a tropical disturbance has been detected or when there remains a 72-hour possibility that the cyclones 63 km/h wind line will begin to affect. Bulletins will be issued every 24 hours.",
                                    "color" => "#0f87ff",

                                ]
                            ],
                            [
                                "titulo" => "GREEN ALERT",
                                "contenido" => [
                                    "texto1" =>  "Low danger",
                                    "texto2" => [
                                        "etiqueta" => "Approach: ",
                                        "valor" => "Prevention",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Removal: ",
                                        "valor" => "Surveillance",
                                    ], 
                                    "texto4" => "The green alert is established when a tropical disturbance has approached such a distance that the impact of the 63km/h wind line is expected in an affected area in a time of between 72 and 24 hours depending on its intensity. Bulletins will be issued every 12 hours.",
                                    "color" => "#02cc46",

                                ]
                            ], [
                                "titulo" => "YELLOW ALERT",
                                "contenido" => [
                                    "texto1" =>  "Moderate danger",
                                    "texto2" => [
                                        "etiqueta" => "Approach: ",
                                        "valor" => "Preparation",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Removal: ",
                                        "valor" => "Follow-up",
                                    ], 
                                    "texto4" => "The yellow alert is established when a tropical disturbance has approached such a distance that the impact of the 63 km/h wind line is expected in an affected area in a time of between 60 and 12 hours depending on its intensity. Bulletins will be issued every 6 hours.",
                                    "color" => "#ffee0b",
                                ]
                            ], [
                                "titulo" => "ORANGE ALERT",
                                "contenido" => [
                                    "texto1" =>  "High danger",
                                    "texto2" => [
                                        "etiqueta" => "Approach: ",
                                        "valor" => "Alarm",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Removal: ",
                                        "valor" => "Alarm",
                                    ], 
                                    "texto4" => "The orange alert is established when a tropical disturbance has approached such a distance that the impact of a 63 km/h wind line is expected in an affected area in a time of between 36 and 6 hours depending on its intensity. Bulletins will be issued every 3 hours.",
                                    "color" => "#fc7c01",
                                ]
                            ], [
                                "titulo" => "RED ALERT",
                                "contenido" => [
                                    "texto1" =>  "Maximum danger",
                                    "texto2" => [
                                        "etiqueta" => "Approach: ",
                                        "valor" => "Affectation",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Removal: ",
                                        "valor" => "Affectation",
                                    ], 
                                    "texto4" => "The red alert is established when a disturbance \n Tropical storm has approached to a distance such that the impact of the 63 km/h wind line on an affected area is foreseen, or that it may affect in a time equal to or less than 18 hours. Bulletins will be issued every 3 hours.",
                                    "color" => "#fd0304",
                                ]
                            ],
                        ],
                    ]
                ]
            ],
            [
                "frmIdIdioma" => self::LANG_POR,
                "frmBasePath" => self::BASE_PATH,
                "frmInfo" => [
                    "subMenu" => "Temporada de furacões no Caribe Mexicano",
                    "contenido" => [
                        "texto1" => "Devido à sua localização, o Caribe Mexicano é vulnerável ao impacto de furacões tropicais na temporada de 01 de junho a 30 de novembro de cada ano. \n\nO estado de Quintana Roo conta com uma sólida cultura de proteção civil, especialmente com protocolos para agir em caso de impacto de furacão e preservar a segurança e o bem-estar da população e turistas.\n\nO setor hoteleiro está eficazmente preparado para atender a todos os turistas diante de qualquer contingência hidrometeorológica. Os hotéis devem possuir um manual interno de proteção civil que devem atualizar a cada ano, além de que regularmente revisam suas instalações e capacitam seu pessoal para preservar a segurança dos hóspedes e, se necessário, aplicar protocolos de evacuação e primeiros socorros.\n\nExistem diferentes agências meteorológicas que monitoram o desenvolvimento dos furacões para elaborar prognósticos. Dessa forma, as autoridades podem emitir um alerta à população e realizar medidas preventivas.\n Diante da possibilidade de um furacão no Caribe Mexicano, saber como manter-se seguro é fundamental. A prevenção é a melhor ferramenta para estar bem preparado.",

                        "texto2" => "Compartilhamos algumas recomendações para a temporada de furacões:",

                        "list1" => [
                            "1. Mantenha a calma e tranquilize seus familiares. Uma pessoa alterada pode cometer muitos erros.",
                            "2. Mantenha-se informado sobre a evolução do fenômeno hidrometeorológico através dos canais oficiais do governo de Quintana Roo.",
                            "3. Não divulgue nem dê ouvidos a rumores.",
                            "4. Siga e atenda às instruções das autoridades de Proteção Civil.",
                            "5. Siga e atenda às instruções do estabelecimento de hospedagem onde estiver.",
                            "6. Guarde documentos pessoais em sacos plásticos.",
                            "7. Sempre leve consigo uma identificação oficial com foto e cópia do passaporte, assim como uma cópia eletrônica dos mesmos.",
                            "8. Informe familiares e amigos sobre seu itinerário de viagem.",
                            "9. Antes de ir para o aeroporto, confirme a operação do voo com a companhia aérea, pois, dadas as circunstâncias, os itinerários podem ser afetados. Não vá ao aeroporto se você não tiver um voo comprado e confirmado.",
                            "10. Sempre leve consigo os medicamentos que você precisa regularmente.",
                            "11. Se estiver em um estabelecimento de hospedagem tradicional, eles têm seus próprios abrigos para os hóspedes e farão a evacuação correspondente, se necessário.",
                            "12. Se estiver em outro tipo de hospedagem, informe-se sobre a segurança da área e a localização dos abrigos temporários. Siga as instruções da autoridade caso seja necessário evacuar.",
                            "13. Tenha à mão itens de emergência, como kit de primeiros socorros, alimentos enlatados, água purificada, lanterna e rádio a pilhas.",
                            "14. No caso de estar em um abrigo, permaneça lá até que as autoridades indiquem que é seguro retornar.",
                            "15. Use botas ou os sapatos mais fechados que tiver.",
                        ],

                        "subtitulo1" => "Sistema de alerta precoce para ciclones tropicais (SIAT CT)",

                        "texto4" => "É um guia utilizado pelas autoridades de Proteção Civil para determinar as fases de aproximação de um ciclone tropical em qualquer uma de suas modalidades (depressão, tempestade tropical ou furacão) no México. Cada uma das etapas de alerta é representada por uma cor.\n\nEle consiste em duas fases de alerta, dependendo se o ciclone está se aproximando de uma área afetada ou se afastando da mesma.",

                        "acordeon" => [
                            [
                                "titulo" => "ALERTA AZUL",
                                "contenido" => [
                                    "texto1" =>  "Risco mínimo",
                                    "texto2" => [
                                        "etiqueta" => "Aproximação: ",
                                        "valor" => "Aviso",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Afastamento: ",
                                        "valor" => "Aviso",
                                    ], 
                                    "texto4" => "O alerta azul é estabelecido quando a presença de uma perturbação tropical é detectada ou quando ela permanece a 72 horas de possibilidade de que a linha de ventos de 63 km/h do ciclone comece a afetar. Boletins serão emitidos a cada 24 horas.",
                                    "color" => "#0f87ff",
                                    ]

                            ],
                            [
                                "titulo" => "ALERTA VERDE",
                                "contenido" => [
                                    "texto1" =>  "Risco baixo",
                                    "texto2" => [
                                        "etiqueta" => "Aproximação:",
                                        "valor" => "Prevenção",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Afastamento:",
                                        "valor" => "Vigilância",
                                    ], 
                                    "texto4" => "O alerta verde é estabelecido quando uma perturbação tropical se aproximou a uma distância que sugere o impacto da linha de ventos de 63km/h em uma área afetada em um período entre 72 e 24 horas, dependendo de sua intensidade. Boletins serão emitidos a cada 12 horas.",
                                    "color" => "#02cc46",
                                ]
                            ], [
                                "titulo" => "ALERTA AMARELA",
                                "contenido" => [
                                    "texto1" =>  "Perigo moderado",
                                    "texto2" => [
                                        "etiqueta" => "Aproximação:",
                                        "valor" => "Preparação",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Afastamento:",
                                        "valor" => "Monitoramento",
                                    ], 
                                    "texto4" => "O alerta amarelo é estabelecido quando uma perturbação tropical se aproximou a uma distância que sugere o impacto da linha de ventos de 63km/h em uma área afetada em um período entre 60 e 12 horas, dependendo de sua intensidade. Boletins serão emitidos a cada 6 horas. ",
                                    "color" => "#ffee0b",
                                ]
                            ], [
                                "titulo" => "ALERTA LARANJA",
                                "contenido" => [
                                    "texto1" =>  "Perigo alto",
                                    "texto2" => [
                                        "etiqueta" => "Aproximação:",
                                        "valor" => "Alarme",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Afastamento:",
                                        "valor" => "Alarme",
                                    ], 
                                    "texto4" => "O alerta laranja é estabelecido quando uma perturbação tropical se aproximou a uma distância que sugere o impacto da linha de ventos de 63 km/h em uma área afetada em um período entre 36 e 6 horas, dependendo de sua intensidade. Boletins serão emitidos a cada 3 horas.",
                                    "color" => "#fc7c01",
                                ]
                            ], [
                                "titulo" => "ALERTA VERMELHA",
                                "contenido" => [
                                    "texto1" =>  "Perigo máximo",
                                    "texto2" => [
                                        "etiqueta" => "Aproximação:",
                                        "valor" => "Afetação",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Afastamento:",
                                        "valor" => "Afetação",
                                    ], 
                                    "texto4" => "O alerta vermelha é estabelecido quando uma perturbação tropical se aproximou a uma distância que sugere o impacto da linha de ventos de 63 km/h em uma área afetada, ou que possa afetar em um período igual ou menor a 18 horas. Boletins serão emitidos a cada 3 horas.",
                                    "color" => "#fd0304",
                                ]
                            ],
                        ],
                    ]
                ]
            ],
            [
                "frmIdIdioma" => self::LANG_FRA,
                "frmBasePath" => self::BASE_PATH,
                "frmInfo" => [
                    "subMenu" => "Saison des ouragans dans les Caraïbes mexicaines",
                    "contenido" => [
                        "texto1" => "En raison de sa localisation, les Caraïbes mexicaines sont vulnérables à limpact des ouragans tropicaux pendant la saison du 1er juin au 30 novembre chaque année./n/nLétat de Quintana Roo possède une solide culture de la protection civile, notamment avec des protocoles pour agir en cas dimpact dun ouragan et pour préserver la sécurité et le bien-être de la population et des touristes./n/nLe secteur hôtelier est efficacement préparé pour prendre en charge tous les touristes en cas de contingence hydrométéorologique. Les hôtels doivent disposer dun manuel interne de protection civile quils doivent mettre à jour chaque année, en plus de réviser régulièrement leurs installations et de former leur personnel pour préserver la sécurité des clients et, si nécessaire, appliquer des protocoles dévacuation et de premiers soins./n/nIl existe différentes agences météorologiques qui surveillent le développement des ouragans pour élaborer des prévisions. Ainsi, les autorités peuvent émettre une alerte à la population et mettre en œuvre des mesures préventives. Face à la possibilité dun ouragan dans les Caraïbes mexicaines, savoir comment rester en sécurité est essentiel. La prévention est le meilleur outil pour être bien préparé.",

                        "texto2" => "Voici quelques recommandations pour la saison des ouragans :",

                        "list1" => [
                            "1) Gardez votre calme et rassurez vos proches. Une personne perturbée peut commettre beaucoup derreurs.",
                            "2) Restez informé sur lévolution du phénomène hydrométéorologique à travers les canaux officiels du gouvernement de Quintana Roo.",
                            "3) Ne propagez ni ne croyez aux rumeurs.",
                            "4) Suivez et respectez les instructions des autorités de la Protection Civile.",
                            "5) Suivez et respectez les instructions de votre lieu dhébergement.",
                            "6) Conservez les documents personnels dans des sacs plastiques.",
                            "7) Ayez toujours sur vous une pièce didentité officielle avec photo et une copie de votre passeport, ainsi quune copie électronique de ces documents.",
                            "8) Informez vos proches et amis de votre itinéraire de voyage.",
                            "9) Avant de vous rendre à laéroport, confirmez lopération du vol avec la compagnie aérienne, car les itinéraires pourraient être affectés par les circonstances. Ne vous rendez pas à laéroport sans avoir un vol acheté et confirmé.",
                            "10) Ayez toujours sur vous les médicaments dont vous avez régulièrement besoin.",
                            "11) Si vous séjournez dans un hébergement traditionnel, ils disposent de leurs propres abris pour leurs hôtes et procéderont à lévacuation si nécessaire.",
                            "12) Si vous êtes dans un autre type dhébergement, renseignez-vous sur la sécurité de la zone et lemplacement des abris temporaires. Suivez les instructions des autorités en cas dévacuation nécessaire.",
                            "13) Gardez à portée de main des articles durgence tels quune trousse de premiers secours, des aliments en conserve, de leau purifiée, une lampe de poche et une radio à piles.",
                            "14) Si vous êtes dans un refuge, restez-y jusquà ce que les autorités indiquent que vous pouvez retourner.",
                            "15) Portez des bottes ou les chaussures les plus fermées que vous avez.",
                        ],

                        "subtitulo1" => "Système dalerte précoce pour les cyclones tropicaux (SIAT CT)",

                        "texto4" => "Il sagit dun guide utilisé par les autorités de la Protection Civile pour déterminer les phases dapproche dun cyclone tropical sous toutes ses formes (dépression, tempête tropicale ou ouragan) sur le territoire mexicain. Chaque étape de lalerte est représentée par une couleur./n/nLe système comprend deux phases dalerte, selon que le cyclone sapproche dune zone susceptible dêtre affectée ou quil sen éloigne.",

                        "acordeon" => [
                            [
                                "titulo" => "ALERTE BLEUE",
                                "contenido" => [
                                    "texto1" =>  "Danger minimal",
                                    "texto2" => [
                                        "etiqueta" => "Approche :",
                                        "valor" => "Avis",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Éloignement :",
                                        "valor" => "Avis",
                                    ], 
                                    "texto4" => "Lalerte bleue est établie lorsquune perturbation tropicale est détectée ou lorsquelle reste à 72 heures de la possibilité que les vents de 63 km/h du cyclone commencent à affecter. Des bulletins seront émis toutes les 24 heures.",
                                    "color" => "#0f87ff",
                                ]
                            ],
                            [
                                "titulo" => "ALERTE VERTE",
                                "contenido" => [
                                    "texto1" =>  "Danger faible",
                                    "texto2" => [
                                        "etiqueta" => "Approche :",
                                        "valor" => "Prévention",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Éloignement :",
                                        "valor" => "Prévention",
                                    ], 
                                    "texto4" => "Lalerte verte est déclenchée lorsquune perturbation tropicale sest approchée à une distance telle quelle laisse présager limpact de la ligne de vents de 63 km/h sur une zone affectable dans un délai de 72 à 24 heures, selon son intensité. Des bulletins seront émis toutes les 12 heures.",
                                    "color" => "#02cc46",
                                ]
                            ], [
                                "titulo" => "ALERTE JAUNE",
                                "contenido" => [
                                    "texto1" =>  "Danger modéré",
                                    "texto2" => [
                                        "etiqueta" => "Approche :",
                                        "valor" => "Préparation",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Éloignement :",
                                        "valor" => "Suivi",
                                    ], 
                                    "texto4" => "Lalerte jaune est déclenchée lorsquune perturbation tropicale sest approchée à une distance telle quelle laisse présager limpact de la ligne de vents de 63 km/h sur une zone affectée dans un délai de 60 à 12 heures, selon son intensité. Des bulletins seront émis toutes les 6 heures.",
                                    "color" => "#ffee0b",
                                ]
                            ], [
                                "titulo" => "ALERTE ORANGE",
                                "contenido" => [
                                    "texto1" =>  "Danger élevé",
                                    "texto2" => [
                                        "etiqueta" => "Approche :",
                                        "valor" => "Alarme",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Éloignement :",
                                        "valor" => "Alarme",
                                    ], 
                                    "texto4" => "Lalerte orange est déclenchée lorsque une perturbation tropicale sest approchée à une distance telle quelle laisse présager limpact de la ligne de vents de 63 km/h sur une zone affectable dans un délai de 36 à 6 heures, selon son intensité. Des bulletins seront émis toutes les 3 heures.",
                                    "color" => "#fc7c01",
                                ]
                            ], [
                                "titulo" => "ALERTE ROUGE",
                                "contenido" => [
                                    "texto1" =>  "Danger maximal",
                                    "texto2" => [
                                        "etiqueta" => "Approche :",
                                        "valor" => "Impact",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Éloignement :",
                                        "valor" => "Impact",
                                    ], 
                                    "texto4" => "Lalerte rouge est déclenchée lorsque une perturbation tropicale sest approchée à une distance telle quelle laisse présager un impact de la ligne de vents de 63 km/h sur une zone pouvant être affectée dans un délai égal ou inférieur à 18 heures. Des bulletins seront émis toutes les 3 heures.",
                                    "color" => "#fd0304",
                                ]
                            ],
                        ],
                    ]
                ]
            ],
            [
                "frmIdIdioma" => self::LANG_DEU,
                "frmBasePath" => self::BASE_PATH,
                "frmInfo" => [
                    "subMenu" => "Hurrikansaison in der mexikanischen Karibik",
                    "contenido" => [
                        "texto1" => "Aufgrund ihrer Lage ist die mexikanische Karibik anfällig für die Auswirkungen tropischer Hurrikane während der Saison vom 1. Juni bis zum 30. November jedes Jahres./n/nDer Bundesstaat Quintana Roo verfügt über eine starke Kultur des Zivilschutzes, insbesondere mit Protokollen zum Handeln im Falle eines Hurrikaneinschlags, um die Sicherheit und das Wohlbefinden der Bevölkerung und der Touristen zu wahren./n/nDer Hotelbereich ist effektiv darauf vorbereitet, alle Touristen bei jeglichen hydrometeorologischen Notfällen zu betreuen. Die Hotels müssen über ein internes Zivilschutzhandbuch verfügen, das jährlich aktualisiert werden muss. Zusätzlich überprüfen sie regelmäßig ihre Einrichtungen und schulen ihr Personal, um die Sicherheit der Gäste zu gewährleisten und bei Bedarf Evakuierungs- und Erste-Hilfe-Protokolle anzuwenden./n/nEs gibt verschiedene meteorologische Agenturen, die die Entwicklung der Hurrikane überwachen, um Prognosen zu erstellen. So können die Behörden eine Warnung an die Bevölkerung ausgeben und präventive Maßnahmen ergreifen. Angesichts der Möglichkeit eines Hurrikans in der mexikanischen Karibik ist es entscheidend zu wissen, wie man sicher bleibt. Prävention ist das beste Werkzeug, um gut vorbereitet zu sein.",

                        "texto2" => "Einige Empfehlungen für die Hurrikansaison:",

                        "list1" => [
                            "1) Bewahren Sie Ruhe und beruhigen Sie Ihre Angehörigen. Eine aufgeregte Person kann viele Fehler machen.",
                            "2) Bleiben Sie über die Entwicklung des hydrometeorologischen Phänomens über die offiziellen Kanäle der Regierung von Quintana Roo informiert.",
                            "3) Verbreiten Sie keine Gerüchte und glauben Sie diesen nicht.",
                            "4) Befolgen und beachten Sie die Anweisungen der Zivilschutzbehörden.",
                            "5) Befolgen und beachten Sie die Anweisungen Ihrer Unterkunft.",
                            "6) Bewahren Sie persönliche Dokumente in Plastiktüten auf.",
                            "7) Führen Sie stets einen amtlichen Ausweis mit Foto und eine Kopie Ihres Reisepasses sowie eine elektronische Kopie dieser Dokumente mit sich.",
                            "8) Informieren Sie Familie und Freunde über Ihren Reiseplan.",
                            "9) Bestätigen Sie vor der Abreise zum Flughafen den Betrieb des Fluges mit der Fluggesellschaft, da die Pläne unter den gegebenen Umständen beeinträchtigt werden könnten. Gehen Sie nicht zum Flughafen, wenn Sie keinen gekauften und bestätigten Flug haben.",
                            "10) Führen Sie stets die Medikamente mit sich, die Sie regelmäßig benötigen.",
                            "11) Wenn Sie in einer traditionellen Unterkunft sind, verfügen diese über eigene Schutzräume für ihre Gäste und führen gegebenenfalls eine Evakuierung durch.",
                            "12) Wenn Sie in einer anderen Art von Unterkunft sind, informieren Sie sich über die Sicherheit der Gegend und den Standort der temporären Unterkünfte. Befolgen Sie die Anweisungen der Behörden, falls eine Evakuierung notwendig ist.",
                            "13) Halten Sie Notfallartikel wie Erste-Hilfe-Kasten, Konserven, gereinigtes Wasser, Taschenlampe und batteriebetriebenes Radio griffbereit.",
                            "14) Wenn Sie sich in einem Schutzraum befinden, bleiben Sie dort, bis die Behörden angeben, dass Sie zurückkehren können.",
                            "15) Tragen Sie Stiefel oder die geschlossensten Schuhe, die Sie haben.'",
                        ],

                        "subtitulo1" => "Frühwarnsystem für tropische Zyklone (SIAT CT)",

                        "texto4" => "Es handelt sich um einen Leitfaden, der von den Behörden des Zivilschutzes verwendet wird, um die Annäherungsphasen eines tropischen Zyklons in seinen verschiedenen Formen (Depression, tropischer Sturm oder Hurrikan) in der Mexikanischen Republik zu bestimmen. Jede Stufe der Warnung wird durch eine Farbe dargestellt./n/nDas System besteht aus zwei Alarmphasen, je nachdem, ob sich der Zyklon einer betroffenen Region nähert oder sich von ihr entfernt.",

                        "acordeon" => [
                            [
                                "titulo" => "BLAUE WARNUNG",
                                "contenido" => [
                                    "texto1" =>  "Minimale Gefahr",
                                    "texto2" => [
                                        "etiqueta" => "Annäherung:",
                                        "valor" => "Warnung",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Entfernung:",
                                        "valor" => "Warnung",
                                    ], 
                                    "texto4" => "Die blaue Warnung wird ausgerufen, wenn eine tropische Störung festgestellt wurde oder wenn sie sich innerhalb von 72 Stunden davor befindet, dass die Windlinie von 63 km/h des Zyklons beginnt zu wirken. Berichte werden alle 24 Stunden herausgegeben.",
                                    "color" => "#0f87ff",
                                ]
                            ],
                            [
                                "titulo" => "GRÜNE WARNUNG",
                                "contenido" => [
                                    "texto1" =>  "Geringe Gefahr",
                                    "texto2" => [
                                        "etiqueta" => "Annäherung:",
                                        "valor" => "Prävention",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Entfernung:",
                                        "valor" => "Überwachung",
                                    ], 
                                    "texto4" => "Die grüne Warnung wird ausgelöst, wenn eine tropische Störung sich so weit genähert hat, dass mit dem Einfluss der Windlinie von 63 km/h auf ein betroffenes Gebiet innerhalb von 72 bis 24 Stunden gerechnet werden muss, je nach ihrer Intensität. Berichte werden alle 12 Stunden herausgegeben.",
                                    "color" => "#02cc46",
                                ]
                            ], [
                                "titulo" => "GELBE WARNUNG",
                                "contenido" => [
                                    "texto1" =>  "Mäßige Gefahr",
                                    "texto2" => [
                                        "etiqueta" => "Annäherung:",
                                        "valor" => "Vorbereitung",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Entfernung:",
                                        "valor" => "Überwachung",
                                    ], 
                                    "texto4" => "Die gelbe Warnung wird ausgelöst, wenn sich eine tropische Störung so weit genähert hat, dass mit dem Einfluss der Windlinie von 63 km/h auf ein betroffenes Gebiet innerhalb von 60 bis 12 Stunden gerechnet werden muss, je nach ihrer Intensität. Berichte werden alle 6 Stunden herausgegeben.",
                                    "color" => "#ffee0b",
                                ]
                            ], [
                                "titulo" => "ORANGE WARNUNG",
                                "contenido" => [
                                    "texto1" =>  "Hohe Gefahr",
                                    "texto2" => [
                                        "etiqueta" => "Annäherung:",
                                        "valor" => "Alarm",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Entfernung:",
                                        "valor" => "Alarm",
                                    ], 
                                    "texto4" => "Die orangene Warnung wird ausgelöst, wenn eine tropische Störung sich so weit genähert hat, dass mit dem Einfluss der Windlinie von 63 km/h auf ein betroffenes Gebiet innerhalb von 36 bis 6 Stunden gerechnet werden muss, je nach ihrer Intensität. Berichte werden alle 3 Stunden herausgegeben.",
                                    "color" => "#fc7c01",
                                ]
                            ], [
                                "titulo" => "ROTE WARNUNG",
                                "contenido" => [
                                    "texto1" =>  "Höchste Gefahr",
                                    "texto2" => [
                                        "etiqueta" => "Annäherung:",
                                        "valor" => "Betroffenheit",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Entfernung:",
                                        "valor" => "Betroffenheit",
                                    ], 
                                    "texto4" => "Die rote Warnung wird ausgelöst, wenn sich eine tropische Störung so weit genähert hat, dass mit dem Einfluss der Windlinie von 63 km/h auf ein betroffenes Gebiet innerhalb von 18 Stunden oder weniger gerechnet werden muss. Berichte werden alle 3 Stunden herausgegeben.",
                                    "color" => "#fd0304",
                                ]
                            ],
                        ],
                    ]
                ]
            ],
            [
                "frmIdIdioma" => self::LANG_RUS,
                "frmBasePath" => self::BASE_PATH,
                "frmInfo" => [
                    "subMenu" => "Сезон ураганов в мексиканских Карибах",
                    "contenido" => [
                        "texto1" => "Из-за своего расположения мексиканские Карибы уязвимы для воздействия тропических ураганов в сезон с 1 июня по 30 ноября каждого года./n/nШтат Кинтана-Роо обладает крепкой культурой гражданской обороны, в частности протоколами действий в случае урагана для обеспечения безопасности и благополучия населения и туристов./n/nГостиничный сектор эффективно подготовлен к обслуживанию всех туристов в случае гидрометеорологической угрозы. Гостиницы должны иметь внутреннее руководство по гражданской обороне, которое они должны обновлять каждый год, а также регулярно проверять свои учреждения и обучать свой персонал для обеспечения безопасности гостей и, при необходимости, применять протоколы эвакуации и первой помощи./n/nСуществуют различные метеорологические агентства, которые отслеживают развитие ураганов для составления прогнозов. Таким образом, власти могут издать предупреждение населению и предпринять профилактические меры. Учитывая возможность урагана в мексиканских Карибах, знание того, как оставаться в безопасности, имеет решающее значение. Превенция - лучший инструмент для того, чтобы быть хорошо подготовленным.",

                        "texto2" => "Вот некоторые рекомендации на сезон ураганов:",

                        "list1" => [
                            "1) Сохраняйте спокойствие и успокаивайте своих близких. Расстроенный человек может совершить много ошибок.",
                            "2) Следите за развитием гидрометеорологического явления через официальные каналы правительства Кинтана-Роо.",
                            "3) Не распространяйте и не верьте слухам.",
                            "4) Следуйте и соблюдайте инструкции службы гражданской защиты.",
                            "5) Следуйте и соблюдайте инструкции места вашего пребывания.",
                            "6) Храните личные документы в пластиковых пакетах.",
                            "7) Всегда носите с собой официальное удостоверение личности с фотографией и копию паспорта, а также электронную копию этих документов.",
                            "8) Информируйте родственников и друзей о вашем маршруте путешествия.",
                            "9) Перед поездкой в аэропорт подтвердите работу рейса с авиакомпанией, так как в данных обстоятельствах расписания могут быть изменены. Не отправляйтесь в аэропорт, если у вас нет купленного и подтвержденного билета.",
                            "10) Всегда носите с собой необходимые вам лекарства.",
                            "11) Если вы находитесь в традиционном месте проживания, они имеют собственные укрытия для своих гостей и осуществят эвакуацию при необходимости.",
                            "12) Если вы находитесь в другом месте проживания, узнайте о безопасности зоны и местоположении временных убежищ. Следуйте инструкциям властей в случае необходимости эвакуации.",
                            "13) Имейте под рукой предметы первой необходимости, такие как аптечка первой помощи, консервы, очищенная вода, фонарик и радио на батарейках.",
                            "14) Если вы находитесь в убежище, оставайтесь там, пока власти не скажут, что можно вернуться.",
                            "15) Носите ботинки или самую закрытую обувь, которая у вас есть.",
                        ],

                        "subtitulo1" => "Система раннего предупреждения о тропических циклонах (SIAT CT)",

                        "texto4" => "Это руководство, используемое органами гражданской защиты для определения фаз приближения тропического циклона в любом из его видов (тропическая депрессия, тропический шторм или ураган) в Мексиканской Республике. Каждый этап предупреждения представлен определённым цветом./n/nСистема состоит из двух фаз предупреждения, в зависимости от того, приближается ли циклон к зоне, которую может затронуть, или удаляется от неё.",

                        "acordeon" => [
                            [
                                "titulo" => "ГОЛУБАЯ ТРЕВОГА",
                                "contenido" => [
                                    "texto1" =>  "Минимальная опасность",
                                    "texto2" => [
                                        "etiqueta" => "Приближение:",
                                        "valor" => "Предупреждение",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Отдаление:",
                                        "valor" => "Предупреждение",
                                    ], 
                                    "texto4" => "Голубая тревога объявляется, когда обнаружено наличие тропического нарушения, или когда остаётся 72 часа до возможности, что линия ветров в 63 км/ч от циклона начнёт оказывать влияние. Бюллетени будут выдаваться каждые 24 часа.",
                                    "color" => "#0f87ff",
                                ]
                            ],
                            [
                                "titulo" => "ЗЕЛЕНАЯ ТРЕВОГА",
                                "contenido" => [
                                    "texto1" =>  "Низкая опасность",
                                    "texto2" => [
                                        "etiqueta" => "Приближение:",
                                        "valor" => "Предотвращение",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Отдаление:",
                                        "valor" => "Наблюдение",
                                    ], 
                                    "texto4" => "Зеленая тревога объявляется, когда тропическое нарушение приблизилось на такое расстояние, что можно предвидеть влияние ветровой линии в 63 км/ч на подверженную воздействию зону в течение от 72 до 24 часов в зависимости от её интенсивности. Бюллетени будут выдаваться каждые 12 часов.",
                                    "color" => "#02cc46",
                                ]
                            ], [
                                "titulo" => "ЖЕЛТАЯ ТРЕВОГА",
                                "contenido" => [
                                    "texto1" =>  "Умеренная опасность",
                                    "texto2" => [
                                        "etiqueta" => "Приближение:",
                                        "valor" => "Подготовка",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Отдаление:",
                                        "valor" => "Слежение",
                                    ], 
                                    "texto4" => "Желтая тревога объявляется, когда тропическое нарушение приблизилось на такое расстояние, что можно предвидеть воздействие ветровой линии в 63 км/ч на пострадавшую зону в течение от 60 до 12 часов в зависимости от её интенсивности. Бюллетени будут выдаваться каждые 6 часов.",
                                    "color" => "#ffee0b",
                                ]
                            ], [
                                "titulo" => "ОРАНЖЕВАЯ ТРЕВОГА",
                                "contenido" => [
                                    "texto1" =>  "Высокая опасность",
                                    "texto2" => [
                                        "etiqueta" => "Приближение:",
                                        "valor" => "Тревога",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Отдаление:",
                                        "valor" => "Тревога",
                                    ], 
                                    "texto4" => "Оранжевая тревога объявляется, когда тропическое нарушение приблизилось на такое расстояние, что можно предвидеть воздействие ветровой линии в 63 км/ч на подверженную воздействию зону в течение от 36 до 6 часов в зависимости от её интенсивности. Бюллетени будут выдаваться каждые 3 часа.",
                                    "color" => "#fc7c01",
                                ]
                            ], [
                                "titulo" => "КРАСНАЯ ТРЕВОГА",
                                "contenido" => [
                                    "texto1" =>  "Максимальная опасность",
                                    "texto2" => [
                                        "etiqueta" => "Приближение:",
                                        "valor" => "Воздействие",
                                    ],
                                    "texto3" => [
                                        "etiqueta" => "Отдаление:",
                                        "valor" => "Воздействие",
                                    ], 
                                    "texto4" => "Красная тревога объявляется, когда тропическое нарушение приблизилось на такое расстояние, что можно предвидеть влияние ветровой линии в 63 км/ч на подверженную воздействию зону в течение 18 часов или меньше. Бюллетени будут выдаваться каждые 3 часа.",
                                    "color" => "#fd0304",
                                ]
                            ],
                        ],
                    ]
                ]
            ],
        ];
    }

    /**
     * getData
     * [Busca el contenido por idioma]
     */
    public function getData($langId = null) {
        if (empty($langId))
            return $this->data;

        // Búsqueda de index del contenido en el idioma elegido 
        $dataIndex = array_search($langId, array_column($this->data,"frmIdIdioma"));
        // Si se eligió un idioma

        if ($dataIndex === false)
            $dataIndex = array_search(self::LANG_FALLBACK, array_column($this->data, "frmIdIdioma"));

        return $this->data[$dataIndex];
    }

}