<?php

namespace Application\Library\Complements;

use Laminas\Filter\File\UpperCase;

class BodyMap
{
    static function procesaJson($json, $basePath = null)
    {
        $primerNivel = $json;
        if (@$primerNivel['links']) {
            $links = $primerNivel['links'];
        }
        if (@$primerNivel['contenido']) {
            $contenido = $primerNivel['contenido'];
        }

        if (@$primerNivel['paises']) {
            $paises = @$primerNivel['paises'];
        }

        $html = '<p class="title-div">' . mb_strtoupper(@$primerNivel['subMenu']) . '</p>';

        if (@$primerNivel['titulo']) {
            foreach ($links as $k => $link) {
                if (str_contains($primerNivel['titulo'], $link['codigo'])) {
                    $replace = '<a href="tel:' . $link['link'] . '" class="btn btn-outline-danger m-2 mb-3 emergencias"">' . mb_strtoupper($link['titulo']) . '</a>';
                    $salida = str_replace($link['codigo'], $replace, $primerNivel['titulo']);
                    $html .= $salida;
                }
            }
        }

        foreach ($contenido as $i => $c) {
            $countCollapse = substr_count($html, "#collapse") ?: 0;
            $acordeonTwo = substr_count($html, 'id="accordionExample') ?: 0;
            $html .= self::generalHtml($c, @$links, $acordeonTwo, $countCollapse, $basePath);
        }
        if ($_SERVER['REQUEST_URI'] == '/directorios/fiscalias') {
            $marks = '[\'Fiscal�a General del Estado de Quintana Roo<br />Av. Adolfo L�pez Mateos No. 500, Colonia Italia<br />Tel&eacute;fono:&nbsp;983 835 0050<br />Localidad:&nbsp;Chetumal\', 18.506385, -88.309124],
            [\'Vice Fiscal�a General del Estado de Quintana Roo, Zona Centro<br />Calle 77 por 56, Col. Leona Vicario, C.P.77210<br />Tel&eacute;fono:&nbsp;983 83 40150<br />Localidad:&nbsp;Felipe Carrillo Puerto\', 19.585209, -88.049719],
            [\'Fiscal�a General del Estado de Quintana Roo, Riviera Maya<br />Calle Zapote S/N, Villa Mar 1, cerca del Arco Vial, C.P. 77710<br />Tel&eacute;fono:&nbsp;984 877 2600<br />Localidad:&nbsp;Playa del Carmen\', 20.666959, -87.063330],
            [\'Vice Fiscal�a General del Estado de Quintana Roo, Zona Norte<br />Av. Xcaret esquina Kabah, Supermanzana 21, Manzana 3, Lote 14, C.P. 77500<br />Tel&eacute;fono:&nbsp;998 881 7150<br />Localidad:&nbsp;Canc�n\', 21.152714, -86.840518],
            [\'Fiscal�a General del Estado de Quintana Roo, Agencia Zona Hotelera<br />Blvd. Kukulcan, Km 12.5, C.P. 77500<br />Tel&eacute;fono:&nbsp;<br />Localidad:&nbsp;Canc�n\', 21.104410, -86.764543],
            [\'Fiscal�a Especializada para la atenci�n de Delitos contra la Mujer y por Razones de G�nero, Canc�n<br />Regi�n 94, Mza.8 Lte3 sobre la Ruta 5, C.P. 77517<br />Tel&eacute;fono:&nbsp;998 881 7150 ext. 2500<br />Localidad:&nbsp;Canc�n\', 21.162883, -86.863378],
            [\'Agencia de la Fiscal�a General del Estado en Isla Mujeres<br />Sm8, mz117, Lt 1, Vista Alegre paseo de los peces<br />Tel&eacute;fono:&nbsp;<br />Localidad:&nbsp;Isla Mujeres\', 21.221975, -86.724589],
            [\'Agencia de la Fiscal�a General del Estado en Cozumel<br />Av. 65, con calle 25, colonia Maravilla a un costado de la Cruz Roja<br />Tel&eacute;fono:&nbsp;(987) 8572894<br />Localidad:&nbsp;Cozumel\', 20.490341, -86.950610],
            [\'Agencia de la Fiscal�a General del Estado en Bacalar<br />Calle 12 entre Av. 9 y Av. 13 colonia Serapio Flota<br />Tel&eacute;fono:&nbsp;<br />Localidad:&nbsp;Bacalar\', 18.674794, -88.395818],';
            $html .= self::generaMapa($marks);
        }

        if ($_SERVER['REQUEST_URI'] == '/directorios/hospitales') {
            $marks = '[\'Hospital General de Cancún<br />Super maz. 248, mza. 11, lotes 1110-25, s/n, fraccionamiento villas del mar<br />Tel&eacute;fono:&nbsp;998 234 0000<br />Localidad:&nbsp;Cancún\', 21.195950, -86.876257],
            [\'Hospital General de Playa del Carmen<br />Av. Constituyentes con 135 Av. Presidente, s/n<br />Tel&eacute;fono:&nbsp;984 206 1690<br />Localidad:&nbsp;Playa del Carmen\', 20.645384, -87.094714],
            [\'Hospital Integral de Isla Mujeres<br />Av. Rueda medina no. 66, col. La gloria<br />Tel&eacute;fono:&nbsp;<br />Localidad:&nbsp;Isla Mujeres\', 21.220181, -86.727087],
            [\'Hospital General de Cozumel<br />Av. Lic. Andrés Quintana Roo no 241,entre 20 Av. Sur y 10a Av. Sur,Col. San Miguel de Cozumel<br />Tel&eacute;fono:&nbsp;<br />Localidad:&nbsp;Cozumel\', 20.501805, -86.953362],
            [\'Centro de Salud Urbano de Tulum<br />Calle Sol entre calle Omega y calle Júpiter sur, s/n, col. Centro<br />Tel&eacute;fono:&nbsp;984 8025554<br />Localidad:&nbsp;Tulum\', 20.208996, -87.465290],
            [\'Hospital Comunitario de Bacalar<br />Av. 3 entre calle 22 y calle 24, s/n, col. Centro<br />Tel&eacute;fono:&nbsp;983 83 42969<br />Localidad:&nbsp;Bacalar\', 18.678443, -88.388606],
            [\'Hospital Integral de Kantunilkín<br />Calle Reforma Agraria con calle Miguel Hidalgo y lic. Adolfo López Mateos<br />Tel&eacute;fono:&nbsp;984 875 0160<br />Localidad:&nbsp;Kantunilkín\', 21.105859, -87.486099],
            [\'Hospital General de Chetumal<br />Av. Andrés Quintana Roo con calle Juan José Siordia y calle Isla Cancún, no. 399, col. Taxistas<br />Tel&eacute;fono:&nbsp;<br />Localidad:&nbsp;Chetumal\', 18.517024, -88.304042],
            [\'Hospital Materno Infantil Morelos<br />Av. Juárez no. 141, entre calle Efraín Aguilar y Av. Héroes de Chapultepec, Col. Centro<br />Tel&eacute;fono:&nbsp;<br />Localidad:&nbsp;Chetumal\', 18.502115, -88.298112],
            [\'Hospital General de Felipe Carrillo Puerto<br />Calle 51, entre av. Benito Juárez y calle 68, col. Juan bautista vega, no. 755<br />Tel&eacute;fono:&nbsp;983 83 40092<br />Localidad:&nbsp;Felipe Carrillo Puerto\', 19.571113, -88.045886],
            [\'Hospital Integral de José María Morelos<br />Av. Felipe Carrillo Puerto - josé maría morelos entre calle 40 Noh-bec y calle Gonzalo Guerrero, s/n, col. Centro<br />Tel&eacute;fono:&nbsp;997 97 80184<br />Localidad:&nbsp;José María Morelos\', 19.746288, -88.706148],';
            $html .= self::generaMapa($marks);
        }

        if (@$paises) {
            $html .= self::generaModalPaises($paises, @$links, @$basePath);
        }

        return $html;
    }

    static function generalHtml($data, $links = null, $acordeonTwo = null, $countCollapse = 0, $basePath = null)
    {
        $fragmento = null;
        foreach ($data as $i => $c) {
            switch ($i) {
                case 'titulo':
                    $fragmento .= @$c ? '<p class="subtitle-div">' . mb_strtoupper($c) . '</p>' : '';
                    break;
                case 'subtitulo':
                    if (is_iterable($c)) {
                        foreach ($c as $j => $data) {
                            if (@$data['listado']) {
                                if (@$data['listado'][0]['icono'] == 'false') {
                                    $divUl = '<ul class="text-div estilos-modulo-atencion">';
                                } else if (@$data['listado'][0]['icono'] == 'interlineado') {
                                    $divUl = '<ul class="text-div">';
                                } else if (isset($data['listado'][0]['icono']) && !(str_contains($data['listado'][0]['icono'], '/circle-solid') || str_contains($data['listado'][0]['icono'], 'ban-solid') || str_contains($data['listado'][0]['icono'], 'angle-right-solid'))) {
                                    $divUl = '<ul class="text-div estilos-lista viñeta-img" style="list-style-image:url(' . $basePath . $data['listado'][0]['icono'] . ');">';
                                } else {
                                    $divUl = '<ul class="text-div">';
                                }
                                $fragmento .= $divUl ?: '<ul class="text-div">';
                                foreach ($data['listado'] as $j => $data2) {
                                    switch ($data2['tipo']) {
                                        case 'texto':
                                            if ($data2['icono'] == 'hijo') {
                                                $fragmento .= '<li style="padding-left: 3rem;">' . $data2['valor'] . '</li>';
                                            } else if ($data2['icono'] == 'interlineado') {
                                                $fragmento .= '<li>' . $data2['valor'] . '</li><br>';
                                            } else {
                                                $fragmento .= '<li>' . $data2['valor'] . '</li>';
                                            }
                                            break;
                                        case 'mixto':
                                            $salida = self::generaLink($data2, $links);
                                            $fragmento .= '<li>' . $salida . '</li>';
                                            break;
                                    }
                                    if (@$data2['parrafoUnion']) {
                                        $fragmento .= '<li>';
                                        foreach ($data2['parrafoUnion'] as $j => $data3) {
                                            switch ($data3['tipo']) {
                                                case 'bold':
                                                    $fragmento .= '<b>' . $data3['valor'] . '</b> ';
                                                    break;
                                                case 'texto':
                                                    $fragmento .= $data3['valor'];
                                                    break;
                                                case 'mixto':
                                                    $salida = self::generaLink($data3, $links);
                                                    $fragmento .= $salida;
                                                    break;
                                            }
                                        }
                                        $fragmento .= '</li>';
                                        if (@$data2['icono'] == 'interlineado') {
                                            $fragmento .= '<br>';
                                        }
                                    }
                                }
                                $fragmento .= '</ul>';
                            } else if (@$data['parrafoUnion']) {
                                $fragmento .= '<p class="text-div">';
                                foreach ($data['parrafoUnion'] as $j => $data2) {
                                    switch ($data2['tipo']) {
                                        case 'bold':
                                            $fragmento .= '<b>' . $data2['valor'] . '</b> ';
                                            break;
                                        case 'texto':
                                            $fragmento .= $data2['valor'];
                                            break;
                                        case 'mixto':
                                            $salida = self::generaLink($data2, $links);
                                            $fragmento .= $salida;
                                            break;
                                    }
                                }
                                $fragmento .= '</p>';
                            } else {
                                switch (@$data['tipo']) {
                                    case 'texto':
                                        $fragmento .= '<p class="text-div" >' . $data['valor'];
                                        break;
                                    case 'bold':
                                        $fragmento .= '<p class="text-div" style="margin-bottom: 3px !important;"><b>' . $data['valor'] . '</b>';
                                        break;
                                    case 'mixto':
                                        $salida = self::generaLink($data, $links);
                                        $fragmento .= '<p class="text-div">' . $salida;
                                        break;
                                    case 'catalogo':
                                        $fragmento .= '<div class="accordion" id="accordionExample">';
                                        $fragmento .= self::generaCatalogo($data['valor']);
                                        $fragmento .= '</div>';
                                        break;
                                    case 'tabla':
                                        $fragmento .= '<br><br><div class="container">';
                                        foreach ($data['valor']['columna1'] as $kc => $vc) {
                                            $fragmento .= '<div class="row">';
                                            if ($vc['tipo'] == 'encabezado') {
                                                $fragmento .= '<div class="col-8 py-1 border"><strong>' . $vc['texto'] . '</strong></div>';
                                                $fragmento .= '<div class="col py-1 border"> <strong>' . $data['valor']['columna2'][$kc]['texto'] . '</strong></div>';
                                            }
                                            if ($vc['tipo'] == 'texto') {
                                                $fragmento .= '<div class="col-8 py-1 border">' . $vc['texto'] . '</strong></div>';
                                                $fragmento .= '<div class="col py-1 border">' . $data['valor']['columna2'][$kc]['texto'] . '</div>';
                                            }
                                            $fragmento .= '</div>';
                                        }
                                        $fragmento .= '</div> <br>';
                                        break;
                                    // case 'form':
                                    //     if($_SERVER['REQUEST_URI'] == '/servicios/asesoria-legal'){
                                    //         $fragmento .= '<p class="text-div"> FORMULARIO DE ASESORIA LEGAL </div>';
                                    //     }
                                    //     break;
                                }
                            }
                        }
                    }
                    break;
                case 'acordeon':
                    $tipoAcordeon = $acordeonTwo + 1;
                    $fragmento .= '<div class="accordion mb-3" id="accordionExample' . $tipoAcordeon . '">';
                    $collapse = $countCollapse + 1;
                    $shows = 1;
                    // Mapeo de los items del acordeon
                    foreach ($data['acordeon'] as $ak => $av) {
                        $expanded = ($shows == 1) ? 'true' : 'false';
                        $show = ($shows == 1) ? ' show' : '';
                        $colap = ($shows == 1) ? '' : 'collapsed';
                        $fragmento .= '<div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button ' . $colap . '" type="button" data-bs-toggle="collapse" data-bs-target="#collapse' . $collapse . '" aria-expanded="' . $expanded . '" aria-controls="collapse' . $collapse . '">
                                    ' . $av['titulo'] . '
                                </button>
                            </h2>
                            <div id="collapse' . $collapse . '" class="accordion-collapse collapse' . $show . '" data-bs-parent="#accordionExample' . $tipoAcordeon . '" style="">
                                <div class="accordion-body text-div">';
                        unset($av['titulo']);
                        $fragmento .= self::generalHtml($av, $links, 2);
                        $fragmento .= '</div>
                            </div>
                        </div>';
                        $collapse++;
                        $shows++;
                    }
                    $fragmento .= '</div>';
                    break;
                case 'galeria':
                    $fragmento .= '<div class="container my-3 123">';
                    $count = 1;
                    foreach ($data['galeria'] as $gk => $gv) {
                        if (isset($gv['activo']) && $gv['activo'] == 0) {
                            continue;
                        }
                        if ($count == 1) {
                            $fragmento .= '<div class="row mt-4 mb-4 custom-card-group">';
                        }
                        $fragmento .= '<div class="col col-md-4 col-sm-12 d-flex align-items-center justify-content-center my-3">
                            <div class="card shadow-sm border-0" style="width: 18rem;">
                                <img src="' . $basePath . $gv['imagen'] . '" class="card-img-top" alt="...">
                                <div class="card-body">
                                    <h5 class="title-card">' . $gv['titulo'] . '</h5>
                                    <p class="text-card">';
                        $sub = [
                            'subtitulo' => $gv['subtitulo']
                        ];
                        $fragmento .= self::generalHtml($sub, $links);
                        $fragmento .= '</div>
                            </div>
                        </div>';

                        if ($count == 3) {
                            $fragmento .= '</div>';
                            $count = 1;
                            continue;
                        }
                        $count++;
                    }
                    $fragmento .= '</div>';
                    break;
            }
        }
        return $fragmento;
    }

    static function generaLink($data, $links)
    {
        $salida = '';
        foreach ($links as $k => $link) {
            if (str_contains(@$salida, $link['codigo'])) {
                switch ($link['tipo']) {
                    case 'correo':
                        $replace = '<a href="mailto:' . $link['link'] . '" target="_blank" class="over-div-enlaces">' . $link['titulo'] . '</a>';
                        break;
                    case 'url':
                        $replace = '<a href="' . $link['link'] . '" target="_blank" class="over-div-enlaces">' . $link['titulo'] . '</a>';
                        break;
                    case 'telefono':
                        $replace = '<a href="tel:' . $link['link'] . '" target="_blank" class="over-div-enlaces">' . $link['titulo'] . '</a>';
                        break;
                    case 'formulario':
                        $replace = '<a href="#" data-bs-toggle="modal" data-bs-target="#' . $link['codigo'] . '" class="over-div-enlaces">' . $link['titulo'] . '</a>';
                        break;
                }
                $salida = str_replace($link['codigo'], @$replace, @$salida);
            } else if (str_contains($data['valor'], $link['codigo'])) {
                switch ($link['tipo']) {
                    case 'correo':
                        $replace = '<a href="mailto:' . $link['link'] . '" target="_blank" class="over-div-enlaces">' . $link['titulo'] . '</a>';
                        break;
                    case 'url':
                        $replace = '<a href="' . $link['link'] . '" target="_blank" class="over-div-enlaces">' . $link['titulo'] . '</a>';
                        break;
                    case 'telefono':
                        $replace = '<a href="tel:' . $link['link'] . '" target="_blank" class="over-div-enlaces">' . $link['titulo'] . '</a>';
                        break;
                    case 'formulario':
                        $replace = '<a href="#" data-bs-toggle="modal" data-bs-target="#' . $link['codigo'] . '" class="over-div-enlaces">' . $link['titulo'] . '</a>';
                        break;
                }
                $salida = str_replace($link['codigo'], @$replace, $data['valor']);
            }
        }


        return $salida;
    }

    static function generaCatalogo($catalogoData)
    {
        $catalogo = '<div class="accordion mb-3" id="accordionExample">';
        $collapse = 1;
        $url = $_SERVER['REQUEST_URI'];
        if ($url == '/servicios/informacion-medica') {
            $url = '/directorios/hospitales';
        } else if ($url == '/servicios/reporte-robo') {
            $url = '/directorios/fiscalias';
        }
        foreach ($catalogoData as $kc => $vc) {
            $catalogo .= '<div class="accordion-item">';
            foreach ($vc as $vck => $vcv) {
                if ($vcv['etiqueta'] == 'Nombre: ' || $vcv['etiqueta'] == 'Nombre :' || $vcv['etiqueta'] == 'Name: ' || $vcv['etiqueta'] == 'Name :') {
                    $expanded = ($collapse == 1) ? 'true' : 'false';
                    $show = ($collapse == 1) ? ' show' : '';
                    $colap = ($collapse == 1) ? '' : 'collapsed';
                    $catalogo .= '<h2 class="accordion-header">
                    <button class="accordion-button ' . $colap . '" type="button" data-bs-toggle="collapse" data-bs-target="#collapse' . $collapse . '" aria-expanded="' . $expanded . '" aria-controls="collapse' . $collapse . '">'
                        . $vcv['valor'] .
                        '</button>
                        </h2>
                        <div id="collapse' . $collapse . '" class="accordion-collapse collapse' . $show . '" data-bs-parent="#accordionExample">
                        <div class="accordion-body text-div">';
                } else if ($vcv['etiqueta'] == 'Mapa: ') {
                    $catalogo .= '<a href="' . $url . '/' . $vcv['id'] . '" class="over-div-enlaces">' . $vcv['valor'] . '</a>';
                } else if ($vcv['etiqueta'] == 'Map: ') {
                    $catalogo .= '<a href="' . $url . '/' . $vcv['id'] . '" class="over-div-enlaces">See map</a>';
                } else {
                    $catalogo .= $vcv['valor'] ? $vcv['etiqueta'] . $vcv['valor'] . '<br>' : '';
                }
            }
            $catalogo .= '</div>
                </div>
            </div>';
            $collapse++;
        }
        return $catalogo;
    }

    static function procesaJsonConsulados($json, $link)
    {
        $primerNivel = $json;

        if (@$primerNivel['contenido']) {
            $contenido = $primerNivel['contenido'];
        }

        $html = '<p class="title-div">' . mb_strtoupper(@$primerNivel['subMenu']) . '</p>';
        $html .= '<div class="container">';
        $cambio = 0;

        foreach ($contenido as $i => $c) {
            $html .= '<div class="row mt-2 mb-2">';
            foreach ($c as $ic => $cc) {
                if ($cambio == 3) {
                    $html .= '</div>';
                    $html .= '<div class="row mt-4 mb-4 d-flex justify-content-center">';
                }
                $html .= '<div class="col col-md-4 col-sm-12 d-flex align-items-center justify-content-center my-3">
                            <div class="card shadow-sm border-0" style="width: 18rem;">';
                $html .= '<a href="consulados-y-embajadas/' . $cc[0]['valor'] . '"><img src="' . $link . $cc[2]['valor'] . '" class="card-img-top" alt="..."></a>';
                $html .= '<div class="card-body text-center">
                            <a href="consulados-y-embajadas/' . $cc[0]['valor'] . '">' . mb_strtoupper($cc[1]['valor']) . '</a>
                        </div>
                    </div>
                </div>';
                $cambio++;
            }
        }
        if ($_SERVER['REQUEST_URI'] == '/directorios/consulados-y-embajadas') {
            $marks = '[\'Alemania (Consulado)<br />Plaza Terra Viva CancÃºn.  Av. Acanceh Sm11 Mz2 Lote 3. Entre Av. Tulum y Nichupte  3. Piso (Co-Working SACH). Oficina Nr. 302<br />cancun@hk-diplo.de - Tel. 99 88 84 15 98\', 21.1435101, -86.825457],
            [\'Argentina (Consulado)<br />Plaza Riviera Centre â 1Â° Piso, Locales 108-109 Calle 41 sur y Carretera Federal (50 avenida norte). Playa del Carmen, Quintana Roo<br />cpcar@cancilleria.gob.ar - Tel.  984 231 2321\', 20.650816, -87.085108],
            [\'Australia (Consulado)<br />Luciernaga esq Av. Politecnico, 77535 CancÃºn, QR<br />aushonconcun@gmail.com - Tel. 55 11 01 22 00\', 21.1362342, -86.843532],
            [\'Austria (Consulado)<br />Av.Nichupte Lote 20, SM 19, Mza 2. Edificio Atrium 410 Cancun, Quintana, Roo C.p. 77500 <br />consulado@schondube.com - Tel. 99 88 81 19 70  /\', 21.1429559, -86.830262],
            [\'Belgica (Consulado)<br />Av. Cozumel # 10  Sm-11  Mz-5  C.P. 77504<br />consul@belgicacancun.net - Tel. 99 8386 3899\', 21.1416516, -86.826835],
            [\'Brasil (Consulado)<br /><br />consular.mexico@itamaraty.gov.br - Tel. 55 52 01 45 31\', 19.4339663, -99.211508],
            [\'CanadÃ¡ (Consulado)<br />Centro Empresarial E7, Blvd Kukulcan Km 12, Zona Hotelera, CancÃºn, QRoo, 77500<br />cncun@international.gc.ca - Tel. 55 57 24 97 95\', 21.106866, -86.764084],
            [\'Chipre (Consulado)<br /><br />chipre@consuladosqroo.org - Tel. (999) 947 3605\', , ],
            [\'Colombia (Consulado)<br />Av. Bonampak # 58 Piso-4, Plaza VÃ­a, CancÃºn, Quintana Roo, MÃ©xico<br />ccancun@cancilleria.gov.co - Tel. (998) 4154541\', 21.159173, -86.821412],
            [\'Corea del Sur (Consulado)<br /><br />jaristi@casadaristi.com - Tel. 5555407236\', , ],
            [\'Cuba (Consulado)<br />Pecari, No. 17, SÃºper Manzana 20, CancÃºn Centro. CP 77500.<br />consuladocubacancun@gmail.com - Tel. 99 88 84 34 23  /\', 21.1532520, -86.826448],
            [\'Dinamarca (Consulado)<br />Km 12.5 Blvd. Luis Donaldo Colosio, Sm-301 Mz. 1 Lt. 1, Interior Plaza Santa Fe, C.P. 77560<br />aberiv@umgate.dk - Tel. 998 8488900\', 21.0475266, -86.849576],
            [\'Eslovaquia (Consulado)<br />Calle Rosas No. 22 Mza 24 SM 22 CANCUN<br />eslovaquia@consuladosqroo.org - Tel. 99 8884 8546\', 21.163959, -86.828379],
            [\'EspaÃ±a (Consulado)<br />Blvd: Kukulcan km 6.5 con Cenzontle Edif. Corporativo Oasis Z.H. CANCUN<br />ch.cancun@maec.es - Tel. 99 88 48 99 89  /\', 21.1377447, -86.768722],
            [\'Estados unidos (Consulado)<br />BLVD. Kukulcan km 13  Torre La Europea Ofc. 301, Z.H.<br />ConAgencyCancun@state.gov - Tel. 99 99 42 57 00\', 21.105945, -86.76434],
            [\'Finlandia (Consulado)<br />Calle MaraÃ±on No.3, SM 25, Mz 5, Ret 2, 77509 CANCUN<br />notariacancun@hotmail.com - Tel. 998 8875999\', 21.1611109, -86.830233],
            [\'Francia (Consulado)<br />Avenida Huayacan #11 Piso 2, Supermanzana 313, Manzana 73, Lote 11. CP 77533 CancÃºn, Benito Juarez, Quintana Roo<br />consulat.france.qroo@gmail.com - Tel. 99 83 62 69  96\', 21.1286177, -86.836968],
            [\'Grecia (Consulado)<br /><br />grecia@consuladosqroo.org - Tel. 999 9301107\', , ],
            [\'Guatemala (Consulado)<br />Av. Tulum No. 318 Sm- 9 Mz- 2  Lt- 2, oficina de la 7 a la 14, Centro Corporativo CancÃºn   C.P. 77503<br />conscancun@minex.gob.gt - Tel. 9982 109219\', 21.1332467, -86.828199],
            [\'Holanda (Consulado)<br />Edificio complejo Ibis. 3er piso, Oficinas SACH Av. Acanceh Mza 2 lote 3 piso 3B SM 11 CP 77580 CANCUN, QROO<br />nlconsulcancun@prodigy.net.mx - Tel.  998 5001653\', 21.1433746, -86.825024],
            [\'Hungria (Consulado)<br />Cerrada Las Golondrinas No. 24 Alfredo V. Bonfil CANCUN<br />roberto@musamexico.org - Tel. 998 2060182\', 21.116231, -86.842429],
            [\'India (Consulado)<br /><br />cons_eoimex@prodigy.net.mx - Tel. 5555310850\', , ],
            [\'Indonesia (Consulado)<br />Calle Encino, Mz-15 Lt-8 SM-43 No. 8, Pedregal del Bosque. CancÃºn, Quintana Roo<br />ocanto@notaria53.com.mx - Tel. 998 887-83-85\', 21.1482477, -86.840725],
            [\'Inglaterra (Consulado)<br />Blvd. Kukulcan km 12.5  Torre La Europea Ofc. 202, Z.H.<br />Consular.Mx@fcdo.gov.uk - Tel. 55 16 70 32 00 \', 21.105895, -86.764437],
            [\'Irlanda (Consulado)<br />Avenida Coba 15, SM 22 Mz 8  CANCUN<br />consul@gruporoyale.com - Tel.  998 195 9063\', 21.156358, -86.824508],
            [\'Israel (Consulado)<br />Blvd. Luis Donaldo Lote 8 SM 207 Mz 47 CANCUN<br />consulado.israel.qroo@gmail.com - Tel. 55 4162 2222  Ext. 2101\', 21.0697567, -86.845892],
            [\'Italia (Consulado)<br />Calle 23 Sur entre Diagonal 85 y 80, Ejido Sur C.P. 77710, Playa del Carmen â Quintana Roo<br />consolatoplaya@gmail.com - Tel.  (984) 214-4104\', 20.6249295, -87.094289],
            [\'Luxemburgo (Consulado)<br />Calle 25-A, No. 500-B X 58-A Col. ItzimnÃ¡ MERIDA, YUCATÃN <br />chluxpyuc@yahoo.com.mx - Tel. 999  926 17 25\', 20.988759, -89.611734],
            [\'Noruega (Consulado)<br />Av. Tulum No. 200 Suite 303 SM 4 Mz 16 CANCUN<br />noruega@consuladosqroo.org - Tel. 998 8871670 \', 21.1532480, -86.824188],
            [\'Polonia (Consulado)<br />Av. Bonampak No. 73-01, SM 3 CANCUN<br />gabrielag@poloniacancun.com - Tel. 998 8921764 /\', 21.156591, -86.821708],
            [\'Portugal (Consulado)<br />Calle GuanÃ¡bana n.Âº 40, Super Manzana 25, Manzana 13, Lote 11, 2do. Piso, Depto.2 CanÃºn - CP 77509<br />consul_portugal_cancum@prodigy.net.mx - Tel.  998 884 27 35 /\', 21.1585300, -86.830991],
            [\'Rep. Checa (Consulado)<br />RelÃ¡mpago No. 24- 5 SM 18 Mz. 9 CANCUN<br />czechconsulatecancun@gmail.com - Tel. 998 8841216\', 21.150578, -86.82859],
            [\'Rep. Dominicana (Consulado)<br /><br />consuladordcancun@yahoo.com - Tel. 5552607262\', 21.044331, -86.851236],
            [\'Rumania (Consulado)<br />Av. Acanceh  Lote 8  Mza 1  SM 13 CANCUN<br />consuladorumaniacancun@gmail.com - Tel. 99 881 74 10  /\', 21.135041, -86.829515],
            [\'Rusia (Consulado)<br /><br />rusiaconsulado@gmail.com - Tel.  55 5516-0870\', 21.152759, -86.822551],
            [\'Sudafrica (Consulado)<br />Granada No. 30, Supermanzana 2 âAâ, 77500 CancÃºn, Quintana Roo, Mexico<br />consulsudafrica@notaria20.com - Tel. 99 8884 1041 /\', 21.1666478, -86.823364],
            [\'Suecia (Consulado)<br />Km. 12.5 Blvd. Luis Donaldo Colosio, Sm-301 Mz. 1 Lt. 1, Interior Plaza Santa Fe<br />katiavara@prodigy.net.mx - Tel. 998 8488900\', 21.0475829, -86.850265],
            [\'Suiza (Consulado)<br />Av. Coba No. 12, local 214, Edif. VÃ©nus, SM5, MZ1, 77500 CancÃºn, Q.Roo, Mexico<br />cancun@honrep.ch - Tel. 99 8884 8446  /\', 21.1571441, -86.824382],
            [\'Uruguay (Consulado)<br />Retorno Venado, No. 35 Sm-20  C.P. 77500<br />cdcancun@mrree.gub.uy - Tel. 998 4153113\', 21.1551970, -86.828826],';
            $html .= self::generaMapa($marks);
        }
        $html .= '</div>';


        return $html;
    }

    static function procesaJsonConsulado($json, $link = null)
    {
        $primerNivel = $json;

        if ($_COOKIE['idIdioma'] == '1') {
            $consulado = 'CONSULADO';
        } elseif ($_COOKIE['idIdioma'] == '2') {
            $consulado = 'CONSULATE';
        } elseif ($_COOKIE['idIdioma'] == '3') {
            $consulado = 'CONSULAT';
        } elseif ($_COOKIE['idIdioma'] == '4') {
            $consulado = 'BOTSCHAFT ';
        } elseif ($_COOKIE['idIdioma'] == '5') {
            $consulado = 'CONSULADO';
        } elseif ($_COOKIE['idIdioma'] == '6') {
            $consulado = 'Консульство';
        }


        if (@$primerNivel['contenido']) {
            $contenido = $primerNivel['contenido'];
        }
        $html = '<div class="d-flex align-items-center">';
        $html .= @$link ? '<img src="' . $link . $contenido[0]['subtitulo'][0][1]['valor'] . '" class="icon-consulado">' : '';
        $html .= '<div class="title-div">' . mb_strtoupper(@$contenido[0]['titulo']) . '</div> </div>';

        $mark = null;
        foreach ($contenido[0]['subtitulo'] as $k => $v) {
            if (str_contains($_SERVER['REQUEST_URI'], 'consulados-y-embajadas')) {
                $html .= '<p class="subtitle-div">
                    <br>
                    ' . $consulado . '
                </p>';
            }
            $html .= '<p class="text-div">';
            $mapa = null;
            foreach ($v as $kv => $vv) {
                switch (@$vv['etiqueta']) {
                    case '':
                        break;
                    case 'Jurisdicción: ':
//                        if(@$vv['valor'])
                        $mapa .= '<strong>' . $vv['etiqueta'] . '</strong>' . $vv['valor'] . '<br>';
                        break;
                    case 'Correo(s): ':
                    case 'Mail(s): ':
                        if (@$vv['valor'])
                            $mapa .= '<strong>' . $vv['etiqueta'] . '</strong> <a href="mailto:' . $vv['valor'] . '" class="over-div-enlaces">' . $vv['valor'] . '</a><br>';
                        break;
                    case 'Website: ':
                        if (@$vv['valor'])
                            $mapa .= '<strong>' . $vv['etiqueta'] . '</strong> <a href="' . $vv['valor'] . '" target="_blank" class="over-div-enlaces">' . $vv['valor'] . '</a><br>';
                        break;
                    default:
                        if (@$vv['valor'])
                            $mapa .= '<strong>' . $vv['etiqueta'] . '</strong>' . $vv['valor'] . '<br>';
                        break;
                }
                if (@$vv['latitud']) {
                    $coords = ',' . @$vv['latitud'] . ',' . @$vv['longitud'];
                }
            }
            $mark .= '[' . '\'' . $mapa . '\'' . @$coords . '],';
            $html .= $mapa . '</p>';
        }
        $html .= self::generaMapa($mark);

        return $html;
    }

    static function generaMapa($marks)
    {
        $map = '<div class="mt-3 mx-auto">
            <!--mapa-->
            <style type="text/css">
                #mapa {
                    height: 500px;
                }
            </style>
            <script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCxs69bkkf3DeVFSBUFoEqAcutMTWSLlk8"></script>
            <script type="text/javascript">
                function initialize() {
                    var marcadores = [
                        ' . $marks . '
                    ];
                    var map = new google.maps.Map(document.getElementById(\'mapa\'), {
                        zoom: 7,
                        center: new google.maps.LatLng(19.9404619, -87.5060303),
                        mapTypeId: google.maps.MapTypeId.ROADMAP
                    });
                    var infowindow = new google.maps.InfoWindow();
                    var marker, i;
                    for (i = 0; i < marcadores.length; i++) {
                        marker = new google.maps.Marker({
                            position: new google.maps.LatLng(marcadores[i][1], marcadores[i][2]),
                            map: map
                        });
                        google.maps.event.addListener(marker, \'click\', (function(marker, i) {
                            return function() {
                                infowindow.setContent(marcadores[i][0]);
                                infowindow.open(map, marker);
                            }
                        })(marker, i));
                    }
                }
                google.maps.event.addDomListener(window, \'load\', initialize);
            </script>
            <div id="mapa"></div>
            <!--mapa-->
        </div>';

        return $map;
    }

    static function generaModalPaises($data, $links, $basePath)
    {

        $paises = '<div class="container">';
        $count = 1;
        foreach ($data as $k => $p) {
            $countCollapse = substr_count($paises, "#collapse") ?: 0;
            $acordeonTwo = substr_count($paises, 'id="accordionExample') ?: 0;
            //Generacion de banderas
            if ($count == 1) {
                $paises .= '<div class="row mt-2 mb-2">';
            }
            $paises .= '<div class="col col-md-4 col-sm-12 d-flex align-items-center justify-content-center my-3">
                <div class="card shadow-sm border-0" style="width: 18rem;">
                    <a href="#" data-bs-toggle="modal" data-bs-target="#' . preg_replace('/\s+/', '', $p['nombre']) . '"><img src="' . $basePath . $p['bandera'] . '" class="card-img-top" alt="..."></a>
                    <div class="card-body text-center">
                        <a href="#" data-bs-toggle="modal" data-bs-target="#' . preg_replace('/\s+/', '', $p['nombre']) . '">' . mb_strtoupper($p['nombre']) . '</a>
                    </div>
                </div>
            </div>';
            //Generacion de modales
            $modal = '<div class="modal fade" id="' . preg_replace('/\s+/', '', $p['nombre']) . '" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content text-justify">
                        <div class="modal-header modal-header-style" data-bs-theme="dark">
                            <h1 class="modal-title fs-6" id="exampleModalLabel">' . mb_strtoupper($p['titulo']) . '</h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">';

            foreach ($p['modal'] as $mk => $mv) {
                $modal .= self::generalHtml($mv, $links, $acordeonTwo, $countCollapse);
            }

            $modal .= '</div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancelar</button>
                        </div>
                    </div>
                </div>
            </div>';
            $paises .= $modal;
            if ($count == 3) {
                $paises .= '</div>';
                $count = 1;
                continue;
            }
            $count++;
        }
        $paises .= '</div>';

        return $paises;
    }

    static function generaBanner($fondo = false)
    {
        $color = $fondo == true ? 'bg-body-morena' : 'bg-promocion';
        $clase = $fondo == true ? 'header' : 'promocion';
        $banner = '<div class="container-fluid ' . $color . '" style="font-family: arial;">
                <div class="container py-4">
                    <div class="row">';
        foreach ($_SESSION['banner'] as $k => $v) {
            if ($k == '1') {
                $banner .= '<div class="col-sm-12 col-md-6 offset-xl-1">
                    <p class="title-' . $clase . '"><b>' . $v['titulo'] . '</b></p>
                    <p class="text-' . $clase . '">' . $v['subtitulo'] . '</p>
                    <div>
                        <a href="https://apps.apple.com/us/app/guest-assist/id1417283017?l=es&ls=1" ><img src="' . $v['imagenes'][0]['imagen'] . '" class="img-fluid download-btn"></a>&nbsp;
                        <a href="https://play.google.com/store/apps/details?id=sedetur.guestassist" ><img src="' . $v['imagenes'][1]['imagen'] . '" class="img-fluid download-btn"></a>
                    </div>
                </div>';
            }
            if ($k == '2') {
                $banner .= '<div class="col-sm-12 col-md-5 text-center py-3">
                    <img src="' . $v['imagenBanner'] . '" class="img-fluid" style="width: 300px;" alt="Imagen de iPhone">
                </div>';
            }
        }
        $banner .= '</div>
                </div>';
        $banner .= '</div>';
        return $banner;
    }

    static function generaAccesosDirecto()
    {

        $accesoDirectoJson = $_SESSION['accesosDirectos'];

        $output = '<div class="container d-none d-md-block text-center">';
        $output .= '<div class="row row-cols-' . self::calculateColumns($accesoDirectoJson) . '">';

        foreach ($accesoDirectoJson as $accesoDirecto) {
            $output .= self::generateDirectLink($accesoDirecto);
        }

        $output .= '</div>';
        $output .= '<div class="row row-cols-' . self::calculateColumns($accesoDirectoJson) . '">';

        foreach ($accesoDirectoJson as $accesoDirecto) {
            $output .= self::generateDirectText($accesoDirecto);
        }

        $output .= '</div>';
        $output .= '</div>';
        return $output;
    }


    // static function generaFooter(){

    // }

    private static function calculateColumns($json): int
    {
        // Determinar el número óptimo de columnas
        // Puedes ajustar aquí tu lógica para definir el número de columnas
        // Por ejemplo, puedes establecer un máximo de columnas o definir un número fijo
        // Aquí hay un ejemplo simple que usa 6 como máximo
        $totalItems = count($json);
        $maxColumns = 6;
        return min($maxColumns, $totalItems);
    }

    private static function generateDirectLink($accesoDirecto): string
    {
        return '<div class="col">
                    <div class="p-3"><a href="' . $accesoDirecto['frmUrlShortcuts'] . '"><img src="' . $accesoDirecto['frmIconoShortcuts'] . '" class="img-fluid" style="max-width: 50px; margin-top: 9%;"></a></div>
                </div>';
    }

    private static function generateDirectText($accesoDirecto): string
    {
        return '<div class="col">
                    <div class="pb-3"><a href="' . $accesoDirecto['frmUrlShortcuts'] . '" class="text-submenu">' . $accesoDirecto['frmEtiquetaShortcuts'] . '</a></div>
                </div>';
    }

    static function generaMenuPublico()
    {
        $out = '<ul class="navbar-nav mx-auto mb-2 mb-lg-0">' . PHP_EOL;
//        dd($_SESSION['menuPublico']);
        foreach ($_SESSION['menuPublico'] as $key => $value) {
            if ($_SESSION['menuPublico'][$key]['show_condition'] && $_SESSION['menuPublico'][$key]['parent'] == 0) {
                $out .= '<li class="nav-item';
                if (self::hasChildren($key)) {
                    $out .= ' dropdown';
                }
                $out .= '">';
                $out .= '<a class="nav-link';
                $closeClass = '"';
                if (self::hasChildren($key)) {
                    $out .= ' dropdown-toggle" role="button" data-bs-toggle="dropdown" aria-expanded="false" ';
                    $closeClass = ' ';
                }
                $out .= $closeClass . ' href="' . $_SESSION['menuPublico'][$key]['link'] . '">' . $_SESSION['menuPublico'][$key]['text'] . '</a>';
                $out .= self::getChilds($key);
                $out .= '</li>' . PHP_EOL;
            }
        }
        $out .= '</ul>' . PHP_EOL;

        return $out;
    }

    private static function getChilds(int $el_id): string
    {
        $out = '';
        $hasChildren = false;

        foreach ($_SESSION['menuPublico'] as $key => $value) {
            if ($_SESSION['menuPublico'][$key]['show_condition'] && $_SESSION['menuPublico'][$key]['parent'] == $el_id) {
                if (!$hasChildren) {
                    $out .= PHP_EOL . '<ul class="dropdown-menu">';
                    $hasChildren = true;
                }

                $out .= PHP_EOL . '<li><a class="dropdown-item" style="color: black" href="' . $_SESSION['menuPublico'][$key]['link'] . '">' . $_SESSION['menuPublico'][$key]['text'] . '</a></li>' . PHP_EOL;
            }
        }

        if ($hasChildren) {
            $out .= '</ul>' . PHP_EOL;
        }

        return $out;
    }

    private static function hasChildren(int $el_id): bool
    {
        foreach ($_SESSION['menuPublico'] as $key => $value) {
            if ($_SESSION['menuPublico'][$key]['parent'] == $el_id) {
                return true;
            }
        }

        return false;
    }

}
