<?php
namespace Application\Library\Api;

use Application\Library\Complements\MyLogger;
use Application\Library\Project\Server;
use Laminas\Stdlib\ArrayUtils;
use Laminas\Http\Request;
use Laminas\Http\Headers;
use Laminas\Http\Client;

/**
 * It manages all data related to API connection.
 * @author workstation2
 */
class Api
{
    
    /**
     * Returns a full URL for a URI.
     * @param string $uri
     * @return string
     */
    static function url($uri)
    {
        $appConfig = require __DIR__ . '/../../../../../config/application.config.php';
        if (file_exists(__DIR__ . '/../../../../../config/development.config.php')) {
            $appConfig = ArrayUtils::merge($appConfig, require __DIR__ . '/../../../../../config/development.config.php');
        }
        $api = $appConfig['environment']['api'];
        $baseURL = $api['protocol'].'://'.$api['domain'].':'.$api['port'];
        return $baseURL.$uri;
    }
    
    /**
     * Makes a request to the API.
     * @param string $uri
     * @param string $method
     * @param array $params
     * @return \Laminas\Http\Response
     */
    static function request($uri, $method, $params = null, $auth = true)
    {
        // Se intenta obtener la IP del cliente.
//         $ipRemota = @$_SERVER['HTTP_CLIENT_IP'] ? : (@$_SERVER['HTTP_X_FORWARDED_FOR'] ? : '0.0.0.0');
        
        // Se prepara la cabecera.
        $headers = new Headers();
        $headers->addHeaders([
            'Content-Type' => 'application/json',
            'Accept' => 'application/json',
//             'Affiliate' => $_COOKIE['affiliate']
        ]);
        if($auth) {
            $headers->addHeaders([
                'Authorization' => 'Bearer '.@$_COOKIE['accessToken'],
                'Session-Token' => @$_COOKIE['sessionToken'],
                'Refresh-Token' => @$_COOKIE['refreshToken']
            ]);
        }
        
        // Se prepara el request.
        $request = new Request();
        $request->setHeaders($headers);
        $request->setUri(self::url($uri));
        $request->setMethod($method);
        if($method == Request::METHOD_GET) {
            if($params) {
                foreach($params as $name => $value) {
                    $request->getQuery()->set($name, $value);
                }
            }
        } else {
            $request->setContent(json_encode($params));
        }
        
        // Se envía la petición.
        $client = new Client();
        $client->setRequest($request);
        $client->setOptions([
            'timeout' => 60
        ]);
        $response = $client->send();
        // MyLogger::info($request);
        // MyLogger::info($client);
        // If access token is expired.
        if($response->getStatusCode() == 401 && $uri != '/registro') {
            
            // It tries to refresh the token.
            $refreshRequest = new Request();
            $refreshRequest->setHeaders($headers);
            $refreshRequest->setUri(self::url('/refresh'));
            $refreshRequest->setMethod('POST');
            $client->setRequest($refreshRequest);
            $response = $client->send();
            
            // If refresh token has expired, then user is logged out.
            if($response->getStatusCode() == 401) {
                Server::redirectTo('/auth/logout');
            }
            
            // If access token could not been refreshed, so redirects to logout.
            $data = json_decode($response->getBody(), true);
            if(empty($data['accessToken'])) {
                Server::redirectTo('/auth/logout');
            }
            setcookie('accessToken', $data['accessToken'], 0, '/');
            
            // It is sent again the original request with the refreshed access token.
            $newHeaders = new Headers();
            $oldHeaders = $headers->toArray();
            $oldHeaders['Authorization'] = 'Bearer '.$data['accessToken'];
            $newHeaders->addHeaders($oldHeaders);
            $request->setHeaders($newHeaders);
            $client->setRequest($request);
            $response = $client->send();
        }
        return $response;
    }
}