import {ref} from 'vue';

export function usePrivilege() {
	
	let privilege = ref({
		maxLevels: 3,
		privileges: [],
		menu: [],
		selection: [],
		selected: [],
		// Returns a PrimeVue tree structure.
		tree: function(privileges, selected = []) {
			this.privileges = privileges;
			this.selected = selected;
			this.menu = [];
			return this.children(this.menu, null, 1);
		},
		// Helps to generate the tree structure.
		children: function(children, parent, level) {
			if(level > this.maxLevels) {
				return [];
			}
			for(let p of this.privileges) {
				if(p['frmParentMenu'] === parent) {
					children.push({
						key: p['frmIdMenu'],
						label: p['frmLabelMenu'],
						status: this.selected.includes(parseInt(p['frmIdMenu'])) ? 'checked' : null,
						children: []
					});
					children[children.length-1]['children'] = this.children(children[children.length-1]['children'], p['frmIdMenu'], level + 1);
				}
			}
			return children;
		},
		// Generates the array for the selection status.
		// Non-native method because it is not present in PrimeVue plugin.
		selection: function(privileges) {
			let selection = {};
			for(let [i1, v1] of privileges.entries()) { // Level 1
				if(v1.children.length > 0) {
					let checkeds1 = 0;
					for(let [i2, v2] of v1.children.entries()) { // Level 2
						if(v2.children.length > 0) {
							let checkeds2 = 0;
							for(let [i3, v3] of v2.children.entries()) { // Level 3
								checkeds2 += v3.status == 'checked' ? 1 : 0;
								selection[v3.key] = {checked: v3.status == 'checked'};
							}
							selection[v2.key] = checkeds2 == 0 ? {checked: null, partialChecked: null} : (checkeds2 == v2.children.length ? {checked: true, partialChecked: false} : {checked: false, partialChecked: true});
						} else {
							selection[v2.key] = {checked: v2.status == 'checked'};
						}
						checkeds1 += selection[v2.key]['checked'] == true ? 1 : 0;
					}
					selection[v1.key] = checkeds1 == 0 ? {checked: null, partialChecked: null} : (checkeds1 == v1.children.length ? {checked: true, partialChecked: false} : {checked: false, partialChecked: true});
				} else {
					selection[v1.key] = {checked: v1.status == 'checked', partialChecked: false};
				}
			}
			return selection;
		}
	});
	
	return privilege;
}