import {defineRule, configure} from 'vee-validate';
import {loadLocaleFromURL, localize} from '@vee-validate/i18n';
import AllRules from '@vee-validate/rules';

/**
 * Contiene funciones y propiedades de un objeto request.
 */
export function useInitialize() {
	
	// Se registran las validaciones de VeeValidate.
    Object.keys(AllRules).forEach(rule => {
        defineRule(rule, AllRules[rule])
    });

    // Se cargan los mensajes de validación en el idioma del sistema.
    let idioma = ('; '+document.cookie).split('; idioma=').pop().split(';')[0];
    idioma = idioma ? idioma.substring(0,2) : 'es';
    loadLocaleFromURL(`/node_modules/@vee-validate/i18n/dist/locale/${idioma}.json`);
    configure({
        generateMessage: localize(idioma)
    });
	
}