import {ref} from 'vue';

export function useApi() {
	
	// Returns the value of a cookie.
	function getCookieValue(name)
	{
		var match = document.cookie.match(new RegExp('(^| )'+name+'=([^;]+)'));
		return match ? match[2] : '';
	}
	
	let baseURL = getCookieValue('api');
	
	let api = ref({
		request: function(method, url, id = null, params = {}) {
			
			// URL to an entity or resource.
			url = id > 0 ? `${url}/${id}` : url;
			
			let module = document.getElementById('app').dataset.controller ? document.getElementById('app').dataset.controller : 'Home';
			
			// Request configuration.
			let config = {
            	method: method,
            	headers: { 
            		'Content-Type': 'application/json',
            		'Accept': 'application/json',
            		'Affiliate': getCookieValue('affiliate'),
            		'Authorization': `Bearer ${getCookieValue('accessToken')}`,
            		'Session-Token': getCookieValue('sessionToken'),
            		'Refresh-Token': getCookieValue('refreshToken'),
					'Module': module
            	}
            };
			
			// If it is a GET request parameters are added to the URL, if not, are appended to therequest body.
			if(method == 'GET') {
				url = url + (Object.keys(params).length > 0 ? '?' + new URLSearchParams(params) : '');
			} else {
				config.body = JSON.stringify(params);
			}
			
			let base = unescape(baseURL);
			
			// Request to the URL with configuration.
			return fetch(base + url, config).then(async response => {
				let r = response;
				// If access token expired, refresh token request flow is performed.
				if(r.status == 401 && url != '/authentication') {
					let configRefresh = JSON.parse(JSON.stringify(config));
					configRefresh.method = 'POST';
					// Regeneration of access token is requested.
					await fetch(base + '/refresh', configRefresh).then(async response => {
						// It validates if refresh token is valid.
						if(response.status == 401) {
							window.location = '/app/logout';
							return;
						}
						// Cookies are set again.
						await response.json().then(async response => {
							document.cookie = `accessToken=${response.accessToken};path=/`;
							config.headers.Authorization = `Bearer ${response.accessToken}`;
							// Request is made again.
							await fetch(base + url, config).then(response => {
								r = response;
							});
						});
					});
				}
            	return r.status == 200 ? r.json() : r;
            }).catch((e) => {
            	console.log(e);
            });
		}
	});
	return api;
}