/**
 * Componente para la generación de una sección de título.
 */
export default {
	props: [
		'title'	// Título a mostrarse.
	],
	data() {
		return {
			// Texto de título a mostrarse.
			text: ''
		}
	},
	created() {
		// Se asigna el título que asigne el usuario.
		this.text = this.title;
	},
	template: `
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-8 col-md-offset-2">
				<h2>{{text}}</h2>
			</div>
		</div>
	`
}