$(function() {

    $(document).ajaxSend(function() {
        $("#overlay").fadeIn(300);
    });



    $('#formAsesoriaLegal').on('submit', function (e) {
        e.preventDefault();

        let form = this;

        const correoInput = $('#correo');
        const correo = correoInput.val().trim();

        correoInput[0].setCustomValidity('');
        correoInput.removeClass('is-valid is-invalid');
        correoInput.next('.invalid-feedback').text('');

        if (!correo) {
            correoInput[0].setCustomValidity('Este campo es obligatorio.');
            correoInput.addClass('is-invalid');
            correoInput.next('.invalid-feedback').text('Este campo es obligatorio.');
        }
        else if (!validarCorreo(correo)) {
            correoInput[0].setCustomValidity('Correo no válido');
            correoInput.addClass('is-invalid');
            correoInput.next('.invalid-feedback').text('Correo no válido');
        }
        else {
            correoInput.addClass('is-valid');
        }


        const habitacion = $('#no_habitacion');
        const valorHabitacion = habitacion.val().trim();

        habitacion[0].setCustomValidity('');
        habitacion.removeClass('is-valid is-invalid');
        habitacion.next('.invalid-feedback').text('');

        if (!valorHabitacion) {
            habitacion[0].setCustomValidity('Este campo es obligatorio.');
            habitacion.addClass('is-invalid');
            habitacion.next('.invalid-feedback').text('Este campo es obligatorio.');
        }
        else if (!/^\d+$/.test(valorHabitacion)) {
            habitacion[0].setCustomValidity('Solo se permiten números.');
            habitacion.addClass('is-invalid');
            habitacion.next('.invalid-feedback').text('Solo se permiten números.');
        }
        else {
            habitacion.addClass('is-valid');
        }


        const phone = $('#celular');
        const valor = phone.val().replace(/\D/g, '');

        phone[0].setCustomValidity('');
        phone.removeClass('is-valid is-invalid');
        phone.next('.invalid-feedback').text('');

        if (!valor) {
            phone[0].setCustomValidity('Este campo es obligatorio.');
            phone.addClass('is-invalid');
            phone.next('.invalid-feedback').text('Este campo es obligatorio.');
        }
        else if (valor.length < 7 || valor.length > 15) {
            phone[0].setCustomValidity('Debe contener entre 7 y 15 dígitos');
            phone.addClass('is-invalid');
            phone.next('.invalid-feedback').text('Debe contener entre 7 y 15 dígitos');
        }
        else {
            phone.addClass('is-valid');
        }


        if (form.checkValidity()) {

            $.ajax({
                type: 'POST',
                url: '/servicios/form-asesoria-legal', // cambia por tu endpoint real
                data: $(this).serialize(),
                success: function(response){
                    if (response.success === true) {
                        toastr.success(response.message);
                        cleanForm();

                    } else {
                        cleanForm();
                        toastr.warning(response.message);
                    }
                },
                error: function(){
                    toastr.error('Ocurrió un error, contacte al área de servicio o intente más tarde.');
                },
                complete: function(){
                    // Oculta el overlay después de completar la petición
                    setTimeout(function(){
                        $("#overlay").fadeOut(300);
                    }, 500);
                }
            });

        } else {
            $(form).addClass('was-validated');
        }
    });

});

function validarCorreo(correo) {
    const regex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    return regex.test(correo);
}


function validarSelect2(selector) {
    const $select = $(selector);
    const $container = $select.next('.select2-container');
    const valor = $select.val();

    const esValido = valor && valor !== "";

    $container.removeClass('is-valid is-invalid');

    if (esValido) {
        $container.addClass('is-valid');
    } else {
        $container.addClass('is-invalid');
    }
}

function cleanForm(){
    $('#formAsesoriaLegal')[0].reset();
    $('#formAsesoriaLegal')
        .removeClass('was-validated')
        .find('.is-valid, .is-invalid')
        .removeClass('is-valid is-invalid');

    $('#formAsesoriaLegal .invalid-feedback').text('');
}