<?php
namespace Application\Library\Project;

/**
 * It manages data related to the server.
 * @author workstation2
 */
class Server
{

    /**
     * Returns and absolut URL based on the current server.
     * @param string $url
     * @param string $keepWww
     * @return string
     */
    static function url($url, $keepProtocol = true, $keepWww = false)
    {
        $protocol = (@$_SERVER['HTTPS'] == 'on' || @$_SERVER['SERVER_PORT'] == 443) ? 'https' : 'http';
        $host = $keepWww ? $_SERVER['HTTP_HOST'] : str_replace('www.', '', $_SERVER['HTTP_HOST']);
        return ($keepProtocol ? $protocol.'://' : '').$host.$url;
    }
    
    /**
     * Redirects to a new URL.
     * @param string $url
     */
    static function redirectTo($url)
    {
        header('Location: '.self::url($url), true, 302);
        exit();
    }
}