<?php

namespace Application\Library\Data;


class ProteccionSanitaria {
        /**
     * @var array $data Lista con el contenido para la página de Temporada de huracanes por idioma
     */
    private $data;

    /**
     * 
     */
    const LANG_ESP = 1;
    const LANG_ENG = 2;
    const LANG_FRA = 3;
    const LANG_DEU = 4;
    const LANG_POR = 5;
    const LANG_RUS = 6;
    const LANG_FALLBACK = 1;
    const BASE_PATH = "https://apiga.bemira.mx:443/";

    function __construct() {
        $this->data = [
            [
                "frmIdIdioma" => self::LANG_ESP,
                "frmBasePath" => self::BASE_PATH,
                "frmInfo" => [
                    "subMenu" => "Recomendaciones de protección sanitaria",
                    "contenido" => [
                        "subtitulo1" => "Si te cuidas tú, nos cuidas a todos.",

                        "texto1" => "El Caribe Mexicano cuenta con protocolos de prevención, detección y atención para vigilancia epidemiológica, y con una red hospitalaria y de laboratorios de análisis clínicos para la atención y la realización de las pruebas diagnósticas en caso de ser necesario.",

                        "texto2" => "Las siguientes medidas son altamente efectivas para disminuir la posibilidad de contagio de muchas enfermedades contagiosas que debes tomar en cuenta para tu viaje:",

                        "listado1" => [
                            "Lavado de manos frecuentes usando agua y jabón o utilizar gel con base de alcohol al 70%", // inicio de items de listado
    
                            "Cubrirse boca y nariz con pañuelos desechables o con el pliegue del codo al estornudar.",
    
                            "Evitar tocarse los ojos, la nariz y la boca.",
    
                            "Las siguientes medidas son altamente efectivas para disminuir la posibilidad de contagio de muchas enfermedades contagiosas que debes tomar en cuenta para tu viaje:", // este texto está repetido, se ingnorará
    
                            "Mantener una sana distancia.",
    
                            "Evitar lugares concurridos si estás enfermo.",
    
                            "Evitar en lo posible el contacto con personas enfermas.",
    
                            "Uso correcto del cubrebocas, cuando necesario.", // fin de listado
                        ],

                        "subtitulo2" => "Certificación en Protección y Prevención Sanitaria en Instalaciones Turísticas",

                        "texto3" => "Con el objetivo de mantener las medidas sanitarias necesarias para la prevención y contención de enfermedades contagiosas en nuestros destinos turísticos, la Secretaría de Turismo y la Secretaría de Salud, junto con el apoyo de especialistas y empresarios del sector hemos establecido la Certificación en Protección y Prevención Sanitaria en Instalaciones Turísticas.\n\nLa certificación establece y vela por el cumplimiento de buenas prácticas sanitarias al interior de los establecimientos turísticos, con el fin de dotar de confianza y certeza todos nuestros turistas.\n\nPregunta a tu prestador de servicios turístico si ya cuenta con la Certificación y viaja tranquilo.",

//                        "texto4" => [
//                            "Para más detalles de la certificación visita el link: ",
//                            "https://geoportal.qroo.gob.mx/CPPSIT/",
//                        ],

//                        "subtitulo3" => "Sello de Seguridad Global (Global Safety Stamp)",
//
//                        "texto5" => 'El Caribe Mexicano fue uno de los primeros destinos a nivel mundial en recibir el Sello de Seguridad Global (Global Safety Stamp) que entrega el Consejo Mundial de Viajes y Turismo - World Travel & Tourism Council - al ser un destino con estándares para garantizar la higiene de establecimientos y medidas para proteger la salud de los viajeros, confirmando que los destinos del Caribe Mexicano son seguros para visitar.\n\nWTTC afirma que: El sello especialmente diseñado permitirá a los viajeros reconocer a gobiernos y empresas de todo el mundo que han adoptado protocolos globales estandarizados de salud e higiene, para que los consumidores puedan experimentar "viajes seguros".',

                        "subtitulo4" => "Consulta el sitio web de la Secretaría de Salud de Quintana Roo",

                        "texto6" =>  [
                            "Para información actualizada sobre el #coronavirus COVID-19 en el Caribe Mexicano, accede al sitio web de la Secretaría de Salud:",
                            "https://qroo.gob.mx/sesa"
                        ],
                    ]
                ],
            ],
            [
                "frmIdIdioma" => self::LANG_ENG,
                "frmBasePath" => self::BASE_PATH,
                "frmInfo" => [
                    "subMenu" => "Health protection recommendations",
                    "contenido" => [
                        "subtitulo1" => "If you take care of yourself, you take care of us all.",

                        "texto1" => "The Mexican Caribbean has prevention, detection and care protocols for epidemiological surveillance, and a network of hospitals and clinical analysis laboratories for care and carrying out diagnostic tests if necessary.",

                        "texto2" => "The following measures are highly effective in reducing the possibility of contagion of many contagious diseases that you should take into account for your trip:",

                        "listado1" => [
                            "Wash your hands frequently using soap and water or use 70% alcohol-based gel.",
    
                            "Cover your mouth and nose with disposable tissues or the inside of your elbow when sneezing.",
    
                            "Avoid touching your eyes, nose and mouth.",
    
                            "The following measures are highly effective in reducing the possibility of contagion of many contagious diseases that you should take into account for your trip:", // Revisar este texto porque se está repitiendo en esp pero no se repite en idioma eng
    
                            "Maintain a healthy distance.",
    
                            "Avoid crowded places if you are sick.",
    
                            "Avoid contact with sick people as much as possible.",
                            
                            "Use the face mask correctly, when necessary.",
                        ],


                        "subtitulo2" => "Certification in Health Protection and Prevention in Tourist Facilities",

                        "texto3" => "With the aim of maintaining the necessary health measures for the prevention and containment of contagious diseases in our tourist destinations, the Ministry of Tourism and the Ministry of Health, together with the support of specialists and businessmen in the sector, have established the Certification in Protection and Prevention Sanitary in Tourist Facilities.\n\nThe certification establishes and ensures compliance with good sanitary practices within tourist establishments, in order to provide confidence and certainty to all our tourists.\n\nAsk your tourist service provider if they already have the Certification and travel safely.",

//                        "texto4" => [
//                            "For more details on the certification visit the link: ",
//                            "https://geoportal.qroo.gob.mx/CPPSIT/",
//                        ],

//                        "subtitulo3" => "Global Safety Stamp",
//
//                        "texto5" => 'The Mexican Caribbean was one of the first destinations in the world to receive the Global Safety Stamp awarded by the World Travel & Tourism Council - being a destination with standards to guarantee hygiene of establishments and measures to protect the health of travelers, confirming that the destinations of the Mexican Caribbean are safe to visit.\n\nWTTC states that: The specially designed seal will allow travelers to recognize governments and companies around the world that have adopted standardized global health and hygiene protocols, so that consumers can experience "safe travel."',

                        "subtitulo4" => "Check the website of the Ministry of Health of Quintana Roo.",

                        "texto6" =>  [
                            "For updated information about the #coronavirus COVID-19 in the Mexican Caribbean, access the website of the Ministry of Health: ",
                            "https://qroo.gob.mx/sesa"
                            ],
                        ]
                ],
            ],
            [
                "frmIdIdioma" => self::LANG_POR,
                "frmBasePath" => self::BASE_PATH,
                "frmInfo" => [
                    "subMenu" => "Recomendações de proteção sanitária",
                    "contenido" => [
                        "subtitulo1" => "Se você se cuida, cuida de todos nós.",

                        "texto1" => "O Caribe Mexicano conta com protocolos de prevenção, detecção e atenção para vigilância epidemiológica, e com uma rede hospitalar e de laboratórios de análises clínicas para atendimento e realização de testes diagnósticos, se necessário.",

                        "texto2" => "As seguintes medidas são altamente eficazes para diminuir a possibilidade de contágio de muitas doenças contagiosas que você deve considerar para sua viagem:",

                        "listado1" => [
                            "Lavar as mãos frequentemente com água e sabão ou usar álcool em gel a 70%.",

                            "Cobrir a boca e o nariz com lenços descartáveis ou com o cotovelo ao tossir.",
    
                            "Evitar tocar os olhos, o nariz e a boca.",
                            
                            "As seguintes medidas são altamente eficazes para diminuir a possibilidade de contágio de muitas doenças contagiosas que você deve considerar para sua viagem:",
    
                            "Manter uma distância segura.",
    
                            "Evitar lugares lotados se estiver doente.",
    
                            "Evitar o contato com pessoas doentes sempre que possível.",
    
                            "Uso correto da máscara, quando necessário.",
                        ],


                        "subtitulo2" => "Certificação em Proteção e Prevenção Sanitária em Instalações Turísticas",

                        "texto3" => "Com o objetivo de manter as medidas sanitárias necessárias para a prevenção e contenção de doenças contagiosas em nossos destinos turísticos, a Secretaria de Turismo e a Secretaria de Saúde, juntamente com o apoio de especialistas e empresários do setor, estabeleceram a Certificação em Proteção e Prevenção Sanitária em Instalações Turísticas.\n\nA certificação estabelece e garante o cumprimento de boas práticas sanitárias dentro dos estabelecimentos turísticos, com o objetivo de proporcionar confiança e certeza a todos os nossos turistas.\n\nPergunte ao seu prestador de serviços turísticos se ele já possui a Certificação e viaje tranquilo.",

//                        "texto4" => [
//                            "Para mais detalhes sobre a certificação, visite o link: ",
//                            "https://geoportal.qroo.gob.mx/CPPSIT/",
//                        ],

//                        "subtitulo3" => "Selo de Segurança Global (Global Safety Stamp)",
//
//                        "texto5" => 'O Caribe Mexicano foi um dos primeiros destinos do mundo a receber o Selo de Segurança Global (Global Safety Stamp) concedido pelo Conselho Mundial de Viagens e Turismo (WTTC), por ser um destino com padrões para garantir a higiene de estabelecimentos e medidas para proteger a saúde dos viajantes, confirmando que os destinos do Caribe Mexicano são seguros para visitar.\n\nO WTTC afirma que: O selo especialmente projetado permitirá que os viajantes reconheçam governos e empresas em todo o mundo que adotaram protocolos globais padronizados de saúde e higiene, para que os consumidores possam experimentar "viagens seguras".',

                        "subtitulo4" => "Consulte o site da Secretaria de Saúde de Quintana Roo",

                        "texto6" =>  [
                            "Para informações atualizadas sobre o #coronavírus COVID-19 no Caribe Mexicano, acesse o site da Secretaria de Saúde: ",
                            "https://qroo.gob.mx/sesa"
                        ],
                    ]
                ],
            ],
            [
                "frmIdIdioma" => self::LANG_FRA,
                "frmBasePath" => self::BASE_PATH,
                "frmInfo" => [
                    "subMenu" => "Recommandations pour la protection sanitaire",
                    "contenido" => [
                        "subtitulo1" => "Si tu te protèges, tu nous protèges tous.",

                        "texto1" => "La région des Caraïbes mexicaines dispose de protocoles de prévention, de détection et de soins pour la surveillance épidémiologique, ainsi que dun réseau hospitalier et de laboratoires danalyses cliniques pour les soins et la réalisation des tests diagnostiques si nécessaire.",

                        "texto2" => "Les mesures suivantes sont hautement efficaces pour réduire la possibilité de contagion de nombreuses maladies infectieuses que vous devez prendre en compte pour votre voyage :",

                        "listado1" => [
                            "Lavage fréquent des mains avec de leau et du savon ou utilisation dun gel à base dalcool à 70 %.", // inicio de items de listado
    
                            "Se couvrir la bouche et le nez avec des mouchoirs jetables ou avec le pli du coude en éternuant.",
    
                            "Éviter de se toucher les yeux, le nez et la bouche.",
    
                            "Les mesures suivantes sont également hautement efficaces pour diminuer la possibilité de contagion.", // este texto está repetido, se ingnorará
    
                            "Maintenir une distance saine.",
    
                            "Éviter les endroits bondés si vous êtes malade.",
    
                            "Éviter autant que possible le contact avec des personnes malades.",
    
                            "Utilisation correcte du masque facial, lorsque nécessaire.", // fin de listado
                        ],

                        "subtitulo2" => "Certification en Protection et Prévention Sanitaire dans les Installations Touristiques",

                        "texto3" => "Dans le but de maintenir les mesures sanitaires nécessaires à la prévention et à la contenance des maladies contagieuses dans nos destinations touristiques, la Secrétariat du Tourisme et la Secrétariat de la Santé, avec le soutien de spécialistes et dentrepreneurs du secteur, avons établi la Certification en Protection et Prévention Sanitaire dans les Installations Touristiques./n/nLa certification établit et veille au respect des bonnes pratiques sanitaires à lintérieur des établissements touristiques, afin de fournir confiance et certitude à tous nos touristes.\n\Demandez à votre prestataire de services touristiques sil possède déjà la Certification et voyagez en toute tranquillité.",

//                        "texto4" => [
//                            "Pour plus de détails sur la certification, visitez le lien :",
//                            "https://geoportal.qroo.gob.mx/CPPSIT/",
//                        ],

//                        "subtitulo3" => "Sceau de Sécurité Mondial (Global Safety Stamp)",
//
//                        "texto5" => 'Le Mexique des Caraïbes a été lune des premières destinations au monde à recevoir le Sceau de Sécurité Mondial (Global Safety Stamp) décerné par le Conseil Mondial des Voyages et du Tourisme - World Travel & Tourism Council - car il sagit dune destination respectant des normes élevées pour garantir lhygiène des établissements et des mesures pour protéger la santé des voyageurs, confirmant ainsi que les destinations des Caraïbes mexicaines sont sûres à visiter./n/nLe WTTC affirme que : Le sceau spécialement conçu permettra aux voyageurs de reconnaître les gouvernements et entreprises du monde entier qui ont adopté des protocoles sanitaires et dhygiène standardisés au niveau mondial, permettant ainsi aux consommateurs de vivre des "voyages sûrs".',

                        "subtitulo4" => "Consultez le site web de la Secrétariat de la Santé de Quintana Roo",

                        "texto6" =>  [
                            "Pour des informations à jour sur le #coronavirus COVID-19 dans les Caraïbes mexicaines, accédez au site web de la Secrétariat de la Santé: ",
                            "https://qroo.gob.mx/sesa"],
                    ]
                ],
            ],
            [
                "frmIdIdioma" => self::LANG_DEU,
                "frmBasePath" => self::BASE_PATH,
                "frmInfo" => [
                    "subMenu" => "Empfehlungen zum Gesundheitsschutz",
                    "contenido" => [
                        "subtitulo1" => "Wenn du auf dich achtest, sorgst du für uns alle.",

                        "texto1" => "Die mexikanische Karibik verfügt über Präventions-, Erkennungs- und Behandlungsprotokolle für die epidemiologische Überwachung sowie über ein Netzwerk von Krankenhäusern und klinischen Laboratorien für die Betreuung und Durchführung diagnostischer Tests, falls erforderlich.",

                        "texto2" => "Die folgenden Maßnahmen sind sehr wirksam, um die Ansteckungsgefahr mit vielen ansteckenden Krankheiten zu verringern, die Sie bei Ihrer Reise berücksichtigen sollten:",

                        "listado1" => [
                            "Häufiges Händewaschen mit Wasser und Seife oder die Verwendung von alkoholbasiertem Gel mit 70 % Alkohol.", // inicio de items de listado
    
                            "Mund und Nase mit Wegwerftüchern oder mit der Armbeuge beim Niesen bedecken.",
    
                            "Vermeiden Sie es, sich Augen, Nase und Mund zu berühren.",
    
                            "Die folgenden Maßnahmen sind ebenfalls sehr wirksam, um die Ansteckungsgefahr zu verringern.", // este texto está repetido, se ingnorará
    
                            "Aufrechterhaltung eines gesunden Abstands.",
    
                            "Vermeiden von überfüllten Orten, wenn Sie krank sind.",
    
                            "Möglichst den Kontakt mit kranken Personen vermeiden.",
    
                            "Richtige Verwendung der Gesichtsmaske, wenn nötig.", // fin de listado
                        ],

                        "subtitulo2" => "Zertifizierung für Gesundheitsschutz und -prävention in touristischen Einrichtungen",

                        "texto3" => "Mit dem Ziel, die notwendigen Gesundheitsmaßnahmen zur Vorbeugung und Eindämmung von ansteckenden Krankheiten in unseren touristischen Zielen aufrechtzuerhalten, haben das Ministerium für Tourismus und das Gesundheitsministerium zusammen mit der Unterstützung von Fachleuten und Unternehmern aus dem Sektor die Zertifizierung für Gesundheitsschutz und -prävention in touristischen Einrichtungen eingeführt.\n\Die Zertifizierung legt gute sanitäre Praktiken innerhalb der touristischen Einrichtungen fest und sorgt für deren Einhaltung, um allen unseren Touristen Vertrauen und Sicherheit zu bieten.\n\Fragen Sie Ihren touristischen Dienstleister, ob er bereits zertifiziert ist, und reisen Sie beruhigt.",

//                        "texto4" => [
//                            "Für weitere Details zur Zertifizierung besuchen Sie den Link:",
//                            "https://geoportal.qroo.gob.mx/CPPSIT/",
//                        ],

//                        "subtitulo3" => "Globales Sicherheitssiegel (Global Safety Stamp)",
//
//                        "texto5" => 'Die mexikanische Karibik war eines der ersten Reiseziele weltweit, das das Globale Sicherheitssiegel (Global Safety Stamp) vom Weltverband für Reisen und Tourismus - World Travel & Tourism Council - erhalten hat. Dies bestätigt, dass es sich um ein Reiseziel handelt, das hohe Standards zur Gewährleistung der Hygiene in Einrichtungen und Maßnahmen zum Schutz der Gesundheit der Reisenden einhält, und bestätigt, dass die Destinationen in der mexikanischen Karibik sicher zu besuchen sind./n/nDas WTTC erklärt, dass das speziell entworfene Siegel es Reisenden ermöglicht, Regierungen und Unternehmen weltweit zu erkennen, die globale standardisierte Gesundheits- und Hygieneprotokolle angenommen haben, sodass Verbraucher "sichere Reisen" erleben können.',

                        "subtitulo4" => "Besuchen Sie die Webseite des Gesundheitsministeriums von Quintana Roo",

                        "texto6" =>  [
                            "Für aktuelle Informationen über das #coronavirus COVID-19 in der mexikanischen Karibik, besuchen Sie die Webseite des Gesundheitsministeriums: ",
                            "https://qroo.gob.mx/sesa"],
                    ]
                ],
            ],
            [
                "frmIdIdioma" => self::LANG_RUS,
                "frmBasePath" => self::BASE_PATH,
                "frmInfo" => [
                    "subMenu" => "Рекомендации по санитарной защите",
                    "contenido" => [
                        "subtitulo1" => "Если ты заботишься о себе, ты заботишься о всех нас.",

                        "texto1" => "Мексиканский Карибский регион располагает протоколами предотвращения, обнаружения и лечения для эпидемиологического надзора, а также сетью больниц и лабораторий клинических анализов для оказания помощи и проведения диагностических тестов при необходимости.",

                        "texto2" => "Следующие меры являются высокоэффективными для снижения возможности заражения многими заразными болезнями, которые вы должны учитывать во время вашего путешествия:",

                        "listado1" => [
                            "Частое мытье рук с мылом и водой или использование антисептического геля на основе 70% алкоголя.", // inicio de items de listado
    
                            "Прикрывать рот и нос одноразовыми салфетками или сгибом локтя при чихании.",
    
                            "Избегать прикосновения к глазам, носу и рту.",
    
                            "Следующие меры также являются высокоэффективными для снижения возможности заражения.", // este texto está repetido, se ingnorará
    
                            "Соблюдение безопасного расстояния.",
    
                            "Избегание многолюдных мест, если вы больны.",
    
                            "По возможности избегать контакта с больными людьми.",
    
                            "Правильное использование маски для лица, когда это необходимо.", // fin de listado
                        ],

                        "subtitulo2" => "Сертификация по Защите и Профилактике Санитарной Безопасности в Туристических Учреждениях",

                        "texto3" => "С целью поддержания необходимых санитарных мер для предотвращения и сдерживания заразных болезней в наших туристических направлениях, Министерство туризма и Министерство здравоохранения с поддержкой специалистов и предпринимателей отрасли учредили Сертификацию по Защите и Профилактике Санитарной Безопасности в Туристических Учреждениях.\n\Сертификация устанавливает и обеспечивает соблюдение хороших санитарных практик внутри туристических заведений, чтобы предоставить всем нашим туристам уверенность и надежность.\n\Спросите у вашего туристического оператора, есть ли у него уже сертификация, и путешествуйте спокойно.",

//                        "texto4" => [
//                            "Для получения дополнительной информации о сертификации посетите ссылку:",
//                            "https://geoportal.qroo.gob.mx/CPPSIT/",
//                        ],

//                        "subtitulo3" => "Глобальная марка безопасности (Global Safety Stamp)",
//
//                        "texto5" => 'Мексиканские Карибы стали одним из первых мировых направлений, получивших Глобальную марку безопасности (Global Safety Stamp), присуждаемую Всемирным советом по путешествиям и туризму - World Travel & Tourism Council - за соответствие высоким стандартам в области гигиены заведений и мер по защите здоровья путешественников, подтверждая, что направления мексиканских Карибов безопасны для посещения./n/nWTTC утверждает, что специально разработанная марка позволит путешественникам узнавать правительства и компании по всему миру, которые приняли глобальные стандартизированные протоколы здоровья и гигиены, чтобы потребители могли наслаждаться "безопасными путешествиями".',

                        "subtitulo4" => "Посетите веб-сайт Министерства здравоохранения Кинтана-Роо",

                        "texto6" =>  [
                            "Для получения актуальной информации о #коронавирусе COVID-19 на Мексиканских Карибах, перейдите на веб-сайт Министерства здравоохранения: ",
                            "https://qroo.gob.mx/sesa"],
                    ]
                ],
            ],
        ];
    }

    /**
     * getData
     * [Busca el contenido por idioma]
     */
    public function getData($langId = null) {
        if (empty($langId))
            return $this->data;

        // Búsqueda de index del contenido en el idioma elegido 
        $dataIndex = array_search($langId, array_column($this->data,"frmIdIdioma"));
        // Si se eligió un idioma

        if ($dataIndex === false)
            $dataIndex = array_search(self::LANG_FALLBACK, array_column($this->data, "frmIdIdioma"));

        return $this->data[$dataIndex];
    }
}