<?php

namespace Application\Library\Complements;

use Laminas\Filter\File\UpperCase;

class HtmlElements
{
    protected $apiUrl = 'https://guest-assist-api.workhub.company/';
    const apiUrlSedetur = 'https://sedeturqroo.gob.mx/auth/router.php';

    /**
     * generateAccordion
     * tipo: catalogo
     * Genera un acordeón con los estilos de bootstrap apartir de un arreglo.
     * param: $data
     * @return html
     */

    static function generateAccordion($data, $accordionId)
    {

        $html_acordeon = '';
        $html = '';

        for ($i = 0; $i < count($data); $i++) {
            $id = '"collapse' . $i . '"';
            $id2 = '"#collapse' . $i . '"';
            $idRediect = $idRediect + 1;
            $url = "";
            $html .= '<div class="accordion-item"> <h2 class="accordion-header">';

            if ($i == 0) {
                $html .= '<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target=' . $id2 . ' aria-expanded="true" aria-controls=' . $id . '>';
            } else {
                $html .= '<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target=' . $id2 . ' aria-expanded="false" aria-controls=' . $id . '>';
            }

            for ($e = 0; $e < count($data[$i]); $e++) {

                if ($e == 0) {
                    $acordeon_titulo = $data[$i][$e]['valor'];
                }
                if ($e == 1) {
                    $acordeon_direccion = $data[$i][$e]['etiqueta'] . $data[$i][$e]['valor'];
                }

                if ($e == 2) {
                    if ($data[$i][$e]['valor'] != null) {
                        $acordeon_telefono = $data[$i][$e]['etiqueta'] . $data[$i][$e]['valor'];
                    }
                }
                if ($e == 3) {
                    $acordeon_ver = $data[$i][$e]['valor'];
                }

            }

            $html .= $acordeon_titulo;
            $acordeon_titulo = "";
            $html .= '</button></h2>';
            if ($i == 0) {
                $html .= '<div id=' . $id . 'class="accordion-collapse collapse show" data-bs-parent=#' . $accordionId . '>';
            } else {
                $html .= '<div id=' . $id . 'class="accordion-collapse collapse" data-bs-parent=#' . $accordionId . '>';
            }
            $html .= '<div class="accordion-body text-div">';
            $html .= $acordeon_direccion;
            $acordeon_direccion = '';
            $html .= '<br>';
            $html .= $acordeon_telefono;
            $acordeon_telefono = '';
            $url .= '"/directorios/fiscalias/' . $idRediect . '"';
            $html .= '<br><a href=' . $url . 'class="over-div-enlaces">';
            $html .= $acordeon_ver;
            $acordeon_ver = '';
            $html .= '</a></div>';
            $html .= '</div></div>';

        }

        $html_acordeon .= $html;

        return $html_acordeon;

    }

    /**
     * generateListado
     * tipo: Listado
     * Genera un listado de parrafos con 3 textos concatenados.
     * param: $data
     * @return html
     */

    static function generateListadoConcat3Texts($data)
    {

        $listado = "";
        $desde = "";
        $pais = "";
        $llame = "";

        for ($i = 0; $i < count($data); $i++) {

            for ($e = 0; $e < count($data[$i]['parrafoUnion']); $e++) {

                if ($e == 0) {
                    $desde = $data[$i]['parrafoUnion'][$e]['valor'];
                }

                if ($e == 1) {
                    $pais = $data[$i]['parrafoUnion'][$e]['valor'];
                }

                if ($e == 2) {
                    $llame = $data[$i]['parrafoUnion'][$e]['valor'];
                }

            }

            $listado .= '<p>' . $desde . '<b>' . $pais . '</b>' . $llame . '</p>';
        }

        return $listado;
    }

    /**
     * generateListado
     * tipo: Listado
     * Genera un listado de parrafos con 2 textos concatenados.
     * param: $data
     * @return html
     */

    static function generateListadoConcat2Texts($data)
    {
        $obj = new HtmlElements();
        $icon = $obj->apiUrl . $data[0]['icono'];
        $startUl = "<ul class='text-div estilos-lista viñeta-img' style='list-style-image:url(" . $icon . ");'>";
        $body = "";
        $endUl = "<ul>";
        $textUl = "";
        $bodyUl = "";

        for ($i = 0; $i < count($data); $i++) {

            $textList = "";
            $textUl = "";
            $bodyUl = "";

            for ($e = 0; $e < count($data[$i]['parrafoUnion']); $e++) {


                if ($e == 0) {
                    $textUl = $data[$i]['parrafoUnion'][$e]['valor'];
                }

                if ($e == 1) {
                    $bodyUl = $data[$i]['parrafoUnion'][$e]['valor'];
                }

            }
            $textList .= '<li style="padding-bottom: 10px;"><b>' . $textUl . '</b>' . $bodyUl . '</li>';


            $body .= $textList;
        }

        $html = $startUl . $body . $endUl;

        return $html;

    }


    /**
     * generateModal
     * tipo: modal
     * [Genera un array con el modal y su elemento que lo activa]
     * @param mixed $data - array con los datos del modal
     * @param mixed $data - array con los enlaces que pueden ser usados
     * @param mixed $basePath - la url principal
     * @return array
     * */
    static function generateModal($data, $links, $basePath)
    {
        $modalId = preg_replace('/\s+/', '', $data['nombre']);
        $modalBody = "";
        foreach ($data["modal"] as $idx => $content):
            $contentType = array_keys($content)[0];

            $modalBody .= self::formatContentByType($content[$contentType], $contentType, $modalId, $basePath, $links);

        endforeach;
        $modalCaller = '<div class="card border-0 border-radious-0">
        <a href="#" data-bs-toggle="modal" data-bs-target="#' . $modalId . '"><img src="' . $basePath . $data['bandera'] . '" class="card-img-top rounded shadow" alt="..."></a>
        <div class="card-body text-center">
            <a href="#" data-bs-toggle="modal" data-bs-target="#' . $modalId . '">' . $data['nombre'] . '</a>
        </div>
        </div>';
        $modal = '<div class="modal fade" id="' . $modalId . '" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content text-justify">
                <div class="modal-header modal-header-style" data-bs-theme="dark">
                    <h1 class="modal-title fs-6" id="exampleModalLabel">' . mb_strtoupper($data['titulo']) . '</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                ' . $modalBody . '
                </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancelar</button>
                        </div>
                    </div>
                </div>
            </div>';
        return [
            "modalCaller" => $modalCaller,
            "modal" => $modal,
        ];
    }

    /**
     * formatContentByType
     * [Formatea un elemento dependiendo de su tipo]
     * @param mixed $name
     * @return string
     */
    static function formatContentByType($content, $contentType, $parentId, $basePath, $links)
    {
        $html = '';
        switch ($contentType) {
            case 'titulo':
                $html = self::getTituloHtml($content);
                break;

            case "acordeon":
                $html .= self::getAcordeonHtml($content, "accordion" . $parentId, $basePath, $links);
                break;
            default:
                $html = "";
                break;
        }
        return $html;
    }

    /**
     * getTituloHtml
     * tipo: titulo
     * [Regresa el contenido con formato de título]
     * @param string $title - el texto del título
     * @return string
     */
    private static function getTituloHtml($title)
    {
        return '<p class="subtitle-div">' . $title . '</p>';
    }

    /**
     * getAcordeonHtml
     * tipo: acordeon
     * [Regresa el contenido como un acordeon de bootstrap]
     * @param mixed $accordionContent - el array con la lista de items para el acordeon
     * @param mixed $accordionId - el ID que tendrá el elemento HTML del acordión
     * @return string
     */
    private static function getAcordeonHtml($accordionContent, $accordionId, $basePath, $links)
    {
        $html = '<div class="accordion mb-3" id="' . $accordionId . '">';

        // Contenido de acordeon
        foreach ($accordionContent as $idx => $accordion):
            $expanded = ($idx == 0) ? 'true' : 'false';
            $show = ($idx == 0) ? ' show' : '';
            $colap = ($idx == 0) ? '' : 'collapsed';
            $html .= '<div class="accordion-item">
            <h2 class="accordion-header">
                <button class="accordion-button ' . $colap . '" type="button" data-bs-toggle="collapse" data-bs-target="#' . $accordionId . $idx . '" aria-expanded="' . $expanded . '" aria-controls="' . $accordionId . $idx . '">
                    ' . $accordion['titulo'] . '
                </button>
            </h2>
            <div id="' . $accordionId . $idx . '" class="accordion-collapse collapse' . $show . '" data-bs-parent="#' . $accordionId . '" style="">
                <div class="accordion-body text-div">';

            // Cuerpo del acordeon
            if (is_iterable($accordion["subtitulo"])) {

            }

            $html .= '</div>
                </div>
            </div>';
        endforeach;

        $html .= '</div>';
        return $html;
    }

    /**
     * getListadoHatml
     * [Regresa una lista de html con los items que trae el contenido]
     * @param array $listItems - lista de items a incluir en la lista
     *
     */
    static function getListadoHtml($listItems = [], $basePath, $links)
    {
        if ($listItems[0]["icono"] == "false")
            $ul = '<ul class="text-div estilos-modulo-atencion">';
        else if ($listItems[0]['icono'] == 'interlineado')
            $ul = '<ul class="text-div">';
        else if (isset($listItems[0]['icono']) && !(str_contains($listItems[0]['icono'], '/circle-solid') || str_contains($listItems[0]['icono'], 'ban-solid') || str_contains($listItems[0]['icono'], 'angle-right-solid')))
            $ul = '<ul class="text-div estilos-lista viñeta-img" style="list-style-image:url(' . $basePath . $listItems[0]['icono'] . ');">';
//            dd($listItems[0]['icono']);
        else
            $ul = '<ul class="text-div">';

        $html = $ul;
        foreach ($listItems as $idxItem => $item):
            switch ($item["tipo"]) {
                case "texto":
                    if ($item['icono'] == 'hijo') {
                        $html .= '<li style="padding-left: 3rem;">' . $item['valor'] . '</li>';
                    } else if ($item['icono'] == 'interlineado') {
                        $html .= '<li>' . $item['valor'] . '</li><br>';
                    } else {
                        $html .= '<li>' . $item['valor'] . '</li>';
                    }
                    break;
                case "mixto":
                    $salida = BodyMap::generaLink($item, $links);
                    $html .= '<li>' . $salida . '</li>';
                    break;
            }
        endforeach;
        $html .= '</ul>';
        return $html;
    }

    /**
     * getTextoHtml
     * [Regresa un elemento de html formateado para texto]
     * @param string $text - texto sin formato
     * @return string
     */
    static function getTextoHtml($text)
    {
        return '<p class="text-div">' . $text . '</p>';
    }

    /**
     * getTextoHtml
     * [Regresa un elemento de html formateado para texto]
     * @param string $text - texto sin formato
     * @return string
     */
    static function generateBtnEmergency($data)
    {
        $btn = '<a href="tel:' . $data['link'] . '" class="btn btn-outline-danger emergencias"><img style="width: 20px; height: 20px; margin-right: 5px;" src="/img/icons/phone.PNG">' . mb_strtoupper($data['titulo']) . '</a>';

        return $btn;
    }

    /**
     * generateMultiParrafos
     * [Regresa una cadena de multiples parrafos]
     * @param string $data - texto sin formato
     * @return string
     */
    static function generateMultiParrafos($data)
    {
        $sections = "";
        $text = "";
        $body = "";

        for ($i = 0; $i < count($data); $i++) {

            if (array_key_exists('parrafoUnion', $data[$i])) {

                $textParrafo = "";

                for ($e = 0; $e < count($data[$i]['parrafoUnion']); $e++) {

                    if ($data[$i]['parrafoUnion'][$e]['tipo'] == 'bold') {
                        $textParrafo .= '<b>' . $data[$i]['parrafoUnion'][$e]['valor'] . '</b>';
                    } else {
                        $textParrafo .= $data[$i]['parrafoUnion'][$e]['valor'];
                    }
                }

                $sections .= '<p>' . $textParrafo . '</p>';
            } else {
                $text = $data[$i]['valor'];

                $sections .= '<p>' . $text . '</p>';
            }


        }

        return $sections;
    }

    /**
     * generateListasSimples
     * [Regresa una cadena de listas UL simples]
     * @param string $data - texto sin formato
     * @return string
     */
    static function generateListasSimples($data)
    {
        $obj = new HtmlElements();
        $icon = $obj->apiUrl . $data[0]['listado'][0]['icono'];
        $startUl = "<ul class='text-div estilos-lista viñeta-img' style='list-style-image:url(" . $icon . ");'>";
        $body = "";
        $endUl = "<ul>";

        for ($i = 0; $i < count($data); $i++) {

            $textList = "";

            for ($e = 0; $e < count($data[$i]['listado']); $e++) {

                if ($data[$i]['listado'][$e]['tipo'] == 'bold') {
                    $textList .= '<li style="padding-bottom: 10px;"><b>' . $data[$i]['listado'][$e]['valor'] . '</b></li>';
                } else {
                    $textList .= '<li style="padding-bottom: 10px;">' . $data[$i]['listado'][$e]['valor'] . '</li>';
                }
            }

            $body .= $textList;
        }

        $html = $startUl . $body . $endUl;

        return $html;
    }


    /**
     * getParrafoUnionHtml
     * [Une los items de un array en un solo texto, los tipos de texto pueden ser: texto, bold, mixto]
     * @param array $items - array de textos a unir
     */
    static function getParrafoUnionHtml($items, $links)
    {
        $html = '';
        foreach ($items as $item):
            switch ($item['tipo']) {
                case 'bold':
                    $html .= '<b>' . $item['valor'] . '</b> ';
                    break;
                case 'texto':
                    $html .= $item['valor'];
                    break;
                case 'mixto':
                    $salida = BodyMap::generaLink($item, $links);
                    $html .= $salida;
                    break;
            }
        endforeach;
        return $html;
    }

    /**
     * generateAccordion2
     * tipo: catalogo de hospiteles
     * Genera un acordeón con los estilos de bootstrap apartir de un arreglo.
     * param: $data
     * @return html
     */

    static function generateAccordion2($data, $accordionId)
    {

        $html_acordeon = '';
        $html = '';

        for ($i = 0; $i < count($data); $i++) {
            $id = '"collapse' . $i . '"';
            $id2 = '"#collapse' . $i . '"';
            $idRediect = $idRediect + 1;
            $url = "";
            $html .= '<div class="accordion-item"> <h2 class="accordion-header">';
            if ($i == 0) {
                $html .= '<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target=' . $id2 . ' aria-expanded="true" aria-controls=' . $id . '>';
            } else {
                $html .= '<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target=' . $id2 . ' aria-expanded="false" aria-controls=' . $id . '>';
            }

            for ($e = 0; $e < count($data[$i]); $e++) {

                if ($e == 0) {
                    $acordeon_titulo = $data[$i][$e]['valor'];
                }
                if ($e == 1) {
                    $acordeon_direccion = $data[$i][$e]['etiqueta'] . $data[$i][$e]['valor'];
                }

                if ($e == 2) {
                    $acordeon_telefono = $data[$i][$e]['etiqueta'] . $data[$i][$e]['valor'];
                }
                if ($e == 3) {
                    $acordeon_ver = $data[$i][$e]['valor'];
                }

            }

            $html .= $acordeon_titulo;
            $acordeon_titulo = "";
            $html .= '</button></h2>';
            if ($i == 0) {
                $html .= '<div id=' . $id . 'class="accordion-collapse collapse show" data-bs-parent=#' . $accordionId . '>';
            } else {
                $html .= '<div id=' . $id . 'class="accordion-collapse collapse" data-bs-parent=#' . $accordionId . '>';
            }

            $html .= '<div class="accordion-body text-div">';
            $html .= $acordeon_direccion;
            $acordeon_direccion = '';
            $html .= '<br>';
            $html .= $acordeon_telefono;
            $acordeon_telefono = '';
            $url .= '"/directorios/hospitales/' . $idRediect . '"';
            $html .= '<br><a href=' . $url . 'class="over-div-enlaces">';
            $html .= $acordeon_ver;
            $acordeon_ver = '';
            $html .= '</a></div>';
            $html .= '</div></div>';

        }

        $html_acordeon .= $html;

        return $html_acordeon;
    }

    /**
     * generateListasSinSubarrays
     * [Regresa una cadena de listas UL simples sin arrays internos]
     * @param string $data - texto sin formato
     * @return string
     */
    static function generateListasSinSubarrays($data, $links)
    {
        $obj = new HtmlElements();
        $icon = $obj->apiUrl . $data[0]['icono'];
        $startUl = "<ul class='text-div estilos-lista viñeta-img' style='list-style-image:url(" . $icon . ");'>";
        $body = "";
        $endUl = "<ul>";

        for ($i = 0; $i < count($data); $i++) {

            $textList = "";

            if ($data[$i]['tipo'] == 'bold') {

                $textList .= '<li style="padding-bottom: 10px;"><b>' . $data[$i]['valor'] . '</b></li>';

            } elseif ($data[$i]['tipo'] == 'mixto') {

                for ($e = 0; $e < count($links); $e++) {
                    $html = "";
                    $mystring = $data[$i]['valor'];
                    $findCode = $links[$e]['codigo'];
                    $find = strpos($mystring, $findCode);

                    if ($find) {
                        $replace = "<a class='over-div-enlaces' href='" . $links[$e]['link'] . "'>" . $links[$e]['titulo'] . "</a>";
                        $html = str_ireplace($findCode, $replace, $mystring);
                        $textList .= '<li style="padding-bottom: 10px;">' . $html . '</li>';
                    }
                }

            } else {
                $textList .= '<li style="padding-bottom: 10px;">' . $data[$i]['valor'] . '</li>';
            }

            $body .= $textList;
        }

        $html = $startUl . $body . $endUl;

        return $html;
    }

    /**
     * generateContenidoConLinks
     * [Regresa una cadena de texto con links formateados]
     * @param string $data - texto sin formato
     * @param arrray $links - arreglo de links
     * @return string
     */
    static function generateContenidoConLinks($data, $links)
    {
        $html = "";

        for ($i = 0; $i < count($links); $i++) {

            $mystring = $data;
            $findCode = $links[$i]['codigo'];
            $find = strpos($mystring, $findCode);
            if ($find) {

                if ($links[$i]['tipo'] == 'correo') {

                    $replace = "<a class='over-div-enlaces' href='mailto:" . $links[$i]['link'] . "'>" . $links[$i]['titulo'] . "</a>";
                    $html = str_ireplace($findCode, $replace, $mystring);

                } else {
                    $replace = "<a class='over-div-enlaces' href='" . $links[$i]['link'] . "'>" . $links[$i]['titulo'] . "</a>";
                    $html = str_ireplace($findCode, $replace, $mystring);
                }

            }
        }
        return $html;
    }

    static function generaTextVerMas()
    {
        $textUrl = "";
        switch ($_COOKIE['idIdioma']) {
            case "1": //Español
                $textUrl = "Saber más";
                break;
            case "2": //English
                $textUrl = "Know more";
                break;
            case "3": //Français
                $textUrl = "Savoir plus";
                break;
            case "4": //Deutsch
                $textUrl = "Mehr wissen";
                break;
            case "5": //Português
                $textUrl = "Saber mais";
                break;
            case "6": //Русский
                $textUrl = "Узнать больше";
                break;
        }

        return $textUrl;
    }

    static function generaTittlePostSection()
    {
        $textUrl = "";
        switch ($_COOKIE['idIdioma']) {
            case "1": //Español
                $textUrl = "También te podría interesar";
                break;
            case "2": //English
                $textUrl = "You might also be interested";
                break;
            case "3": //Français
                $textUrl = "Vous pourriez également être intéressé";
                break;
            case "4": //Deutsch
                $textUrl = "Vielleicht sind Sie auch interessiert";
                break;
            case "5": //Português
                $textUrl = "Você também pode estar interessado";
                break;
            case "6": //Русский
                $textUrl = "Вам также может быть интересно";
                break;
        }


        $textUrl = "<p class='tittle-section-post'>" . $textUrl . "</p>";
        return $textUrl;
    }

    static function generateTextCancelar()
    {
        $text = "";
        switch ($_COOKIE['idIdioma']) {
            case "1": //Español
                $text = "Cancelar";
                break;
            case "2": //English
                $text = "Cancel";
                break;
            case "3": //Français
                $text = "Annuler";
                break;
            case "4": //Deutsch
                $text = "Abbrechen";
                break;
            case "5": //Português
                $text = "Cancelar";
                break;
            case "6": //Русский
                $text = "Otmeha";
                break;
        }

        return $text;
    }

    static function generaTextSeleccionar()
    {
        $textUrl = "";
        switch ($_COOKIE['idIdioma']) {
            case "1": //Español
                $textUrl = "Seleccionar opción";
                break;
            case "2": //English
                $textUrl = "Select Option";
                break;
            case "3": //Français
                $textUrl = "Sélectionnez une option";
                break;
            case "4": //Deutsch
                $textUrl = "Wähle eine Option";
                break;
            case "5": //Português
                $textUrl = "Selecione a opção";
                break;
            case "6": //Русский
                $textUrl = "Выберите опцию";
                break;
        }
        return $textUrl;
    }

    static function generaTextCamposRequeridos()
    {
        $textUrl = "";
        switch ($_COOKIE['idIdioma']) {
            case "1": //Español
                $textUrl = "Campos obligatorios";
                break;
            case "2": //English
                $textUrl = "Required fields";
                break;
            case "3": //Français
                $textUrl = "CHAMPS OBLIGATOIRES";
                break;
            case "4": //Deutsch
                $textUrl = "Erforderliche Felder";
                break;
            case "5": //Português
                $textUrl = "Campos obrigatórios";
                break;
            case "6": //Русский
                $textUrl = "Обязательные поля";
                break;
        }
        return $textUrl;
    }

    static function generaTextNoAplica()
    {
        $textUrl = "";
        switch ($_COOKIE['idIdioma']) {
            case "1": //Español
                $textUrl = "no aplica";
                break;
            case "2": //English
                $textUrl = "does not apply";
                break;
            case "3": //Français
                $textUrl = "N’APPLIQUE PAS";
                break;
            case "4": //Deutsch
                $textUrl = "Nicht zutreffend";
                break;
            case "5": //Português
                $textUrl = "Não se aplica";
                break;
            case "6": //Русский
                $textUrl = "не применяется";
                break;
        }
        return $textUrl;
    }

    static function createDestinos($data)
    {
        $html = '';

        for ($i = 0; $i < count($data); $i++) {

            if ($data[$i]['frmActivoDestinoTuristico'] == 1) {
                $id = $i + 1;
                $start = '<option value="' . $id . '" >';
                $end = '</option>';

                $html .= $start . $data[$i]['frmNombreDestinoTuristico'] . $end;
            }
        }

        return $html;
    }

    static function filterMotivos($data, $idioma)
    {
        $html = [];

        for ($i = 0; $i < count($data); $i++) {

            if ($data[$i]['frmIdIdioma'] == $idioma) {
                $html[$i] = $data[$i];
            }
        }

        if (count($html == 0)) {
            for ($i = 0; $i < count($data); $i++) {

                if ($data[$i]['frmIdIdioma'] == '1') {
                    $html[$i] = $data[$i];
                }
            }
        }
        return $html;
    }

    static function generateListadoConcatBandera($data)
    {

        $listado = "";
        $desde = "";
        $pais = "";
        $llame = "";
//        dd($data);

        for ($i = 0; $i < count($data); $i++) {

            for ($e = 0; $e < count($data[$i]['parrafoUnion']); $e++) {

                if ($e == 0) {
                    $desde = HtmlElements::getBanderas($i);
//                    $desde = $data[$i]['parrafoUnion'][$e]['valor'];
                }

                if ($e == 1) {
                    $pais = $data[$i]['parrafoUnion'][$e]['valor'];
                }

                if ($e == 2) {
                    $llame = $data[$i]['parrafoUnion'][$e]['valor'];
                }

            }
            $listado .= '<div>';

            $listado .= '<img class=" m-1" src=' . $desde . 'style="width: 10%; height: auto; min-height: 20%;max-height: 50px;max-width: 20%;">';
            $listado .= '<p style=" display: inline-block; vertical-align: text-top;"><b>' . $pais . '</b>' . $llame . '</p>';
//            $listado .= '<p>' . $desde . '<b>' . $pais . '</b>' . $llame . '</p>';
            $listado .= '</div>';

        }


        return $listado;
    }

    static function getBanderas($data)
    {

        $banderas = array(
            '"/img/flags/España.png"',
            '"/img/flags/EEUUyCanada.png"',
            '"/img/flags/Brasil.png"',
            '"/img/flags/Inglaterra.png"',
            '"/img/flags/Alemania.png"',
            '"/img/flags/Francia.png"',
            '"/img/flags/Italia.png"',
            '"/img/flags/Argentina.png"',
            '"/img/flags/RESTO_MUNDO.png"'
        );

        return $banderas[$data];

    }

    /**
     * generateOptionsNacionalidades
     * [Obtiene las nacianalidades del WS de SEDETUR]
     * @return string
     */
    static function getNacionalidades()
    {
//        HtmlElements::validateTokenSedetur();

        /* Servicio para obtener nacionalidades  */
        $url = HtmlElements::apiUrlSedetur;
        $datos = [
            'token' => $_COOKIE['tokenSedetur'],
            'webservice' => 'getNacionalidades',
            'lang' => $_COOKIE['idIdioma'],
        ];
        $opciones = array(
            "http" => array(
                "header" => "Content-type: application/x-www-form-urlencoded\r\n",
                "method" => "POST",
                "content" => http_build_query($datos), # Agregar el contenido definido antes
            ),
        );
        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($url, false, $contexto);
        if ($resultado === false) {
            echo "Error haciendo petición";
            exit;
        }
        $result = json_decode($resultado);

        $nacionadidades = $result->Datos;

        return $nacionadidades;
    }

    /**
     * generateOptionsNacionalidades
     * [Genera las etiquetas html usando valores de getNacionalidades ]
     * @return string
     */
    static function generateOptionsNacionalidades()
    {
        $html = '';

        $nacionadidades = HtmlElements::getNacionalidades();

        for ($i = 0; $i < count($nacionadidades); $i++) {
            $html .= '<option value="' . $nacionadidades[$i]->s_nacionalidade_id . '">' . $nacionadidades[$i]->descripcion . '</option>';
        }

        return $html;
    }

    /**
     * getDestinos
     * [Obtiene los destinos del WS de SEDETUR]
     * @return string
     */
    static function getDestinos()
    {
//        HtmlElements::validateTokenSedetur();

        /* Servicio para obtener los destinos  */
        $url = HtmlElements::apiUrlSedetur;
        $datos = [
            'token' => $_COOKIE['tokenSedetur'],
            'webservice' => 'getDestinosTuristicosQRoo',
            'lang' => $_COOKIE['idIdioma'],
        ];
        $opciones = array(
            "http" => array(
                "header" => "Content-type: application/x-www-form-urlencoded\r\n",
                "method" => "POST",
                "content" => http_build_query($datos), # Agregar el contenido definido antes
            ),
        );
        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($url, false, $contexto);
        if ($resultado === false) {
            echo "Error haciendo petición";
            exit;
        }
        $result = json_decode($resultado);

        $data = $result->Datos;

        return $data;
    }

    /**
     * generateOptionsDestinos
     * [Genera las etiquetas html usando valores de getDestinos ]
     * @return string
     */
    static function generateOptionsDestinos()
    {
        $html = '';

        $destinos = HtmlElements::getDestinos();

        for ($i = 0; $i < count($destinos); $i++) {
            $html .= '<option value="' . $destinos[$i]->destino_id . '">' . $destinos[$i]->descripcion . '</option>';
        }

        return $html;

    }

    /**
     * getHospitales
     * [Obtiene los hospitales del WS de SEDETUR]
     * @return string
     */
    static function getHospitales()
    {
        HtmlElements::validateTokenSedetur();

        /* Servicio para obtener los hospitales  */
        $url = HtmlElements::apiUrlSedetur;
        $datos = [
            'token' => $_COOKIE['tokenSedetur'],
            'webservice' => 'getHospitales',
            'lang' => $_COOKIE['idIdioma'],
        ];
        $opciones = array(
            "http" => array(
                "header" => "Content-type: application/x-www-form-urlencoded\r\n",
                "method" => "POST",
                "content" => http_build_query($datos), # Agregar el contenido definido antes
            ),
        );
        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($url, false, $contexto);
        if ($resultado === false) {
            echo "Error haciendo petición";
            exit;
        }
        $result = json_decode($resultado);

        return $result;
    }

    /**
     * generateAccordionHospitales
     * [Genera las etiquetas html usando valores de getHospitales ]
     * @return string
     */
    static function generateAccordionHospitales()
    {
        $data = HtmlElements::getHospitales();

        $html_acordeon = '';

        $html = '<p class="title-div">' . mb_strtoupper($data->Titulo) . '</p>';

        for ($i = 0; $i <= count($data->Datos); $i++) {
            $id = '"collapse' . $i . '"';
            $id2 = '"#collapse' . $i . '"';
            $idRediect = $idRediect + 1;
            $url = "";
            $html .= '<div class="accordion-item"> <h2 class="accordion-header">';
            if ($i == 0) {
                $html .= '<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target=' . $id2 . ' aria-expanded="true" aria-controls=' . $id . '>';
            } else {
                $html .= '<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target=' . $id2 . ' aria-expanded="false" aria-controls=' . $id . '>';
            }

            $acordeon_titulo = $data->Datos[$i]->descripcion;
            $acordeon_direccion = 'Domicilio: ' . $data->Datos[$i]->direccion;
            $acordeon_telefono = 'Teléfono(s): ' . $data->Datos[$i]->telefono;
            $acordeon_ver = "Ver mapa";

            $html .= $acordeon_titulo;
            $acordeon_titulo = "";
            $html .= '</button></h2>';
            if ($i == 0) {
                $html .= '<div id=' . $id . 'class="accordion-collapse collapse show" data-bs-parent=#accordion1>';
            } else {
                $html .= '<div id=' . $id . 'class="accordion-collapse collapse" data-bs-parent=#accordion1>';
            }

            $html .= '<div class="accordion-body text-div">';
            $html .= $acordeon_direccion;
            $acordeon_direccion = '';
            $html .= '<br>';
            $html .= $acordeon_telefono;
            $acordeon_telefono = '';
            $url .= '"/directorios/hospitales/' . $idRediect . '"';
            $html .= '<br><a href=' . $url . 'class="over-div-enlaces">';
            $html .= $acordeon_ver;
            $acordeon_ver = '';
            $html .= '</a></div>';
            $html .= '</div></div>';

        }

        $html_acordeon .= $html;

        return $html_acordeon;
    }

    /**
     * getFiscalias
     * [Obtiene las fiscalias del WS de SEDETUR]
     * @return string
     */
    static function getFiscalias()
    {
        HtmlElements::validateTokenSedetur();

        /* Servicio para obtener las fiscalias  */
        $url = HtmlElements::apiUrlSedetur;
        $datos = [
            'token' => $_COOKIE['tokenSedetur'],
            'webservice' => 'getFiscalias',
            'lang' => $_COOKIE['idIdioma'],
        ];
        $opciones = array(
            "http" => array(
                "header" => "Content-type: application/x-www-form-urlencoded\r\n",
                "method" => "POST",
                "content" => http_build_query($datos), # Agregar el contenido definido antes
            ),
        );
        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($url, false, $contexto);
        if ($resultado === false) {
            echo "Error haciendo petición";
            exit;
        }
        $result = json_decode($resultado);

        return $result;
    }

    /**
     * generateAccordionFiscalias
     * [Genera las etiquetas html usando valores de getFiscalias ]
     * @return string
     */
    static function generateAccordionFiscalias()
    {
        $data = HtmlElements::getFiscalias();

        $html_acordeon = '';

        $html = '<p class="title-div">' . mb_strtoupper($data->Titulo) . '</p>';

        for ($i = 0; $i <= count($data->Datos); $i++) {
            $id = '"collapse' . $i . '"';
            $id2 = '"#collapse' . $i . '"';
            $idRediect = $idRediect + 1;
            $url = "";
            $html .= '<div class="accordion-item"> <h2 class="accordion-header">';
            if ($i == 0) {
                $html .= '<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target=' . $id2 . ' aria-expanded="true" aria-controls=' . $id . '>';
            } else {
                $html .= '<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target=' . $id2 . ' aria-expanded="false" aria-controls=' . $id . '>';
            }

            $acordeon_titulo = $data->Datos[$i]->descripcion;
            $acordeon_direccion = 'Domicilio: ' . $data->Datos[$i]->direccion;
            $acordeon_telefono = 'Teléfono(s): ' . $data->Datos[$i]->telefono;
            $acordeon_ver = "Ver mapa";

            $html .= $acordeon_titulo;
            $acordeon_titulo = "";
            $html .= '</button></h2>';
            if ($i == 0) {
                $html .= '<div id=' . $id . 'class="accordion-collapse collapse show" data-bs-parent=#accordion1>';
            } else {
                $html .= '<div id=' . $id . 'class="accordion-collapse collapse" data-bs-parent=#accordion1>';
            }
            $html .= '<div class="accordion-body text-div">';
            $html .= $acordeon_direccion;
            $acordeon_direccion = '';
            $html .= '<br>';
            $html .= $acordeon_telefono;
            $acordeon_telefono = '';
            $url .= '"/directorios/fiscalias/' . $idRediect . '"';
            $html .= '<br><a href=' . $url . 'class="over-div-enlaces">';
            $html .= $acordeon_ver;
            $acordeon_ver = '';
            $html .= '</a></div>';
            $html .= '</div></div>';

        }

        $html_acordeon .= $html;

        return $html_acordeon;
    }

    /**
     * generateTokenSedetur
     * [Genera un token del WS de SEDETUR ]
     * @return string
     */
    static function generateTokenSedetur()
    {

        if (!isset($_COOKIE['tokenSedetur'])) {

            /* Servicio para obtener token  */
            $url = "https://sedeturqroo.gob.mx/auth/tk_create.php";
            $datos = [
                'email' => 'rinaes048@gmail.com',
                'password' => '0DNA1el5RliV',
            ];
            $opciones = array(
                "http" => array(
                    "header" => "Content-type: application/x-www-form-urlencoded\r\n",
                    "method" => "POST",
                    "content" => http_build_query($datos), # Agregar el contenido definido antes
                ),
            );
            $contexto = stream_context_create($opciones);
            $resultado = file_get_contents($url, false, $contexto);
            if ($resultado === false) {
                echo "Error haciendo petición";
                exit;
            }

            $result = json_decode($resultado);

            if ($result->codigo == 1) {
                $token = $result->token;
                $_COOKIE['tokenSedetur'] = $token;

            } else {
                $token = null;
            }
        } else {
            $token = $_COOKIE['tokenSedetur'];
        }

        return $token;
    }

    /**
     * validateTokenSedetur
     * [Valida si el token obtenido por SEDETUR es valido ]
     * @return string
     */
    static function validateTokenSedetur()
    {

        $token = $_COOKIE['tokenSedetur'];

        if (!isset($_COOKIE["tokenSedetur"])) {

            /* Servicio para obtener las nacionalidades  */
            $url = HtmlElements::apiUrlSedetur;
            $datos = [
                'token' => $token,
                'webservice' => 'getNacionalidades',
                'lang' => $_COOKIE['idIdioma'],
            ];
            $opciones = array(
                "http" => array(
                    "header" => "Content-type: application/x-www-form-urlencoded\r\n",
                    "method" => "POST",
                    "content" => http_build_query($datos), # Agregar el contenido definido antes
                ),
            );
            $contexto = stream_context_create($opciones);
            $resultado = file_get_contents($url, false, $contexto);
            if ($resultado === false) {
                echo "Error haciendo petición";
                exit;
            }

            $result = json_decode($resultado);

            if ($result->codigo == 0) {
                $_COOKIE['tokenSedetur'] = HtmlElements::generateTokenSedetur();

            } else {
                $token = null;
            }
        }

        return $token;
    }

    /**
     * getPrestadoresServicios
     * [Obtiene las prestadores de servicio del WS de SEDETUR]
     * @return string
     */
    static function getPrestadoresServicios()
    {
//        HtmlElements::validateTokenSedetur();

        /* Servicio para obtener prestadores de servicio  */
        $url = HtmlElements::apiUrlSedetur;
        $datos = [
            'token' => $_COOKIE['tokenSedetur'],
            'webservice' => 'getPstsInscritos2',
            'lang' => $_COOKIE['idIdioma'],
        ];
        $opciones = array(
            "http" => array(
                "header" => "Content-type: application/x-www-form-urlencoded\r\n",
                "method" => "POST",
                "content" => http_build_query($datos), # Agregar el contenido definido antes
            ),
        );
        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($url, false, $contexto);
        if ($resultado === false) {
            echo "Error haciendo petición";
            exit;
        }
        $result = json_decode($resultado);

        $data = $result->Datos[0]->prestadores_servicios_turisticos;

        return $data;
    }

    /**
     * generateOptionsPrestadoresServicios
     * [Genera las etiquetas html usando valores de getPrestadoresServicios ]
     * @return string
     */
    static function generateOptionsPrestadoresServicios()
    {
        $html = '';

        $data = HtmlElements::getPrestadoresServicios();

        for ($i = 0; $i < count($data); $i++) {
            $html .= '<option value="' . $data[$i]->id . '">' . $data[$i]->nombre_comercial . '</option>';
        }

        return $html;
    }

    /**
     * getMotivosQueja
     * [Obtiene las pmotivos de queja del WS de SEDETUR]
     * @return string
     */
    static function getMotivosQueja()
    {
        HtmlElements::validateTokenSedetur();

        /* Servicio para obtener prestadores de servicio  */
        $url = HtmlElements::apiUrlSedetur;
        $datos = [
            'token' => $_COOKIE['tokenSedetur'],
            'webservice' => 'getMotivosQueja',
            'lang' => $_COOKIE['idIdioma'],
        ];
        $opciones = array(
            "http" => array(
                "header" => "Content-type: application/x-www-form-urlencoded\r\n",
                "method" => "POST",
                "content" => http_build_query($datos), # Agregar el contenido definido antes
            ),
        );
        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($url, false, $contexto);
        if ($resultado === false) {
            echo "Error haciendo petición";
            exit;
        }
        $result = json_decode($resultado);

        $data = $result->Datos;

        return $data;
    }

    /**
     * generateOptionsMotivos
     * [Genera las etiquetas html usando valores de getMotivosQueja ]
     * @return string
     */
    static function generateOptionsMotivos()
    {
        $html = '';

        $data = HtmlElements::getMotivosQueja();

        for ($i = 0; $i < count($data); $i++) {
            $html .= '<option value="' . $data[$i]->motivo_id . '">' . $data[$i]->descripcion . '</option>';
        }

        return $html;
    }

    /**
     * getConsulados
     * [Obtiene las consulados del WS de SEDETUR]
     * @return string
     */
    static function getConsulados()
    {
//        HtmlElements::validateTokenSedetur();

        /* Servicio para obtener prestadores de servicio  */
        $url = HtmlElements::apiUrlSedetur;
        $datos = [
            'token' => $_COOKIE['tokenSedetur'],
            'webservice' => 'getConsulados',
            'lang' => $_COOKIE['idIdioma'],
        ];
        $opciones = array(
            "http" => array(
                "header" => "Content-type: application/x-www-form-urlencoded\r\n",
                "method" => "POST",
                "content" => http_build_query($datos), # Agregar el contenido definido antes
            ),
        );
        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($url, false, $contexto);
        if ($resultado === false) {
            echo "Error haciendo petición";
            exit;
        }
        $result = json_decode($resultado);

        return $result;
    }

    /**
     * generateOptionsConsulados
     * [Genera las etiquetas html usando valores de getConsulados ]
     * @return string
     */
    static function generateOptionsConsulados()
    {
        $data = HtmlElements::getConsulados();


        $html = '<p class="title-div">' . mb_strtoupper($data->Titulo) . '</p>';

        $html .= '<div class="container">';
        $html .= '<div class="row mt-4 mb-4 d-flex justify-content-center">';

        foreach ($data->Datos as $i => $c) {
            $html .= '   <div class="col col-md-4 col-sm-12 d-flex align-items-center justify-content-center my-3">
            <div class="card shadow-sm border-0" style="width: 18rem;"><a
                    href="consulados-y-embajadas/' . $c->id . '"><img
                    src="' . $c->bandera . '"class="card-img-top" style="height: 180px; object-fit: cover;"
                    alt="..."></a>
                <div class="card-body text-center"><a href="consulados-y-embajadas/' . $c->id . '">' . mb_strtoupper($c->pais) . '</a></div>
            </div>
        </div>';
        }

        $html .= '</div>';
        $html .= '</div>';

        return $html;

    }

    /**
     * getSexo
     * [Obtiene los sexos del WS de SEDETUR]
     * @return string
     */
    static function getSexo()
    {
        HtmlElements::validateTokenSedetur();

        /* Servicio para obtener prestadores de servicio  */
        $url = HtmlElements::apiUrlSedetur;
        $datos = [
            'token' => $_COOKIE['tokenSedetur'],
            'webservice' => 'getSexos',
            'lang' => $_COOKIE['idIdioma'],
        ];
        $opciones = array(
            "http" => array(
                "header" => "Content-type: application/x-www-form-urlencoded\r\n",
                "method" => "POST",
                "content" => http_build_query($datos), # Agregar el contenido definido antes
            ),
        );
        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($url, false, $contexto);
        if ($resultado === false) {
            echo "Error haciendo petición";
            exit;
        }
        $result = json_decode($resultado);

        $data = $result->Datos;

        return $data;
    }

    /**
     * generateOptionsSexo
     * [Genera las etiquetas html usando valores de getSexo ]
     * @return string
     */
    static function generateOptionsSexo()
    {
        $html = '';

        $data = HtmlElements::getSexo();

        for ($i = 0; $i < count($data); $i++) {
            $html .= '<option value="' . $data[$i]->valor . '">' . $data[$i]->descrip . '</option>';
        }

        return $html;
    }

    /**
     * getConsuladoById
     * [Obtiene los datos de un consulado del WS de SEDETUR por medio de su ID]
     * @return string
     */
    static function getConsuladoById($id)
    {
//        HtmlElements::validateTokenSedetur();

        /* Servicio para obtener prestadores de servicio  */
        $url = HtmlElements::apiUrlSedetur;
        $datos = [
            'token' => $_COOKIE['tokenSedetur'],
            'webservice' => 'getConsuladosInd',
            'lang' => $_COOKIE['idIdioma'],
            'consulado_id' => $id,
        ];
        $opciones = array(
            "http" => array(
                "header" => "Content-type: application/x-www-form-urlencoded\r\n",
                "method" => "POST",
                "content" => http_build_query($datos), # Agregar el contenido definido antes
            ),
        );
        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($url, false, $contexto);
        if ($resultado === false) {
            echo "Error haciendo petición";
            exit;
        }
        $result = json_decode($resultado);

        return $result;
    }

    /**
     * generateOptionsConsuladoById
     * [Genera las etiquetas html usando valores de getConsuladoById ]
     * @return string
     */
    static function generateOptionsConsuladoById($id)
    {
        $data = HtmlElements::getConsuladoById($id);

        $consulado = $data->Etiquetas[0];


        $html = '<div class="d-flex align-items-center">';
        $html .= '<img src="' . $data->Datos[0]->bandera . '" class="icon-consulado">';
        $html .= '<div class="title-div">' . mb_strtoupper($data->Datos[0]->pais) . '</div> </div>';

        $mark = null;

        if (str_contains($_SERVER['REQUEST_URI'], 'consulados-y-embajadas')) {
            $html .= '<p class="subtitle-div">
                    <br>
                    ' . $consulado . '
                </p>';
        }

        $html .= '<p class="text-div">';
        $mapa = null;
        foreach ($data->Datos as $obj) {
            foreach ($obj as $key => $value) {
                switch ($key) {
                    case 'Jurisdicción':
                        $mapa .= '<strong>' . $data->Etiquetas[1].': '. '</strong>' . $value . '<br>';
                        break;
                    case 'direccion':
                        $mapa .= '<strong>' . $data->Etiquetas[2].': '. '</strong>' . $value . '<br>';
                        break;
                    case 'horario':
                        $mapa .= '<strong>' . $data->Etiquetas[3].': '. '</strong>' . $value . '<br>';
                        break;
                    case 'correo1':
                        $mapa .= '<strong>' . $data->Etiquetas[4].': '. '</strong> <a href="mailto:' . $value . '" class="over-div-enlaces">' . $value . '</a><br>';
                    case 'Website':
                        if ($value)
                            $mapa .= '<strong>' . $data->Etiquetas[5].': '. '</strong> <a href="' . $value . '" target="_blank" class="over-div-enlaces">' . $value . '</a><br>';
                        break;
                    case 'telefono1':
                        if ($value)
                            $mapa .= '<strong>' . $data->Etiquetas[6].': '. '</strong> <a href="' . $value . '" target="_blank" class="over-div-enlaces">' . $value . '</a><br>';
                        break;
                    case 'telefono_emergencia1':
                        if ($value)
                            $mapa .= '<strong>' . $data->Etiquetas[7].': '. '</strong> <a href="' . $value . '" target="_blank" class="over-div-enlaces">' . $value . '</a><br>';
                        break;
                    default:
//                        if ($key)
//                            $mapa .= '<strong>' . $key . '</strong>' . $value . '<br>';
                        break;
                }
//                if (@$vv['latitud']) {
//                    $coords = ',' . @$vv['latitud'] . ',' . @$vv['longitud'];
//                }
            }

            $coords = ',' . $obj->latitud . ',' .$obj->longitud;
            $mark .= '[' . '\'' . $mapa . '\'' . $coords . '],';
        }
//        $mark .= '[' . '\'' . $mapa . '\'' . @$coords . '],';
        $html .= $mapa . '</p>';
        $html .= BodyMap::generaMapa($mark);

        return $html;

    }

    /**
     * getFiscaliaById
     * [Obtiene los datos de una fiscalia del WS de SEDETUR por medio de su ID]
     * @return string
     */
    static function getFiscaliaById($id)
    {
        HtmlElements::validateTokenSedetur();

        /* Servicio para obtener prestadores de servicio  */
        $url = HtmlElements::apiUrlSedetur;
        $datos = [
            'token' => $_COOKIE['tokenSedetur'],
            'webservice' => 'getFiscaliasind',
            'lang' => $_COOKIE['idIdioma'],
            'fiscalia_id' => $id,
        ];
        $opciones = array(
            "http" => array(
                "header" => "Content-type: application/x-www-form-urlencoded\r\n",
                "method" => "POST",
                "content" => http_build_query($datos), # Agregar el contenido definido antes
            ),
        );
        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($url, false, $contexto);
        if ($resultado === false) {
            echo "Error haciendo petición";
            exit;
        }
        $result = json_decode($resultado);

        $data = $result->Datos;

        return $data;
    }

    /**
     * generateOptionsFiscaliaById
     * [Genera las etiquetas html usando valores de getFiscaliaById ]
     * @return string
     */
    static function generateOptionsFiscaliaById($id)
    {
        $data = HtmlElements::getFiscaliaById($id);


        $html = '<div class="d-flex align-items-center">';
        $html .= '<div class="title-div">' . mb_strtoupper($data[0]->descripcion) . '</div> </div>';


        $mark = null;

        if (str_contains($_SERVER['REQUEST_URI'], 'consulados-y-embajadas')) {
            $html .= '<p class="subtitle-div">
                    <br>
                    ' . '' . '
                </p>';
        }
        $html .= '<p class="text-div">';
        $mapa = null;
        foreach ($data as $obj) {
            foreach ($obj as $key => $value) {
                switch ($key) {
                    case 'direccion':
                        $mapa .= '<strong>' . 'Direccion: ' . '</strong>' . $value . '<br>';
                        $coords123 = '<strong>' . 'Direccion: ' . '</strong>' . $value . '<br>';
                        break;
                    case 'telefono':
                        if ($value)
                            $mapa .= '<strong>' . 'Teléfono(s): ' . '</strong> <a href="' . $value . '" target="_blank" class="over-div-enlaces">' . $value . '</a><br>';
                        break;
                }
            }

            $coords = ',' . $obj->coord_y . ',' .$obj->coord_x;
            $mark .= '[' . '\'' . $mapa . '\'' . $coords . '],';

            $html .= $mapa . '</p>';
        }

        $html .= BodyMap::generaMapa($mark);

        return $html;

    }

    /**
     * getHospitalById
     * [Obtiene los datos de un hospital del WS de SEDETUR por medio de su ID]
     * @return string
     */
    static function getHospitalById($id)
    {
        HtmlElements::validateTokenSedetur();

        /* Servicio para obtener prestadores de servicio  */
        $url = HtmlElements::apiUrlSedetur;
        $datos = [
            'token' => $_COOKIE['tokenSedetur'],
            'webservice' => 'getHospitalesind',
            'lang' => $_COOKIE['idIdioma'],
            'hospitale_id' => $id,
        ];
        $opciones = array(
            "http" => array(
                "header" => "Content-type: application/x-www-form-urlencoded\r\n",
                "method" => "POST",
                "content" => http_build_query($datos), # Agregar el contenido definido antes
            ),
        );
        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($url, false, $contexto);
        if ($resultado === false) {
            echo "Error haciendo petición";
            exit;
        }
        $result = json_decode($resultado);

        $data = $result->Datos;

        return $data;
    }

    /**
     * generateOptionsHospitalById
     * [Genera las etiquetas html usando valores de getHospitalById ]
     * @return string
     */
    static function generateOptionsHospitalById($id)
    {
        $data = HtmlElements::getHospitalById($id);


        $html = '<div class="d-flex align-items-center">';
        $html .= '<div class="title-div">' . mb_strtoupper($data[0]->descripcion) . '</div> </div>';


        $mark = null;

        if (str_contains($_SERVER['REQUEST_URI'], 'consulados-y-embajadas')) {
            $html .= '<p class="subtitle-div">
                    <br>
                    ' . '' . '
                </p>';
        }
        $html .= '<p class="text-div">';
        $mapa = null;
        foreach ($data as $obj) {
            foreach ($obj as $key => $value) {
                switch ($key) {
                    case 'direccion':
                        $mapa .= '<strong>' . 'Direccion: ' . '</strong>' . $value . '<br>';
                        $coords123 = '<strong>' . 'Direccion: ' . '</strong>' . $value . '<br>';
                        break;
                    case 'telefono':
                        if ($value)
                            $mapa .= '<strong>' . 'Teléfono(s): ' . '</strong> <a href="' . $value . '" target="_blank" class="over-div-enlaces">' . $value . '</a><br>';
                        break;
                }
            }

            $coords = ',' . $obj->coord_y . ',' .$obj->coord_x;
            $mark .= '[' . '\'' . $mapa . '\'' . $coords . '],';

            $html .= $mapa . '</p>';
        }

        $html .= BodyMap::generaMapa($mark);

        return $html;

    }

    /**
     * generateOptionsPresentadaProfeco
     * [Genera las etiquetas html usando valores de getDestinos ]
     * @return string
     */
    static function generateOptionsPresentadaProfeco()
    {
        $html = '';

        $presentadaProfeco = HtmlElements::getPresentadaProfeco();

        for ($i = 0; $i < count($presentadaProfeco); $i++) {
            $html .= '<option value="' . $presentadaProfeco[$i]->valor . '">' . $presentadaProfeco[$i]->descrip . '</option>';
        }

        return $html;

    }

    /**
     * getPresentadaProfeco
     * [Obtiene las opciones presentadas a profeco del WS de SEDETUR]
     * @return string
     */
    static function getPresentadaProfeco()
    {
        HtmlElements::validateTokenSedetur();

        /* Servicio para obtener los destinos  */
        $url = HtmlElements::apiUrlSedetur;
        $datos = [
            'token' => $_COOKIE['tokenSedetur'],
            'webservice' => 'getPresentadaPROFECO',
            'lang' => $_COOKIE['idIdioma'],
        ];
        $opciones = array(
            "http" => array(
                "header" => "Content-type: application/x-www-form-urlencoded\r\n",
                "method" => "POST",
                "content" => http_build_query($datos), # Agregar el contenido definido antes
            ),
        );
        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($url, false, $contexto);
        if ($resultado === false) {
            echo "Error haciendo petición";
            exit;
        }
        $result = json_decode($resultado);

        $data = $result->Datos;

        return $data;
    }

    /**
     * getCatalogoPresentadaProfeco
     * [Obtiene la información de los prestadores de servicio del WS de SEDETUR]
     * @return string
     */
    static function getCatalogoPresentadaProfeco()
    {
        HtmlElements::validateTokenSedetur();

        /* Servicio para obtener los destinos  */
        $url = HtmlElements::apiUrlSedetur;
        $datos = [
            'token' => $_COOKIE['tokenSedetur'],
            'webservice' => 'getPstsInscritos3'
        ];
        $opciones = array(
            "http" => array(
                "header" => "Content-type: application/x-www-form-urlencoded\r\n",
                "method" => "POST",
                "content" => http_build_query($datos), # Agregar el contenido definido antes
            ),
        );
        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($url, false, $contexto);
        if ($resultado === false) {
            echo "Error haciendo petición";
            exit;
        }
        $result = json_decode($resultado);

        $data = $result->Datos[0]->prestadores_servicios_turisticos;

        return $data;
    }

    /**
     * generateOptionsGirosComerciales
     * [Genera las etiquetas html usando valores de getGirosComerciales ]
     * @return string
     */
    static function generateOptionsGirosComerciales()
    {
        $html = '';

        $giros = HtmlElements::getGirosComerciales();

        for ($i = 0; $i < count($giros); $i++) {
            $html .= '<option value="' . $giros[$i]->id . '">' . $giros[$i]->name . '</option>';
        }

        return $html;

    }

    /**
     * validateTokenSedetur
     * [Obtiene los giros comerciales del WS de SEDETUR]
     * @return string
     */
    static function getGirosComerciales()
    {
        HtmlElements::validateTokenSedetur();

        /* Servicio para obtener los destinos  */
        $url = HtmlElements::apiUrlSedetur;
        $datos = [
            'token' => $_COOKIE['tokenSedetur'],
            'webservice' => 'getGirosComerciales',
//            'lang' => $_COOKIE['idIdioma'],
        ];
        $opciones = array(
            "http" => array(
                "header" => "Content-type: application/x-www-form-urlencoded\r\n",
                "method" => "POST",
                "content" => http_build_query($datos), # Agregar el contenido definido antes
            ),
        );
        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($url, false, $contexto);
        if ($resultado === false) {
            echo "Error haciendo petición";
            exit;
        }
        $result = json_decode($resultado);

        $data = $result->Datos[0]->giros_comerciales;

        return $data;
    }

    /**
     * getArrendadoras
     * [Obtiene las arrendadoras del WS de SEDETUR]
     * @return string
     */
    static function getArrendadoras()
    {
//        HtmlElements::validateTokenSedetur();

        /* Servicio para obtener arrendadoras de vehiculos  */
        $url = HtmlElements::apiUrlSedetur;
        $datos = [
            'token' => $_COOKIE['tokenSedetur'],
            'webservice' => 'getArrendadorasVehiculos',
//            'lang' => $_COOKIE['idIdioma'],
        ];
        $opciones = array(
            "http" => array(
                "header" => "Content-type: application/x-www-form-urlencoded\r\n",
                "method" => "POST",
                "content" => http_build_query($datos), # Agregar el contenido definido antes
            ),
        );
        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($url, false, $contexto);
        if ($resultado === false) {
            echo "Error haciendo petición";
            exit;
        }
        $result = json_decode($resultado);

        $arrendadoras = $result->Datos;

        return $arrendadoras;
    }

    /**
     * generateOptionsArrendadoras
     * [Genera las etiquetas html usando valores de getArrendadoras ]
     * @return string
     */
    static function generateOptionsArrendadoras()
    {
        $html = '';

        $arrendadoras = HtmlElements::getArrendadoras();

        for ($i = 0; $i < count($arrendadoras); $i++) {
            $html .= '<option value="' . $arrendadoras[$i]->id . '">' . $arrendadoras[$i]->nombre_comercial . '</option>';
        }

        return $html;
    }
}