<?php
namespace Application\Library\Authentication;

/**
 * It manages all session data.
 * @author workstation2
 */
class Session
{
    
    /**
     * It cleans a session.
     */
    static function clean()
    {
        setcookie('accessToken', '', time()-1000, '/');
        setcookie('refreshToken', '', time()-1000, '/');
        setcookie('sessionToken', '', time()-1000, '/');
        session_unset();
        session_destroy();
        session_write_close();
        setcookie(session_name(), '', 0, '/');
    }
    
    /**
     * Verifies if a user loged in before.
     * @return boolean
     */
    static function logedIn()
    {
        return (!empty($_COOKIE['accessToken']) && !empty($_COOKIE['refreshToken']) && !empty($_COOKIE['sessionToken']));
    }
}