<?php
namespace Application\Library\Authentication;

/**
 * It manages actions for menu.
 * @author workstation2
 */
class Menu
{
    /**
     * Max levels to generate menu.
     * @var integer
     */
    const MAX_LEVELS = 3;
    
    /**
     * Set of privileges.
     * @var array
     */
    private $privileges;
    
    /**
     * Stores the menu structure.
     * @var array
     */
    private $menu;
    
    /**
     * Children privileges.
     * @var array
     */
    private $children;

    /**
     * Constructor.
     * @param array $privileges
     */
    public function __construct($privileges = null)
    {
        $this->privileges = $privileges;
        $this->menu = !empty($_SESSION['menu']) ? $_SESSION['menu'] : [];
        $this->children = [];
    }
    
    /**
     * Generates the menu structure and assign the result to the menu session variable.
     * @return array
     */
    public function generate()
    {
        $_SESSION['privileges'] = [];
        $_SESSION['menu'] = $this->setChildren($this->menu, null, 1);
    }
    
    /**
     * Recursively build the menu structure and fills the privileges data.
     * @param array $children
     * @param mixed $parent
     * @param int $level
     * @return array
     */
    private function setChildren(&$children, $parent, $level)
    {
        // if max level reched so stop searching children.
        if($level > self::MAX_LEVELS) {
            return [];
        }
        // For every privilege it searches for any possible child.
        foreach($this->privileges as $p) {
            if($p['frmParentMenu'] === $parent) {
                $children[$p['frmIdMenu']] = $p;
                $_SESSION['privileges'][] = $p['frmUrlMenu'];
                $children[$p['frmIdMenu']]['frmChildrenMenu'] =  $this->setChildren($children[$p['frmIdMenu']]['frmChildrenMenu'], $p['frmIdMenu'], $level+1);
            }
        }
        return $children;
    }

    public function getChildrenByUrl($url)
    {
        $this->children($url, $this->menu, 1);
        return $this->children;
    }
    
    private function children($url, $children, $level)
    {
        if(empty($children)) {
            return;
        }
        foreach($children as $c) {
            if(!empty($this->children)) {
                break;
            }
            if($c['frmUrlMenu'] == $url) {
                $this->children = $c['frmChildrenMenu'];
                break;
            }
            $this->children($url, $c['frmChildrenMenu'], $level + 1);
        }
    }
    
    // Detects if user has access to a URL.
    public static function userHasAccess($url)
    {
        return in_array($url, $_SESSION['privileges']);
    }
}