<?php
namespace Application\Library\Authentication;

use Laminas\Authentication\Adapter\AdapterInterface;
use Laminas\Authentication\Result;

class AuthenticationAdapter implements AdapterInterface
{

    /** @var string */
    private $username;
    
    /** @var string */
    private $password;
    
    /**
     * Constructor.
     * @param string $username
     * @param string $password
     */
    public function __construct($username, $password)
    {
        $this->username = $username;
        $this->password = $password;
    }
    
    /**
     * Authenticate to the user.
     * {@inheritDoc}
     * @see \Laminas\Authentication\Adapter\AdapterInterface::authenticate()
     */
    public function authenticate()
    {
        return new Result($code, $identity);
    }
}