/*! vue-barcode v2.0.1 | (c) 2018-present Chen Fengyuan | MIT */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('vue'), require('jsbarcode')) :
  typeof define === 'function' && define.amd ? define(['vue', 'jsbarcode'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.VueBarcode = factory(global.Vue, global.JsBarcode));
})(this, (function (vue, JsBarcode) { 'use strict';

  var index = vue.defineComponent({
      name: 'VueBarcode',
      props: {
          /**
           * The value of the bar code.
           */
          value: {
              type: String,
              default: undefined,
          },
          /**
           * The options for the bar code generator.
           * {@link https://github.com/lindell/JsBarcode#options}
           */
          options: {
              type: Object,
              default: undefined,
          },
          /**
           * The tag name of the component's root element.
           */
          tag: {
              type: String,
              default: 'canvas',
          },
      },
      watch: {
          $props: {
              deep: true,
              immediate: true,
              /**
               * Update the bar code when props changed.
               */
              handler() {
                  if (this.$el) {
                      this.generate();
                  }
              },
          },
      },
      mounted() {
          this.generate();
      },
      methods: {
          /**
           * Generate bar code.
           */
          generate() {
              JsBarcode(this.$el, String(this.value), this.options);
          },
      },
      render() {
          return vue.h(this.tag, this.$slots.default);
      },
  });

  return index;

}));
