import {ref} from 'vue';

/**
 * Contiene funciones y propiedades de un objeto request.
 */
export function useRequest(config) {
	
	// Se define un objeto form.
	let request = ref({
		// Enfoca el campo con el primer error encontrado (no modificar).
		post: function(url, data = {}) {
			return fetch(url, {
            	method: 'POST',
            	headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(data)
            }).then(response => {
                return response.json();
            });
		}
	});
	
	// Se devuelve el objeto.
	return request;
	
}