import {ref} from 'vue';

/**
 * Contiene funciones y propiedades de un objeto multipaso.
 */
export function useMultistep(config) {

	// Se define un objeto datatable que contiene las configuraciones
	let multistep = ref({
		// Método del formulario.
		formMethod: null,
		// Pasos del formulario.
		steps: [],
		// Paso en el que se encuentra actualmente el usuario.
		currentStep: 1,
		// Indica el paso siguiente que se va a completar a continuación.
	    nextStep: 1,
    	// Indica si se ha actualizado algún dato del formulario.
    	updated: false,
    	// Indica si se muestra o no el modal para confirmación de salida del formulario multipaso.
    	visibleDialogExit: false,
    	// Controla si se muestra el mensaje de solicitar guardar cambios.
    	visibleDialogSave: false,
    	// Texto del botón salir.
    	btnExit: 'Salir',
    	// Texto del botón atrás.
    	btnBack: 'Atrás',
    	// Texto del botón siguiente.
    	btnNext: 'Siguiente',
    	// Texto del botón eliminar.
    	btnDelete: 'Eliminar',
    	// Texto del botón regresar.
    	btnReturn: 'Regresar',
    	// URL a donde sale del formulario.
    	urlBack: '../',
    	// Asigna el paso en el que se haya quedado.
		resume(step = 1) {
    		this.nextStep = parseInt(step) > 1 ? parseInt(step) : 1; 
			this.currentStep = this.nextStep > 1 && this.nextStep <= this.steps.length ? this.nextStep : 1;
			this.updated = false;
			this.btnNext = 'Siguiente';
		},
		// Indica que los datos del formulario se actualizaron.
		update() {
			if(this.nextStep > 1 && this.currentStep < this.nextStep) {
				this.updated = true;
				this.btnNext = 'Guardar';
			} else if(this.nextStep >= this.steps.length && this.currentStep == this.steps.length) {
				this.btnNext = 'Finalizar';
			} else {
				this.btnNext = 'Siguiente';
			}
		},
		// Valida si el formulario ha sido modificado.
		isUpdated() {
			if(this.updated == true)
				this.visibleDialogSave = true;
			return this.updated;
		},
    	// Determina si una pestaña está activa.
		setActive(stepIndex) {
			if(this.isUpdated()) return;
    		this.currentStep = stepIndex+1 <= this.nextStep ? stepIndex+1 : this.currentStep;
    		if(this.currentStep == this.steps.length) {
				this.btnNext = 'Finalizar';
			} else {
				this.btnNext = 'Siguiente';
			}
		},
		// Determina si una pestaña está activa.
		isActive(stepIndex) {
			return (stepIndex+1) == this.currentStep;
		},
		// Determina si una pestaña está deshabilitada.
		isDisabled(stepIndex) { 
			return (stepIndex+1) > this.nextStep;
		},
		// Regresa a la pestaña anterior.
		previousTab() { 
			if(this.currentStep == 1) return;
			if(this.isUpdated()) return;
			if(this.steps[this.currentStep-2]['visible'] === false) return;
			this.currentStep -= 1;
			this.btnNext = 'Siguiente';
		},
		// Accede a la siguiente pestaña. Se indica si se acaba de guardar algo del formulario, para pasarlo a estatus no actualizado.
		nextTab(saved = false) { 
			if(saved) {
				this.updated = false;
				this.btnNext = 'Siguiente';
			}
			if(this.currentStep == this.steps.length) return;
			if(this.isUpdated()) return;
			this.currentStep += 1;
			if(this.currentStep == this.steps.length) {
				this.btnNext = 'Finalizar';
			}
			if(this.currentStep > this.nextStep) {
				this.nextStep = this.currentStep;
			}
		},
		// Identifica si se puede hacer envío de datos del formulario.
		allowSubmit() {
			return (this.updated || this.currentStep == this.nextStep || this.currentStep == this.steps.length || this.formMethod == 'DELETE');
		}
	});
	
	// Se devuelve el objeto.
	return multistep;
	
}
