import {ref} from 'vue';

/**
 * It allows to manage and formate dates an times.
 */
export function useDatetime() {
	
	//Datetime object is defined.
	let datetime = ref({
		// Format a date thar comes in sql format (yyyy-mm-dd) or (yyyy-mm-dd hh:mm:ss)
        format: function(date) {
            // If no date received.
            if(date == undefined || date == null) { return ''; }
            // When it is a date time.
            let d = date;
            let h = '';
            if(date.length == 19) {
                let parts = date.split(' ');
                d = parts[0];
                h = parts[1].substring(0, 5);
            }
            // It gets date parts.
            const [year, month, day] = [...d.split('-')];
            // Format and return.
            return (new Intl.DateTimeFormat('es-MX', {
                year: "numeric",
                month: "2-digit",
                day: "2-digit"
            }).format(new Date(year, month-1, day)) + ' ' + h).trim();
        },
        // Returns a datetime snapshot in format yyyymmddhhmmss.
        snapshot: function() {
        	let d = new Date();
        	let year = d.getFullYear();
        	let month = (d.getMonth()+1).toString().padStart(2, '0');
        	let day = d.getDate().toString().padStart(2, '0');
        	let hour = d.getHours();
        	let minute = d.getMinutes();
        	let second = d.getSeconds();
        	return year+month+day+hour+minute+second;
        }
	});
	
	// Object is returned.
	return datetime;
	
}