import {ref} from 'vue';
import {useApi} from 'composable/api';
import {useDatetime} from 'composable/datetime';

/**
 * Contiene funciones y propiedades de un objeto de datatable.
 */
export function useBodyMap(config) {
	
	// Se define un objeto datatable que contiene las configuraciones
	let bodymap = ref({
		// API
		api: useApi(),
		// Datetime format.
		datetime: useDatetime(),
		// URL de la que mandará a traer los datos.
		url: config['url'],
		// Obtiene los datos para rellenar el datatable.
		getValue(event) {
			// Tiempo en que se enviará la petición al servidor.
        	let time = 0;
            // Se limpia la petición que hayan quedado en cola.
            if(this.search) { 
                clearTimeout(this.search); 
                this.search = null;
            }
            // Se cargan los datos.
            this.search = setTimeout(() => {
            	// Se hace la llamada para obtener los datos.
    			this.api.request('GET', this.url, null, null).then(response => {
    				this.totalRecords = parseInt(response.totalRecords);
                    this.value = response.data;
                	this.loading = false;
                });
            }, time);
		},
	});
	
	// Se devuelve el objeto.
	return bodymap;
	
}