/**
 * Componente para la generación de las pestañas de un formulario multistep.
 */
export default {
	props: [
		// Composable del multistep que tiene el estado del formulario.
		'multistep'
	],
	template: `
		<div class="row">
    		<div class="col-12">
    			<ul class="multistep nav nav-pills flex-column flex-sm-row nav-justified">
    				<template v-for="(step, stepIndex) in multistep.steps">
    					<li role="presentation" class="nav-item" :class="{active: multistep.isActive(stepIndex)}" @click="multistep.setActive(stepIndex)" v-if="step['visible'] !== false">
	    					<a href="javascript:void(0)" class="nav-link text-center" :class="{disabled: multistep.isDisabled(stepIndex)}"><i :class="step.icon">&nbsp;</i>{{step.name}}</a>
	    				</li>
    				</template>
            	</ul>
    		</div>
    	</div>
	`
}