$(function () {

    $(document).ajaxSend(function () {
        $("#overlay").fadeIn(300);
    });


    $('#LINK_FORMATO_DE_QUEJAS_SEDETUR').on('shown.bs.modal', function () {

        $('#formQuejasSedetur')[0].reset();

        $('#formQuejasSedetur')
            .removeClass('was-validated')
            .find('.is-valid, .is-invalid')
            .removeClass('is-valid is-invalid');

        $('#formQuejasSedetur .invalid-feedback').text('');

        $('#formQuejasSedetur input[type="file"]').val('');
        $('#formQuejasSedetur select').val('').trigger('change');

    });


    $('#formQuejasSedetur').on('submit', function (e) {
        e.preventDefault();

        let form = this;


        const correoInput = $('#correo');
        const correo = correoInput.val().trim();

        correoInput[0].setCustomValidity('');
        correoInput.removeClass('is-valid is-invalid');
        correoInput.next('.invalid-feedback').text('');

        if (!correo) {
            // correoInput[0].setCustomValidity('Este campo es obligatorio.');
            correoInput.addClass('is-invalid');
            // correoInput.next('.invalid-feedback').text('Este campo es obligatorio.');
        } else if (!validarCorreo(correo)) {
            correoInput[0].setCustomValidity('Correo no válido');
            correoInput.addClass('is-invalid');
            correoInput.next('.invalid-feedback').text('Correo no válido');
        } else {
            correoInput.addClass('is-valid');
        }


        const phone = $('#telefono');
        const valor = phone.val().replace(/\D/g, '');

        phone[0].setCustomValidity('');
        phone.removeClass('is-valid is-invalid');
        phone.next('.invalid-feedback').text('');

        if (!valor) {
            // phone[0].setCustomValidity('Este campo es obligatorio.');
            phone.addClass('is-invalid');
            // phone.next('.invalid-feedback').text('Este campo es obligatorio.');
        } else if (valor.length < 7 || valor.length > 15) {
            phone[0].setCustomValidity('Debe contener entre 7 y 15 dígitos');
            phone.addClass('is-invalid');
            phone.next('.invalid-feedback').text('Debe contener entre 7 y 15 dígitos');
        } else {
            phone.addClass('is-valid');
        }


        const tiposPermitidos = ['application/pdf', 'image/jpeg'];
        const maxSize = 2 * 1024 * 1024; // 2 MB
        let formularioValido = true;

        $('.archivo-input').each(function () {
            const input = this;
            const archivo = input.files[0];

            input.setCustomValidity('');
            $(input).removeClass('is-valid is-invalid');
            $(input).next('.invalid-feedback').text('');

            if (archivo) {
                if (!tiposPermitidos.includes(archivo.type)) {
                    input.setCustomValidity('Solo se permiten archivos PDF o JPG');
                    $(input).addClass('is-invalid');
                    $(input).next('.invalid-feedback').text('Solo se permiten archivos PDF o JPG');
                    formularioValido = false;
                } else if (archivo.size > maxSize) {
                    input.setCustomValidity('El archivo debe pesar menos de 2 MB');
                    $(input).addClass('is-invalid');
                    $(input).next('.invalid-feedback').text('El archivo debe pesar menos de 2 MB');
                    formularioValido = false;
                } else {
                    $(input).addClass('is-valid');
                }
            }
        });

        HabilitaCampos();

        if (form.checkValidity() && formularioValido) {
            const formData = new FormData(form);

            $.ajax({
                type: 'POST',
                url: '/servicios/form-quejas-prestadores',
                data: formData,
                processData: false,
                contentType: false,
                success: function (response) {
                    if (response.success === true) {
                        toastr.success(response.message);

                        $('#formQuejasSedetur')[0].reset();

                        $('#formQuejasSedetur')
                            .removeClass('was-validated')
                            .find('.is-valid, .is-invalid')
                            .removeClass('is-valid is-invalid');

                        $('#formQuejasSedetur .invalid-feedback').text('');

                        $('#formQuejasSedetur input[type="file"]').val('');
                        $('#formQuejasSedetur select').val('').trigger('change');


                        $('#LINK_FORMATO_DE_QUEJAS_SEDETUR').modal('hide');
                    } else {
                        toastr.warning(response.message);
                    }
                },
                error: function () {
                    toastr.error('Ocurrió un error, contacte al área de servicio o intente más tarde.');
                },
                complete: function () {
                    // Oculta el overlay después de completar la petición
                    setTimeout(function () {
                        $("#overlay").fadeOut(300);
                    }, 500);
                }
            });

        } else {
            $(form).addClass('was-validated');
        }
    });

});

function validarCorreo(correo) {
    const regex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    return regex.test(correo);
}


