<?php
namespace Security\Controller;

use Laminas\Mvc\Controller\AbstractActionController;
use Laminas\View\Model\ViewModel;
use Application\Controller\MainController;
use Laminas\ServiceManager\ServiceManager;
use Laminas\Http\Request;

/**
 * It handles the actions for managing users data.
 * @author workstation2
 */
class UsersController extends MainController
{
    
    /**
     * Constructor.
     * @param ServiceManager $sm
     */
    public function __construct(ServiceManager $sm)
    {
        parent::__construct($sm);
        $this->module = $this->translator->translate('Seguridad');
        $this->controller = $this->translator->translate('Usuarios');
    }
    
    /**
     * Datatable view.
     * {@inheritDoc}
     * @see \Laminas\Mvc\Controller\AbstractActionController::indexAction()
     */
    public function indexAction()
    {
        return new ViewModel();
    }
    
    /**
     * Create view.
     * @return \Laminas\View\Model\ViewModel
     */
    public function createAction()
    {
        return new ViewModel();
    }
    
    /**
     * Edit view.
     * @return \Laminas\View\Model\ViewModel
     */
    public function editAction()
    {
        return new ViewModel();
    }
    
    /**
     * Details view.
     * @return \Laminas\View\Model\ViewModel
     */
    public function detailsAction()
    {
        return new ViewModel();
    }
    
    /**
     * Delete view.
     * @return \Laminas\View\Model\ViewModel
     */
    public function deleteAction()
    {
        return new ViewModel();
    }
    
    /**
     * Password view.
     * @return \Laminas\View\Model\ViewModel
     */
    public function passwordAction()
    {
        return new ViewModel([
            'view' => $this->translator->translate('Contraseña'),
            'method' => Request::METHOD_PATCH
        ]);
    }
    
    /**
     * Sections view.
     * @return \Laminas\View\Model\ViewModel
     */
    public function sectionsAction()
    {
        return new ViewModel([
            'view' => $this->translator->translate('Secciones'),
            'method' => Request::METHOD_PUT
        ]);
    }
}