<?php
namespace Security;

use Laminas\Router\Http\Segment;
use Laminas\Mvc\Controller\LazyControllerAbstractFactory;

return [
    'router' => [
        'routes' => [
            'log' => [
                'type'    => Segment::class,
                'options' => [
                    'route'    => '/security/log[/:action]',
                    'defaults' => [
                        'controller' => Controller\LogController::class,
                        'action'     => 'index',
                    ],
                ],
            ],
            'profiles' => [
                'type'    => Segment::class,
                'options' => [
                    'route'    => '/security/profiles[/:action][/:id]',
                    'defaults' => [
                        'controller' => Controller\ProfilesController::class,
                        'action'     => 'index',
                    ],
                ],
            ],
            'users' => [
                'type'    => Segment::class,
                'options' => [
                    'route'    => '/security/users[/:action][/:id]',
                    'defaults' => [
                        'controller' => Controller\UsersController::class,
                        'action'     => 'index',
                    ],
                ],
            ],
        ],
    ],
    'controllers' => [
        'factories' => [
            Controller\ProfilesController::class => LazyControllerAbstractFactory::class,
            Controller\UsersController::class => LazyControllerAbstractFactory::class,
            Controller\LogController::class => LazyControllerAbstractFactory::class
        ]
    ],
    'view_manager' => [
        'template_map' => [
            'security/partial/profiles/datatable'=> __DIR__ . '/../view/partial/profiles/datatable.phtml',
            'security/partial/profiles/form'=> __DIR__ . '/../view/partial/profiles/form.phtml',
            'security/partial/users/datatable'=> __DIR__ . '/../view/partial/users/datatable.phtml',
            'security/partial/users/form'=> __DIR__ . '/../view/partial/users/form.phtml',
            'security/partial/users/sections'=> __DIR__ . '/../view/partial/users/sections.phtml',
        ],
        'template_path_stack' => [
            __DIR__ . '/../view'
        ]
    ]
];