<?php
namespace Reports\Controller;

use Laminas\Mvc\Controller\AbstractActionController;
use Laminas\View\Model\ViewModel;
use Application\Controller\MainController;
use Laminas\ServiceManager\ServiceManager;
use Application\Library\Api\Api;
use Application\Library\Complements\MyLogger;
use Laminas\Http\Request;
use Laminas\Http\Headers;

/**
 * It handles the actions for committee reports.
 * @author workstation2
 */
class TraceabilityController extends MainController
{
    
    /**
     * Constructor.
     * @param ServiceManager $sm
     */
    public function __construct(ServiceManager $sm)
    {
        parent::__construct($sm);
        $this->module = $this->translator->translate('Reportes');
        $this->controller = $this->translator->translate('Trazabilidad Formularios');
    }
    
    /**
     * Datatable view.
     * {@inheritDoc}
     * @see \Laminas\Mvc\Controller\AbstractActionController::indexAction()
     */
    public function indexAction()
    {
        return new ViewModel();
    }

    /**
     * Committee report.
     * @return \Laminas\Stdlib\ResponseInterface
     */
    public function reportAction()
    {
        $request = $this->getRequest();
        $fechaInicial = $request->getPost('frmFechaInicial');
        $fechaFinal = $request->getPost('frmFechaFinal');
        return new ViewModel([
            'view' => $this->translator->translate('Reporte'),
            'fechaInicial' => $fechaInicial,
            'fechaFinal' => $fechaFinal
        ]);
    }
    
}
