<?php
namespace Reports;

use Laminas\Router\Http\Segment;
use Laminas\Mvc\Controller\LazyControllerAbstractFactory;

return [
    'router' => [
        'routes' => [
            'reportCommittees' => [
                'type'    => Segment::class,
                'options' => [
                    'route'    => '/reports/committees[/:action][/:id]',
                    'defaults' => [
                        'controller' => Controller\CommitteesController::class,
                        'action'     => 'index',
                    ],
                ],
            ],
            'reportTraceability' => [
                'type'    => Segment::class,
                'options' => [
                    'route'    => '/reports/traceability[/:action][/:id]',
                    'defaults' => [
                        'controller' => Controller\TraceabilityController::class,
                        'action'     => 'index',
                    ],
                ],
            ]
        ],
    ],
    'controllers' => [
        'factories' => [
            Controller\CommitteesController::class => LazyControllerAbstractFactory::class,
            Controller\TraceabilityController::class => LazyControllerAbstractFactory::class
        ]
    ],
    'view_manager' => [
        'template_map' => [
            'reports/partial/committees/form'=> __DIR__ . '/../view/partial/committees/form.phtml',
            'reports/partial/traceability/form'=> __DIR__ . '/../view/partial/traceability/form.phtml',
            'reports/partial/traceability/datatable'=> __DIR__ . '/../view/partial/traceability/datatable.phtml',
        ],
        'template_path_stack' => [
            __DIR__ . '/../view'
        ]
    ]
];