<?php

namespace General\Controller;

use Application\Library\Complements\HtmlElements;
use Application\Library\postRelacionados\SectionServicios;
use GuzzleHttp\Client;
use Laminas\View\Model\ViewModel;
use Application\Controller\MainController;
use Application\Library\Api\Api;
use Application\Library\Complements\BodyMap;
use Application\Library\Complements\MyLogger;
use Laminas\Http\Request;
use Laminas\ServiceManager\ServiceManager;

use function PHPUnit\Framework\returnSelf;

/**
 * It handles the actions for managing users data.
 * @author workstation2
 */
class ServiciosController extends MainController
{

    /**
     * Constructor.
     * @param ServiceManager $sm
     */
    public function __construct(ServiceManager $sm)
    {
        parent::__construct($sm);
        $this->module = $this->translator->translate('Publico');
        $this->controller = $this->translator->translate('General');
    }

    /**
     * Datatable view.
     * {@inheritDoc}
     * @see \Laminas\Mvc\Controller\AbstractActionController::indexAction()
     */
    public function roboExtravioAction()
    {
        $params = [
            'where' => 'frmIdIdioma eq ' . $_COOKIE['idIdioma']
        ];
        $fetch = Api::request('/robo-extravio-pasaporte', Request::METHOD_GET, $params);
        $json = json_decode($fetch->getBody(), true);
        $data = $json['data'][0];


        // $retorno = BodyMap::procesaJson($data['frmContenidoExtraviosPasaporte'], $data['frmBasePath']);
        $content = $data["frmContenidoExtraviosPasaporte"];
        $links = $content["links"];
        $mainTitle = mb_strtoupper($content["subMenu"]);
        $contentTitle = $content["contenido"][0]["titulo"];
        $parrafo1Pt1 = $content["contenido"][0]["subtitulo"][0]["parrafoUnion"][0]["valor"]; // tipo bold
        $parrafo1Pt2 = $content["contenido"][0]["subtitulo"][0]["parrafoUnion"][1]["valor"]; // tipo texto
        $parrafo2Pt1 = $content["contenido"][0]["subtitulo"][1]["parrafoUnion"][0]["valor"]; // tipo bold
        $parrafo2Pt2 = $content["contenido"][0]["subtitulo"][1]["parrafoUnion"][1]; // tipo mixto
        $parrafo2Pt2 = BodyMap::generaLink($parrafo2Pt2, $links);

        $basePath = $data["frmBasePath"];

        $modalsList = [];
        // Creación de modales de paises
        foreach ($content["paises"] as $countryIdx => $country) {
            $countryName = $country["nombre"];
            $modalTitle = $country["titulo"];
            $countryFlag = $basePath . $country["bandera"];
            $modalId = preg_replace('/\s+/', '', $country['nombre']);

            $modalContentTitle = $country["modal"][0]["titulo"];
            $accordionList = [];
            $acordeon = $country["modal"][1]["acordeon"]; // contenido del acordeon
            foreach ($acordeon as $acordeonIdx => $accordionItem) {
                $accordionTitle = $accordionItem["titulo"];
                $accordionContent = [];
                foreach ($accordionItem['subtitulo'] as $sub) {
                    // Si hay algún listado dentro de este subtitulo
                    if ($sub["listado"] && is_iterable($sub["listado"])) {
                        array_push($accordionContent, HtmlElements::getListadoHtml($sub["listado"], $basePath, $links));
                    } else if ($sub["parrafoUnion"] && is_iterable($sub["parrafoUnion"])) {
                        array_push($accordionContent, HtmlElements::getParrafoUnionHtml($sub["parrafoUnion"], $links));

                    } else if ($sub["tipo"]) {
                        switch ($sub["tipo"]) {
                            case "texto":
                                array_push($accordionContent, $sub["valor"]);
                                break;
                            case "mixto":
                                $salida = BodyMap::generaLink($sub, $links);
                                array_push($accordionContent, $salida);
                                break;
                            case "bold":
                                array_push($accordionContent, '<b>' . $sub['valor'] . '</b>');
                                break;
                            case "tabla":
                                $html = "";
                                $html .= '<table class="table table-bordered my-table">';
                                foreach ($sub['valor']['columna1'] as $kc => $vc) {
                                    if ($vc['tipo'] == 'encabezado') {
                                        $html .= '<tr>';
                                        $html .= '<th>' . $vc['texto'] . '</th>';
                                        $html .= '<th colspan="2">' . $sub['valor']['columna2'][$kc]['texto'] . '</th>';
                                        $html .= '</tr>';
                                    }
                                    if ($vc['tipo'] == 'texto') {
                                        $html .= "<tr>";
                                        $html .= '<td>' . $vc['texto'] . '</td>';
                                        $html .= '<td colspan="2">' . $sub['valor']['columna2'][$kc]['texto'] . '</td>';
                                        $html .= "</tr>";
                                    }
                                }
                                $html .= '</table>';
                                array_push($accordionContent, $html);
                                break;

                        }
                    }

                }

                array_push($accordionList, [
                    "title" => $accordionTitle,
                    "content" => $accordionContent,
                ]);
            }
            $textBtn = HtmlElements::generateTextCancelar();

            array_push($modalsList, [
                "countryName" => $countryName,
                "modalTitle" => $modalTitle,
                "countryFlag" => $countryFlag,
                "modalId" => $modalId,
                "modalContentTitle" => $modalContentTitle,
                "modalAccordion" => $accordionList,
                "textBtn" => $textBtn
            ]);
        }

        $sections = SectionServicios::generatePostRelacionados(300);


        $viewModel = new ViewModel();
        $viewModel->setVariables([
            'data' => $data["frmContenidoExtraviosPasaporte"],
            'basePath' => $data["frmBasePath"],
            "mainTitle" => $mainTitle,
            "contentTitle" => $contentTitle,
            "parrafo1Pt1" => $parrafo1Pt1,
            "parrafo1Pt2" => $parrafo1Pt2,
            "parrafo2Pt1" => $parrafo2Pt1,
            "parrafo2Pt2" => $parrafo2Pt2,
            "modalList" => $modalsList,
            "sections" => $sections
        ]);
        return $viewModel;
    }

    public function quejasPrestadoresAction()
    {

        HtmlElements::validateTokenSedetur();

        $request = $this->getRequest();
        if ($request->getPost('Nombre')) {
            $formData = [
                'frmNombreTuristaTrazabilidad' => $request->getPost('Nombre'),
                'frmCorreoElectronicoTrazabilidad' => $request->getPost('Correo'),
                'frmFormularioTrazabilidad' => 'Quejas SEDETUR',
                'frmEstatusTrazabilidad' => '200: envio exitoso'
            ];
            $postLocal = Api::request('/reporte-trazabilidad', Request::METHOD_POST, $formData);
        }
        $params = [
            'where' => 'frmIdIdioma eq ' . $_COOKIE['idIdioma']
        ];
        $fetch = Api::request('/quejas-contra-prestadores', Request::METHOD_GET, $params);
        $json = json_decode($fetch->getBody(), true);
        $data = $json['data'][0];

        $retorno = BodyMap::procesaJson($data['frmContenidoQuejasPrestadores']);

        $fetch = Api::request('/quejas-form', Request::METHOD_GET, $params);
        $json = json_decode($fetch->getBody(), true);
        $formularioQuejas = $json['data'];

//        $fetch = Api::request('/generos', Request::METHOD_GET, $params);
//        $json = json_decode($fetch->getBody(), true);
//        $genero = $json['data'];

        $genero = HtmlElements::generateOptionsSexo();

        $sections = SectionServicios::generatePostRelacionados(300);

        $nacionalidades = HtmlElements::generateOptionsNacionalidades();

        $prestadoresServicios = HtmlElements::generateOptionsPrestadoresServicios();

        $motivosQueja = HtmlElements::generateOptionsMotivos();

        $destinos = HtmlElements::generateOptionsDestinos();

        $quejaPresentada = HtmlElements::generateOptionsPresentadaProfeco();

        $viewModel = new ViewModel();
        $viewModel->setVariables([
            'content' => $retorno,
            'nacionalidades' => $nacionalidades,
            'form' => $formularioQuejas,
            'prestadoresServicios' => $prestadoresServicios,
            'motivosQueja' => $motivosQueja,
            "sections" => $sections,
            "destinos" => $destinos,
            "genero" => $genero,
            "quejaPresentada" => $quejaPresentada
        ]);
        return $viewModel;
    }

    public function quejasFraudeCiberneticoAction()
    {
        $request = $this->getRequest();
        if ($request->getPost('Nombre')) {
            $formData = [
                'frmNombreTuristaTrazabilidad' => $request->getPost('Nombre'),
                'frmCorreoElectronicoTrazabilidad' => $request->getPost('Correo'),
                'frmFormularioTrazabilidad' => 'Quejas SEDETUR',
                'frmEstatusTrazabilidad' => '200: envio exitoso'
            ];
            $postLocal = Api::request('/reporte-trazabilidad', Request::METHOD_POST, $formData);
        }
        $params = [
            'where' => 'frmIdIdioma eq ' . $_COOKIE['idIdioma']
        ];
        $fetch = Api::request('/quejas-fraude-cibernetico', Request::METHOD_GET, $params);
        $json = json_decode($fetch->getBody(), true);
        $data = $json['data'][0];

        $retorno = BodyMap::procesaJson($data['frmContenidoQuejasFraudeCibernetico'], $data['frmBasePath']);

        $fetch = Api::request('/nacionalidades', Request::METHOD_GET, $params);
        $json = json_decode($fetch->getBody(), true);
        $nacionalidades = $json['data'];

        $fetch = Api::request('/quejas-form', Request::METHOD_GET, []);
        $json = json_decode($fetch->getBody(), true);
        $formularioQuejas = $json['data'];

        $fetch = Api::request('/prestadores-servicios', Request::METHOD_GET, []);
        $json = json_decode($fetch->getBody(), true);
        $prestadoresServicios = $json['data'];

        $fetch = Api::request('/motivos-queja', Request::METHOD_GET, []);
        $json = json_decode($fetch->getBody(), true);
        $motivosQueja = $json['data'];

        $links = $data['frmContenidoQuejasFraudeCibernetico']['links'];

        /* Titulo 1 */

        $titulo1 = mb_strtoupper($data['frmContenidoQuejasFraudeCibernetico']['subMenu']);

        /* Contenido 1 */
        $contain1_text1 = $data['frmContenidoQuejasFraudeCibernetico']['contenido'][0]['subtitulo'][0]['valor'];
        $contain1_text2 = $data['frmContenidoQuejasFraudeCibernetico']['contenido'][0]['subtitulo'][1]['valor'];


        /* subtitulo 1 */
        $subtitulo1 = mb_strtoupper($data['frmContenidoQuejasFraudeCibernetico']['contenido'][1]['titulo']);

        /* Contenido 2 */
        $contain2_list = HtmlElements::generateListasSimples($data['frmContenidoQuejasFraudeCibernetico']['contenido'][1]['subtitulo']);
        $contain2_text2 = HtmlElements::generateContenidoConLinks($data['frmContenidoQuejasFraudeCibernetico']['contenido'][1]['subtitulo'][1]['valor'], $links);
        $contain2_text3 = HtmlElements::generateContenidoConLinks($data['frmContenidoQuejasFraudeCibernetico']['contenido'][1]['subtitulo'][2]['valor'], $links);

        /* subtitulo 2 */
        $subtitulo2 = mb_strtoupper($data['frmContenidoQuejasFraudeCibernetico']['contenido'][2]['titulo']);

        /* Contenido 3 */
        $contain3_text1 = BodyMap::generaLink($data['frmContenidoQuejasFraudeCibernetico']['contenido'][2]['subtitulo'][0], $links);

        /* subtitulo 3 */
        $subtitulo3 = mb_strtoupper($data['frmContenidoQuejasFraudeCibernetico']['contenido'][3]['titulo']);

        /* Contenido 4 */
        $contain4_text1 = $data['frmContenidoQuejasFraudeCibernetico']['contenido'][3]['subtitulo'][0]['valor'];
        $contain4_list1 = HtmlElements::generateListasSinSubarrays($data['frmContenidoQuejasFraudeCibernetico']['contenido'][3]['subtitulo'][1]['listado'], $links);

        /* subtitulo 4 */
        $subtitulo4 = mb_strtoupper($data['frmContenidoQuejasFraudeCibernetico']['contenido'][4]['titulo']);

        /* Contenido 5 */
        $contain5_list1 = HtmlElements::generateListadoConcat2Texts($data['frmContenidoQuejasFraudeCibernetico']['contenido'][4]['subtitulo'][0]['listado']);

//        dd($data['frmContenidoQuejasFraudeCibernetico']['contenido'][3]['subtitulo'][1]['listado']);

        $sections = SectionServicios::generatePostRelacionados(300);

        $viewModel = new ViewModel();
        $viewModel->setVariables([
            'nacionalidades' => $nacionalidades,
            'form' => $formularioQuejas,
            'prestadoresServicios' => $prestadoresServicios,
            'motivosQueja' => $motivosQueja,
            'tittle' => $titulo1,
            'contain1_text1' => $contain1_text1,
            'contain1_text2' => $contain1_text2,
            'subtitulo1' => $subtitulo1,
            'contain2_list' => $contain2_list,
            'contain2_text2' => $contain2_text2,
            'contain2_text3' => $contain2_text3,
            'subtitulo2' => $subtitulo2,
            'contain3_text1' => $contain3_text1,
            'subtitulo3' => $subtitulo3,
            'contain4_text1' => $contain4_text1,
            'contain4_list1' => $contain4_list1,
            'subtitulo4' => $subtitulo4,
            'contain5_list1' => $contain5_list1,
            "sections" => $sections


        ]);
        return $viewModel;
    }

    public function reporteRoboAction()
    {
        $fetch = Api::request('/reporte-robo', Request::METHOD_GET);
        $json = json_decode($fetch->getBody(), true);
        foreach ($json['data'] as $i => $v) {
            if ($v['frmIdIdioma'] == $_COOKIE['idIdioma']) {
                $data = $v;
            }
            if (!$_COOKIE['idIdioma']) {
                $data = $v;
                continue;
            }
        }


        /* Titulo */
        $titulo = mb_strtoupper($data['frmContenidoReportesRobo']['subMenu']);

        /* Primer contenido */
        $Contain1_text1 = $data['frmContenidoReportesRobo']['contenido'][0]['subtitulo'][0]['valor'];
        $Contain1_text2 = $data['frmContenidoReportesRobo']['contenido'][0]['subtitulo'][1]['valor'];

        /*Acordeon*/
        $catalogo = $data['frmContenidoReportesRobo']['contenido'][0]['subtitulo'][2]['valor'];
        $html_acordeon = HtmlElements::generateAccordion($catalogo, "accordionExample");

        /* Subtitulo */
        $subtitulo = mb_strtoupper($data['frmContenidoReportesRobo']['contenido'][1]['titulo']);

        /* Segundo contenido */
        $Contain2_text1 = $data['frmContenidoReportesRobo']['contenido'][1]['subtitulo'][0]['valor'];
        $Contain2_text2 = $data['frmContenidoReportesRobo']['contenido'][1]['subtitulo'][1]['valor'];
        $Contain2_text3 = $data['frmContenidoReportesRobo']['contenido'][1]['subtitulo'][2]['valor'];

        $sections = SectionServicios::generatePostRelacionados(300);


        $viewModel = new ViewModel();
        $viewModel->setVariables([
            'tittle' => $titulo,
            'Contain1_text1' => $Contain1_text1,
            'Contain1_text2' => $Contain1_text2,
            'acordeon' => $html_acordeon,
            'subtitulo' => $subtitulo,
            'Contain2_text1' => $Contain2_text1,
            'Contain2_text2' => $Contain2_text2,
            'Contain2_text3' => $Contain2_text3,
            "sections" => $sections

        ]);

        return $viewModel;
    }

    public function tarjetaClonadaAction()
    {
        $params = [
            'where' => 'frmIdIdioma eq ' . $_COOKIE['idIdioma']
        ];
        $fetch = Api::request('/tarjeta-credito-clonada', Request::METHOD_GET, $params);
        $json = json_decode($fetch->getBody(), true);
        $data = $json['data'][0];

        // $retorno = BodyMap::procesaJson($data['frmContenidoTarjetaCreditoClonada'], $data['frmBasePath']);

        $content = $data["frmContenidoTarjetaCreditoClonada"];
        $links = $content["links"];
        $basePath = $data["frmBasePath"];

        $mainTitle = mb_strtoupper($content["subMenu"]);

        // Contenido

        $contentPartsList = [];

        foreach ($content["contenido"] as $contentPart) {
            $title = mb_strtoupper($contentPart["titulo"]);
            $contentSubparts = [];
            foreach ($contentPart["subtitulo"] as $sub) {
                // Si hay algún listado dentro de este subtitulo
                if ($sub["listado"] && is_iterable($sub["listado"])) {
                    $tmp = [
                        "type" => "listado",
                        "value" => HtmlElements::getListadoHtml($sub["listado"], $basePath, $links),
                    ];

                    array_push($contentSubparts, $tmp);
                } else if ($sub["parrafoUnion"] && is_iterable($sub["parrafoUnion"])) {
                    $tmp = [
                        "type" => "parrafoUnion",
                        "value" => HtmlElements::getParrafoUnionHtml($sub["parrafoUnion"], $links),
                    ];
                    array_push($contentSubparts, $tmp);

                } else if ($sub["tipo"]) {
                    switch ($sub["tipo"]) {
                        case "texto":
                            $tmp = [
                                "type" => "texto",
                                "value" => $sub["valor"],
                            ];
                            array_push($contentSubparts, $tmp);
                            break;
                        case "mixto":
                            $tmp = [
                                "type" => "mixto",
                                "value" => BodyMap::generaLink($sub, $links)
                            ];
                            array_push($contentSubparts, $tmp);
                            break;
                        case "bold":
                            $tmp = [
                                "type" => "bold",
                                "value" => '<b>' . $sub['valor'] . '</b>',
                            ];
                            array_push($contentSubparts, $tmp);
                            break;
                        case "tabla":
                            $html = "";
                            $html .= '<table class="table table-bordered my-table">';
                            foreach ($sub['valor']['columna1'] as $kc => $vc) {
                                if ($vc['tipo'] == 'encabezado') {
                                    $html .= '<tr>';
                                    $html .= '<th>' . $vc['texto'] . '</th>';
                                    $html .= '<th colspan="2">' . $sub['valor']['columna2'][$kc]['texto'] . '</th>';
                                    $html .= '</tr>';
                                }
                                if ($vc['tipo'] == 'texto') {
                                    $html .= "<tr>";
                                    $html .= '<td>' . $vc['texto'] . '</td>';
                                    $html .= '<td colspan="2">' . $sub['valor']['columna2'][$kc]['texto'] . '</td>';
                                    $html .= "</tr>";
                                }
                            }
                            $html .= '</table>';
                            $tmp = [
                                "type" => "table",
                                "value" => $html,
                            ];
                            array_push($contentSubparts, $tmp);
                            break;
                    }
                }
            }
            array_push($contentPartsList, [
                "partTitle" => $title,
                "partSubcontent" => $contentSubparts,
            ]);
        }


        $sections = SectionServicios::generatePostRelacionados(300);

        $viewModel = new ViewModel();
        $viewModel->setVariables([
            "mainTitle" => $mainTitle,
            "content" => $contentPartsList,
            "sections" => $sections
        ]);
        return $viewModel;
    }

    public function asesoriaLegalAction()
    {
        HtmlElements::validateTokenSedetur();

        $request = $this->getRequest();
        if ($request->getPost('Nombre')) {
            $formData = [
                'frmNombreTuristaTrazabilidad' => $request->getPost('Nombre'),
                'frmCorreoElectronicoTrazabilidad' => $request->getPost('Correo'),
                'frmFormularioTrazabilidad' => 'Asesoria legal',
                'frmEstatusTrazabilidad' => '200: envio exitoso'
            ];
            $postLocal = Api::request('/reporte-trazabilidad', Request::METHOD_POST, $formData);
        }
        $params = [
            'where' => 'frmIdIdioma eq ' . $_COOKIE['idIdioma']
        ];
        $fetch = Api::request('/asesoria-legal', Request::METHOD_GET, $params);
        $json = json_decode($fetch->getBody(), true);
        $data = $json['data'][0];

        $form = $data['frmContenidoAsesoriaLegal']['contenido'][0]['subtitulo'][2]['valor'];

        $retorno = BodyMap::procesaJson($data['frmContenidoAsesoriaLegal']);

//        $fetch = Api::request('/nacionalidades', Request::METHOD_GET, $params);
//        $json = json_decode($fetch->getBody(), true);
//        $nacionalidades = $json['data'];

        $sections = SectionServicios::generatePostRelacionados(300);

//        $fetch = Api::request('/generos', Request::METHOD_GET, $params);
//        $json = json_decode($fetch->getBody(), true);
//        $genero = $json['data'];
//
//        if (empty($nacionalidades)) {
//
//            $params = [
//                'where' => 'frmIdIdioma eq ' . '1'
//            ];
//
//            $fetch = Api::request('/nacionalidades', Request::METHOD_GET, $params);
//            $json = json_decode($fetch->getBody(), true);
//            $nacionalidades = $json['data'];
//
//        }


//        $params = [
//            'where' => 'frmIdIdioma eq ' . '1'
//        ];
//
//        $fetch = Api::request('/destinos-turisticos', Request::METHOD_GET, $params);
//        $json = json_decode($fetch->getBody(), true);
//        $destinos = $json['data'];
//
//        $destionosOptions = HtmlElements::createDestinos($destinos);

        $genero = HtmlElements::generateOptionsSexo();

        $nacionalidades = HtmlElements::generateOptionsNacionalidades();

        $destinos = HtmlElements::generateOptionsDestinos();

        if ($this->getRequest()->isPost()) {

            // Acceder directamente a los datos del formulario usando el objeto Request
            $newPost = $this->getRequest()->getPost();

            // Llamada al método que procesa el formulario
            $bandera = $this->sendFormAsesoriaLegal($newPost);

            // Guardar un mensaje en la sesión
            $this->flashMessenger()->addMessage(

                [
                    'bandera' => $bandera['bandera'],  // Código de bandera
                    'msj' => $bandera['msj'],  // Mensaje
                    'errors' => $bandera['errors']  // Errores, o cualquier dato adicional
                ]

            );

            // Redirigir a la acción 'asesoriaLegal' en la ruta 'servicios'
            return $this->redirect()->toRoute('servicios', ['action' => 'asesoriaLegal']);
        }

        $messages = $this->flashMessenger()->getMessages();

        $bandera = null;
        $msj = null;
        $errors = null;

        foreach ($messages as $message) {
            if (isset($message['bandera'])) {
                $bandera = $message['bandera'];
            }
            if (isset($message['msj'])) {
                $msj = $message['msj'];
            }
            if (isset($message['errors'])) {
                $errors = $message['errors'];
            }
        }

        $bandera = [
            'bandera' => $bandera,
            'msj' => $msj,
            'errors' => $errors,
        ];

        $viewModel = new ViewModel();
        $viewModel->setVariables([
            'content' => $retorno,
            'nacionalidades' => $nacionalidades,
            "sections" => $sections,
            "form" => $form,
            "genero" => $genero,
            "destinos" => $destinos,
            "bandera" => $bandera

        ]);
        return $viewModel;
    }

    public function informacionMedicaAction()
    {
        $fetch = Api::request('/asistencia-medica', Request::METHOD_GET);
        $json = json_decode($fetch->getBody(), true);
        foreach ($json['data'] as $i => $v) {
            if ($v['frmIdIdioma'] == $_COOKIE['idIdioma']) {
                $data = $v;
            }
            if (!$_COOKIE['idIdioma']) {
                $data = $v;
                continue;
            }
        }

        // $retorno = BodyMap::procesaJson($data['frmContenidoAsistenciaMedica']);


        $content = $data["frmContenidoAsistenciaMedica"];
        $links = $content["links"];
        $basePath = $data["frmBasePath"];

        $mainTitle = mb_strtoupper($content["subMenu"]);

        // Contenido
        $listado = $content["contenido"][0]["subtitulo"][0]["listado"];

        $text1 = $listado[0]["valor"];
        $text2 = $listado[1]["valor"];
        $text3 = $listado[2]["valor"];
        $text4 = $listado[3]["valor"];
        $text5 = $listado[4]["valor"];

        $accordion1 = HtmlElements::generateAccordion2($content["contenido"][0]["subtitulo"][1]["valor"], "accordion1");

        $sections = SectionServicios::generatePostRelacionados(300);

        $hospitales = HtmlElements::generateAccordionHospitales();

        $viewModel = new ViewModel();
        $viewModel->setVariables([
            "mainTitle" => $mainTitle,
            "text1" => $text1,
            "text2" => $text2,
            "text3" => $text3,
            "text4" => $text4,
            "text5" => $text5,
            "hospitales" => $hospitales,
            "sections" => $sections
        ]);
        return $viewModel;
    }

    public function sendFormAsesoriaLegal($data)
    {
        $finalDara = [];
        $finalDara['bandera'] = 0;


        if (count($data) == 0) {
            $finalDara = [];
            $finalDara['bandera'] = 0;
        } else {

            /* Servicio para mandar el formulario de asesoria legal */
            HtmlElements::validateTokenSedetur();

            $data['webservice'] = 'storeAsesoriaLegal';
            $data['origen'] = '1'; /* 1 sitio web, 5 applicación móvil */
            $data['token'] = $_COOKIE['tokenSedetur'];

            /* Servicio para mandar el formulario de quejas */

            $url = HtmlElements::apiUrlSedetur;
            $opciones = array(
                "http" => array(
                    "header" => "Content-type: application/x-www-form-urlencoded\r\n",
                    "method" => "POST",
                    "content" => http_build_query($data->toArray()), # Agregar el contenido definido antes
                ),
            );
            $contexto = stream_context_create($opciones);
            $resultado = file_get_contents($url, false, $contexto);
            if ($resultado === false) {
                echo $contexto;
                exit;
            }

            $result = json_decode($resultado);

            if (array_key_exists('Datos', $result)) {
                if (array_key_exists('bandera', $result->Datos[0])) {
                    if ($result->Datos[0]->bandera == 1) {
                        $finalDara['bandera'] = 1;
                        $finalDara['msj'] = 'Mensaje guardada exitosamente';
                        $finalDara['errors'] = null;
                    } else {

                        $finalDara['bandera'] = 2;

                        $errores = $result->Datos[1] ?? [];

                        if (!empty($errores)) {
                            $finalDara['msj'] = 'Mensaje no guardada, Verifique los datos requeridos.';
                            $finalDara['errors'] = $result->Datos[1];
                        } else {
                            $finalDara['msj'] = 'Mensaje no guardada, hay errores en formato de datos';
                            $finalDara['errors'] = null;
                        }
                    }
                } else {
                    $finalDara['bandera'] = 3;
                    $finalDara['msj'] = 'Verifique los datos requeridos';
                    $finalDara['errors'] = $result->Datos[0];
                }
            } else {
                $finalDara['bandera'] = 3;
                $finalDara['msj'] = 'Verifique los datos requeridos';
                $finalDara['errors'] = $result->Datos[0];
            }
        }

        return $finalDara;
    }

    public function paseMovilidadAction()
    {
        HtmlElements::validateTokenSedetur();

        $sections = SectionServicios::generatePostRelacionados(300);

        /** @var \Laminas\Http\PhpEnvironment\Request $request */
        $request = $this->getRequest();

        $utmSource   = $this->params()->fromQuery('utm_source');
        $utmMedium   = $this->params()->fromQuery('utm_medium');
        $utmCampaign = $this->params()->fromQuery('utm_campaign');

        if (!$utmSource || !$utmMedium || !$utmCampaign) {
            $routeUrl = $request->getUri()->getPath();

            $queryParams = http_build_query([
                'utm_source'   => $utmSource   ?: 'avasa',
                'utm_medium'   => $utmMedium   ?: 'email',
                'utm_campaign' => $utmCampaign ?: 'pase_movilidad_avasa',
            ]);

            return $this->redirect()->toUrl($routeUrl . '?' . $queryParams);
        }

        if ($_COOKIE['idIdioma'] == '1') {
            $img = '/img/content/pase-movilidad.jpg';
        } else {
            $img = '/img/content/pase-movilidad-eng.jpg';
        }

        $nacionalidades = HtmlElements::generateOptionsNacionalidades();
        $arrendadora = HtmlElements::generateOptionsArrendadoras();
        $destinos = HtmlElements::generateOptionsDestinos();

        $viewModel = new ViewModel();
        $viewModel->setVariables([
            "img" => $img,
            "sections" => $sections,
            "nacionalidades" => $nacionalidades,
            "arrendadora" => $arrendadora,
            "destinos" => $destinos
        ]);
        return $viewModel;
    }

    public function formQuejasPrestadoresAction()
    {

        try {

            HtmlElements::validateTokenSedetur();

            $url = HtmlElements::apiUrlSedetur;

            $data = $this->getRequest()->getPost();

            $data['webservice'] = 'storeQueja';
            $data['origen'] = '1'; /* 1 sitio web, 5 applicación móvil */
            $data['token'] = $_COOKIE['tokenSedetur'];

            $client = new Client();

            $multipart = [];

            foreach ($data->toArray() as $key => $value) {
                $multipart[] = [
                    'name' => $key,
                    'contents' => $value,
                ];
            }

            foreach (['archivo1', 'archivo2', 'archivo3', 'archivo4'] as $campo) {
                if (isset($_FILES[$campo]) && $_FILES[$campo]['error'] === UPLOAD_ERR_OK) {
                    $multipart[] = [
                        'name' => $campo,
                        'contents' => fopen($_FILES[$campo]['tmp_name'], 'r'),
                        'filename' => $_FILES[$campo]['name'],
                    ];
                }
            }

            $response = $client->request('POST', $url, [
                'multipart' => $multipart,
                'allow_redirects' => true,
                'verify' => false,
            ]);

            $body = $response->getBody()->getContents();

            $result = json_decode($body, true);

            if (array_key_exists('Datos', $result)) {
                if (array_key_exists('bandera', $result['Datos'][0])) {
                    if ($result['Datos'][0]['bandera'] == 1) {

                        $json = [
                            'success' => true,
                            'message' => 'Queja guardada exitosamente',
                            'status' => '202'
                        ];

                    } else {

                        $errores = $result['Datos'][1] ?? [];

                        if (!empty($errores)) {
                            $json = [
                                'success' => false,
                                'message' => 'Queja no guardada, Verifique los datos requeridos.',
                                'status' => '200',
                                'errors' => $errores
                            ];
                        } else {
                            $json = [
                                'success' => false,
                                'message' => 'Queja no guardada, hay errores en formato de datos',
                                'status' => '200',
                                'errors' => null
                            ];
                        }
                    }

                } else {
                    $json = [
                        'success' => false,
                        'message' => 'Verifique los datos requeridos',
                        'status' => '200',
                        'errors' => $result['Datos'][0]
                    ];
                }

            } else {
                $json = [
                    'success' => false,
                    'message' => 'Verifique los datos requeridos',
                    'status' => '200',
                    'errors' => $result['Datos'][0] ?? null
                ];
            }

            header('Content-Type: application/json');

            echo json_encode($json);
            exit;

        } catch (\Throwable $e) {

            header('Content-Type: application/json');

            $json = [
                'success' => false,
                'message' => 'Ocurrio un problema, favor de intentar más tarde o contacte al área de soporte.',
                'status' => $e->getCode(),
                'errors' => null
            ];

            echo json_encode($json);

            exit;
        }
    }

    public function formAsesoriaLegalAction()
    {

        header('Content-Type: application/json');

        $data = $this->getRequest()->getPost();

        $json = [];

        /* Servicio para mandar el formulario de asesoria legal */
        HtmlElements::validateTokenSedetur();

        $data['webservice'] = 'storeAsesoriaLegal';
        $data['origen'] = '1'; /* 1 sitio web, 5 applicación móvil */
        $data['token'] = $_COOKIE['tokenSedetur'];

        /* Servicio para mandar el formulario de quejas */

        $url = HtmlElements::apiUrlSedetur;
        $opciones = array(
            "http" => array(
                "header" => "Content-type: application/x-www-form-urlencoded\r\n",
                "method" => "POST",
                "content" => http_build_query($data->toArray()), # Agregar el contenido definido antes
            ),
        );
        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($url, false, $contexto);
        if ($resultado === false) {
            echo $contexto;
            exit;
        }

        $result = json_decode($resultado);

        if (array_key_exists('Datos', $result)) {
            if (array_key_exists('bandera', $result->Datos[0])) {
                if ($result->Datos[0]->bandera == 1) {

                    $json = [
                        'success' => true,
                        'message' => 'Mensaje guardada exitosamente',
                        'status' => '202'
                    ];

                } else {

                    $errores = $result->Datos[1] ?? [];

                    if (!empty($errores)) {

                        $json = [
                            'success' => false,
                            'message' => 'Mensaje no guardado, Verifique los datos requeridos.',
                            'status' => '200',
                            'errors' => $result->Datos[1]
                        ];
                    } else {
                        $json = [
                            'success' => false,
                            'message' => 'Mensaje no guardado, hay errores en formato de datos',
                            'status' => '200',
                            'errors' => null
                        ];
                    }
                }
            } else {
                $json = [
                    'success' => false,
                    'message' => 'Mensaje no guardado, Verifique los datos requeridos.',
                    'status' => '200',
                    'errors' => $result->Datos[1]
                ];
            }
        } else {
            $json = [
                'success' => false,
                'message' => 'Mensaje no guardado, Verifique los datos requeridos.',
                'status' => '200',
                'errors' => $result->Datos[1]
            ];
        }


        echo json_encode($json);
        exit;

    }

    public function formPaseMovilidadAction()
    {

        /* Servicio para mandar el formulario pase de movilidad */
        HtmlElements::validateTokenSedetur();

        $url = HtmlElements::apiUrlSedetur;

        $data = $this->getRequest()->getPost();
        $data['webservice'] = 'storePaseMovilidadTest';
        $data['origen'] = '1'; /* 1 sitio web, 5 applicación móvil */
        $data['token'] = $_COOKIE['tokenSedetur'];
        $client = new Client();

        $multipart = [];

        foreach ($data->toArray() as $key => $value) {
            $multipart[] = [
                'name' => $key,
                'contents' => $value,
            ];
        }

        foreach (['img_usuario', 'img_licencia', 'img_caratula_contrato', 'imagen_posterior_vehiculo'] as $campo) {
            if (isset($_FILES[$campo]) && $_FILES[$campo]['error'] === UPLOAD_ERR_OK) {
                $multipart[] = [
                    'name' => $campo,
                    'contents' => fopen($_FILES[$campo]['tmp_name'], 'r'),
                    'filename' => $_FILES[$campo]['name'],
                ];
            }
        }

        $response = $client->request('POST', $url, [
            'multipart' => $multipart,
            'allow_redirects' => true,
            'verify' => false,
        ]);

        $body = $response->getBody()->getContents();


        $result = json_decode($body);

        if (array_key_exists('Datos', $result)) {
            if (array_key_exists('bandera', $result->Datos[0])) {
                if ($result->Datos[0]->bandera == 1) {

                    $json = [
                        'success' => true,
                        'message' => 'El pase de movilidad ha sido registrado',
                        'status' => '202',
                        'url' => $result->Datos[0]->url_imagen
                    ];

                } else {

                    $errores = $result->Datos[1] ?? [];

                    if (!empty($errores)) {

                        $json = [
                            'success' => false,
                            'message' => 'Pase de movilidad no guardado, Verifique los datos requeridos.',
                            'status' => '200',
                            'errors' => $result->Datos[1]
                        ];
                    } else {
                        $json = [
                            'success' => false,
                            'message' => 'Pase de movilidad no guardado, hay errores en formato de datos',
                            'status' => '200',
                            'errors' => null
                        ];
                    }
                }
            } else {
                $json = [
                    'success' => false,
                    'message' => 'Pase de movilidad no guardado, Verifique los datos requeridos.',
                    'status' => '200',
                    'errors' => $result->Datos[1]
                ];
            }
        } else {
            $json = [
                'success' => false,
                'message' => 'Pase de movilidad no guardado, Verifique los datos requeridos.',
                'status' => '200',
                'errors' => $result->Datos[1]
            ];
        }

        header('Content-Type: application/json');

        echo json_encode($json);
        exit;

    }

}
