<?php
namespace General\Controller;

use Laminas\View\Model\ViewModel;
use Application\Controller\MainController;
use Application\Library\Api\Api;
use Application\Library\Complements\BodyMap;
use Application\Library\Complements\MyLogger;
use Laminas\Http\Request;
use Laminas\ServiceManager\ServiceManager;
use Application\Library\Complements\HtmlElements;
use Application\Library\Data\InformationTours;
use Application\Library\Data\ProteccionSanitaria;
use Exception;

use function PHPUnit\Framework\returnSelf;

/**
 * It handles the actions for managing users data.
 * @author workstation2
 */
class RecomendacionesController extends MainController
{
    
    /**
     * Constructor.
     * @param ServiceManager $sm
     */
    public function __construct(ServiceManager $sm)
    {
        parent::__construct($sm);
        $this->module = $this->translator->translate('Publico');
        $this->controller = $this->translator->translate('General');
    }

    /**
     * Datatable view.
     * {@inheritDoc}
     * @see \Laminas\Mvc\Controller\AbstractActionController::indexAction()
     */
    public function recomendacionesParaViajarAction()
    {
        $params = [
            'where' => 'frmIdIdioma eq ' . $_COOKIE['idIdioma']
        ];
        $fetch = Api::request('/recomendaciones', Request::METHOD_GET, $params);
        $json = json_decode($fetch->getBody(), true);
        $data = $json['data'][0];

        // $retorno = BodyMap::procesaJson($data['frmContenidoRecomendaciones'], $data['frmBasePath']);

        
        $content = $data["frmContenidoRecomendaciones"];
        $links = $content["links"];
        $basePath = $data["frmBasePath"];

        $mainTitle = $content["subMenu"];
        
        // Contenido

        $text1 = $content["contenido"][0]['subtitulo'][0]['valor'];

        
        $title1 = $content["contenido"][1]['titulo'];
        $listado1 = $content["contenido"][1]["subtitulo"][0]["listado"];
        // $listado1[0]["icono"] = "false";
        $list1 = HtmlElements::getListadoHtml($listado1, $basePath, $links);

        $title2 = $content["contenido"][2]["titulo"];
        $listado2 = $content["contenido"][2]["subtitulo"][0]["listado"];
        // $listado2[0]["icono"] = "false";
        $list2 = HtmlElements::getListadoHtml($listado2, $basePath, $links);

        $title3 = $content["contenido"][3]["titulo"];
        $listado3 = $content["contenido"][3]["subtitulo"][0]["listado"];
        // $listado3["icono"] = "false";
        $list3 = HtmlElements::getListadoHtml($listado3, $basePath, $links);

        $title4 = $content["contenido"][4]["titulo"];
        $listado4 = $content["contenido"][4]["subtitulo"][0]["listado"];
        // $listado4["icono"] = "false";
        $list4 = HtmlElements::getListadoHtml($listado4, $basePath, $links);
        
        $title5 = $content["contenido"][5]["titulo"];
        $listado5 = $content["contenido"][5]["subtitulo"][0]["listado"];
        $list5 = HtmlElements::getListadoHtml($listado5, $basePath, $links);

        $title6 = $content["contenido"][6]["titulo"];
        $listado6 = $content["contenido"][6]["subtitulo"][0]["listado"];
        $list6 = HtmlElements::getListadoHtml($listado6, $basePath, $links);

        $title7 = $content["contenido"][7]["titulo"];
        $listado7 = $content["contenido"][7]["subtitulo"][0]["listado"];
        $list7 = HtmlElements::getListadoHtml($listado7, $basePath, $links);

        $title8 = $content["contenido"][8]["titulo"];
        $listado8 = $content["contenido"][8]["subtitulo"][0]["listado"];
        $list8 = HtmlElements::getListadoHtml($listado8, $basePath, $links);

        /*Post relacionados*/

        $fetch1 = Api::request('/call-center', Request::METHOD_GET, $params);
        $json1 = json_decode($fetch1->getBody(), true);
        $data1 = $json1['data'][0];

        $titulo1 = $data1['frmContenidoCallCenter']['subMenu'];;
        $body1 =  substr($data1['frmContenidoCallCenter']['contenido'][0]['subtitulo'][0]['valor'], 0,120) . "...";


        $fetch2 = Api::request('/informacion-turistica', Request::METHOD_GET, $params);
        $json2 = json_decode($fetch2->getBody(), true);
        $data2 = $json2['data'][0];

        $titulo2 =$data2['frmContenidoAsistenciaVial']['subMenu'];
        $body2 =  substr($data2['frmContenidoAsistenciaVial']['contenido'][0]['subtitulo'][0]['valor'], 0,120) . "...";


        $infoTours = new InformationTours;
        $data = $infoTours->getData($_COOKIE["idIdioma"]); // obtener la lista de
        $content = $data["frmInfo"];

        $titulo3 = mb_strtolower($content["subMenu"]);
        $titulo3 = ucfirst($titulo3);
        $body3 = substr($content["contenido"]["texto1"], 0,120) . "...";

        $textVer = HtmlElements::generaTextVerMas();

        $viewModel = new ViewModel();
        $viewModel->setVariables([
            'mainTitle' => $mainTitle,
            "text1" => $text1,
            "title1" => $title1,
            "list1" => $list1,
            "title2" => $title2,
            "list2" => $list2,
            "title3" => $title3,
            "list3" => $list3,
            "title4" => $title4,
            "list4" => $list4,
            "title5" => $title5,
            "list5" => $list5,
            "title6" => $title6,
            "list6" => $list6,
            "title7" => $title7,
            "list7" => $list7,
            "title8" => $title8,
            "list8" => $list8,
            "titulo1" => $titulo1,
            "body1" => $body1,
            "titulo2" => $titulo2,
            "body2" => $body2,
            "titulo3" => $titulo3,
            "body3" => $body3,
            "textVer" => $textVer,
        ]);
        return $viewModel;
    }

    public function temporadaHuracanesAction()
    {
         $params = [
             'where' => 'frmIdIdioma eq ' . $_COOKIE['idIdioma']
         ];
        // $fetch = Api::request('/recomendaciones', Request::METHOD_GET, $params);
        // $json = json_decode($fetch->getBody(), true);
        // $data = $json['data'][0];

        // $retorno = BodyMap::procesaJson($data['frmContenidoRecomendaciones']);
        $retorno = '<p class="text-center"><img src="/img/en_construccion.jpg" class="img-fluid" ></p>' ;

        $infoHuracanes = new \Application\Library\Data\Huracanes;
        $data = $infoHuracanes->getData($_COOKIE["idIdioma"]);
        $content = $data["frmInfo"];
        $mainTitle = $content["subMenu"];
        $text1 = $content["contenido"]["texto1"];
        $text1 =  str_replace("\n", "<br>", $text1);
        $text1 =  str_replace("/n", "<br>", $text1);
        $text2 = $content["contenido"]["texto2"];
        $text2 =  str_replace("\n", "<br>", $text2);
        $text2 =  str_replace("/n", "<br>", $text2);

        $list1 = $content["contenido"]["list1"];

        $subtitle1 = $content["contenido"]["subtitulo1"];

        $text3 = $content["contenido"]["texto4"];

        $accordion = $content["contenido"]["acordeon"];


        /*Post relacionados*/

        $fetch1 = Api::request('/call-center', Request::METHOD_GET, $params);
        $json1 = json_decode($fetch1->getBody(), true);
        $data1 = $json1['data'][0];

        $titulo1 = $data1['frmContenidoCallCenter']['subMenu'];;
        $body1 =  substr($data1['frmContenidoCallCenter']['contenido'][0]['subtitulo'][0]['valor'], 0,120) . "...";


        $fetch2 = Api::request('/informacion-turistica', Request::METHOD_GET, $params);
        $json2 = json_decode($fetch2->getBody(), true);
        $data2 = $json2['data'][0];

        $titulo2 =$data2['frmContenidoAsistenciaVial']['subMenu'];
        $body2 =  substr($data2['frmContenidoAsistenciaVial']['contenido'][0]['subtitulo'][0]['valor'], 0,120) . "...";


        $infoTours = new InformationTours;
        $data = $infoTours->getData($_COOKIE["idIdioma"]); // obtener la lista de
        $content = $data["frmInfo"];

        $titulo3 = mb_strtolower($content["subMenu"]);
        $titulo3 = ucfirst($titulo3);
        $body3 = substr($content["contenido"]["texto1"], 0,120) . "...";

        $textVer = HtmlElements::generaTextVerMas();

        $viewModel = new ViewModel();
        $viewModel->setVariables([
            "mainTitle" => $mainTitle,
            "text1" => $text1,
            "text2" => $text2,
            "list1" => $list1,
            "subtitle1" => $subtitle1,
            "text3" => $text3,
            "accordion" => $accordion,
            "titulo1" => $titulo1,
            "body1" => $body1,
            "titulo2" => $titulo2,
            "body2" => $body2,
            "titulo3" => $titulo3,
            "body3" => $body3,
            "textVer" => $textVer,
        ]);
        return $viewModel;
    }

    public function recomendacionesProteccionSanitariaAction()
    {
         $params = [
             'where' => 'frmIdIdioma eq ' . $_COOKIE['idIdioma']
         ];
        // $fetch = Api::request('/recomendaciones', Request::METHOD_GET, $params);
        // $json = json_decode($fetch->getBody(), true);
        // $data = $json['data'][0];

        // $retorno = BodyMap::procesaJson($data['frmContenidoRecomendaciones']);
        // $retorno = '<p class="text-center"><img src="/img/en_construccion.jpg" class="img-fluid" ></p>' ;

        $infoProtectSan = new ProteccionSanitaria;
        $data = $infoProtectSan->getData($_COOKIE["idIdioma"]);

        $content = $data["frmInfo"];
        $basePath = $data["frmBasePath"];
        $mainTitle = $content["subMenu"];

        $subtitle1 = $content["contenido"]["subtitulo1"];
        $text1 = $content["contenido"]["texto1"];
        $text2 = $content["contenido"]["texto2"];

        $list1 = $content["contenido"]["listado1"];
        
        $subtitle2 = $content["contenido"]["subtitulo2"];
        $text3 = str_replace("\n", "<br>", $content["contenido"]["texto3"]);
        $text4 = $content["contenido"]["texto4"];

        $subtitle3 = $content["contenido"]["subtitulo3"];

        $text5 = str_replace("\n", "<br>", $content["contenido"]["texto5"]);

        $subtitle4 = $content["contenido"]["subtitulo4"];
        $text6 = $content["contenido"]["texto6"];

        /*Post relacionados*/

        $fetch1 = Api::request('/call-center', Request::METHOD_GET, $params);
        $json1 = json_decode($fetch1->getBody(), true);
        $data1 = $json1['data'][0];

        $titulo1 = $data1['frmContenidoCallCenter']['subMenu'];;
        $body1 =  substr($data1['frmContenidoCallCenter']['contenido'][0]['subtitulo'][0]['valor'], 0,120) . "...";


        $fetch2 = Api::request('/informacion-turistica', Request::METHOD_GET, $params);
        $json2 = json_decode($fetch2->getBody(), true);
        $data2 = $json2['data'][0];

        $titulo2 =$data2['frmContenidoAsistenciaVial']['subMenu'];
        $body2 =  substr($data2['frmContenidoAsistenciaVial']['contenido'][0]['subtitulo'][0]['valor'], 0,120) . "...";


        $infoHuracanes = new \Application\Library\Data\Huracanes;
        $data3 = $infoHuracanes->getData($_COOKIE["idIdioma"]);
        $content3 = $data3["frmInfo"];

        $titulo3 = $content3["subMenu"];
        $body3 = substr($content3["contenido"]["texto1"], 0,120) . "...";

        $textVer = HtmlElements::generaTextVerMas();


        $viewModel = new ViewModel();
        $viewModel->setVariables([
            "mainTitle" => $mainTitle,
            "subtitle1" => $subtitle1,
            "text1" => $text1,
            "text2" => $text2,
            "list1" => $list1,
            "subtitle2" => $subtitle2,
            "text3" => $text3,
            "text4" => $text4,
            "subtitle3" => $subtitle3,
            "text5" => $text5,
            "subtitle4" => $subtitle4,
            "text6" => $text6,
            "titulo1" => $titulo1,
            "body1" => $body1,
            "titulo2" => $titulo2,
            "body2" => $body2,
            "titulo3" => $titulo3,
            "body3" => $body3,
            "textVer" => $textVer,
        ]);
        return $viewModel;
    }

    public function informacionTuristicaAction()
    {
         $params = [
             'where' => 'frmIdIdioma eq ' . $_COOKIE['idIdioma']
         ];
        // $fetch = Api::request('/recomendaciones', Request::METHOD_GET, $params);
        // $json = json_decode($fetch->getBody(), true);
        // $data = $json['data'][0];

        // $retorno = BodyMap::procesaJson($data['frmContenidoRecomendaciones']);
        $retorno = '<p class="text-center"><img src="/img/en_construccion.jpg" class="img-fluid" ></p>' ;

        $infoTours = new InformationTours;
        $data = $infoTours->getData($_COOKIE["idIdioma"]); // obtener la lista de
        $content = $data["frmInfo"];
        $basePath = $data["frmBasePath"];
        $links = [];

        $mainTitle = $content["subMenu"];
        $text1 = $content["contenido"]["texto1"];
        $text1 = str_replace("\n", "<br>", $text1);
        $text2 = $content["contenido"]["texto2"][0];
        $link1 = $content["contenido"]["texto2"][1];

        /*Post relacionados*/

        $fetch1 = Api::request('/call-center', Request::METHOD_GET, $params);
        $json1 = json_decode($fetch1->getBody(), true);
        $data1 = $json1['data'][0];

        $titulo1 = $data1['frmContenidoCallCenter']['subMenu'];;
        $body1 =  substr($data1['frmContenidoCallCenter']['contenido'][0]['subtitulo'][0]['valor'], 0,120) . "...";


        $fetch2 = Api::request('/informacion-turistica', Request::METHOD_GET, $params);
        $json2 = json_decode($fetch2->getBody(), true);
        $data2 = $json2['data'][0];

        $titulo2 =$data2['frmContenidoAsistenciaVial']['subMenu'];
        $body2 =  substr($data2['frmContenidoAsistenciaVial']['contenido'][0]['subtitulo'][0]['valor'], 0,120) . "...";


        $infoHuracanes = new \Application\Library\Data\Huracanes;
        $data3 = $infoHuracanes->getData($_COOKIE["idIdioma"]);
        $content3 = $data3["frmInfo"];

        $titulo3 = $content3["subMenu"];
        $body3 = substr($content3["contenido"]["texto1"], 0,120) . "...";

        $textVer = HtmlElements::generaTextVerMas();

        $viewModel = new ViewModel();
        $viewModel->setVariables([
            "mainTitle" => $mainTitle,
            "text1" => $text1,
            "text2" => $text2,
            "link1" => $link1,
            "titulo1" => $titulo1,
            "body1" => $body1,
            "titulo2" => $titulo2,
            "body2" => $body2,
            "titulo3" => $titulo3,
            "body3" => $body3,
            "textVer" => $textVer,
        ]);
        return $viewModel;
    }

    public function catalogoPrestadoresServiciosAction()
    {

        $retorno = '<p class="text-center"><img src="/img/en_construccion.jpg" class="img-fluid" ></p>' ;

        HtmlElements::validateTokenSedetur();

        $prestadores = HtmlElements::getCatalogoPresentadaProfeco();

        $giros = HtmlElements::generateOptionsGirosComerciales();

        $destinos = HtmlElements::generateOptionsDestinos();

        $viewModel = new ViewModel();
        $viewModel->setVariables([
            'content' => $retorno,
            'prestadores' => $prestadores,
            'destinos' => $destinos,
            'giros' => $giros
        ]);
        return $viewModel;
    }
}
