<?php
namespace General\Controller;

use Laminas\Mvc\Controller\AbstractActionController;
use Laminas\View\Model\ViewModel;
use Application\Controller\MainController;
use Application\Library\Api\Api;
use Application\Library\Complements\BodyMap;
use Application\Library\Complements\MyLogger;
use Exception;
use Laminas\Http\Request;
use Laminas\ServiceManager\ServiceManager;

/**
 * It handles the actions for managing users data.
 * @author workstation2
 */
class PublicGeneralController extends MainController
{
    
    /**
     * Constructor.
     * @param ServiceManager $sm
     */
    public function __construct(ServiceManager $sm)
    {
        parent::__construct($sm);
        $this->module = $this->translator->translate('Publico');
        $this->controller = $this->translator->translate('General');
    }
    
    /**
     * Datatable view.
     * {@inheritDoc}
     * @see \Laminas\Mvc\Controller\AbstractActionController::indexAction()
     */
    public function indexAction()
    {
        try{
            $fetch = Api::request('/inicio', Request::METHOD_GET, false);
            $json = json_decode($fetch->getBody(), true);
                        
            foreach ($json['data'] as $i => $v){
                if ($v['frmIdIdioma'] == $_COOKIE['idIdioma']){
                    $data = $v;
                }
                if(!$_COOKIE['idIdioma']){
                    $data = $v;
                    continue;
                }
            }
            
            $retorno = BodyMap::procesaJson($data['frmContenidoInicio'], $data['frmBasePath']);

            $viewModel = new ViewModel();
            $viewModel->setVariables([
                'content' => $retorno
            ]);
            return $viewModel;
        }catch(Exception $e){

            return;
        }
    }
}
