<?php

namespace General\Controller;

use Application\Controller\MainController;
use Application\Library\Api\Api;
use Application\Library\Complements\BodyMap;
use Application\Library\Complements\HtmlElements;
use Application\Library\postRelacionados\SectionsModules;
use Laminas\Http\Request;
use Laminas\ServiceManager\ServiceManager;
use Laminas\View\Model\ViewModel;

/**
 * It handles the actions for managing users data.
 * @author workstation2
 */
class EmergenciasController extends MainController
{

    /**
     * Constructor.
     * @param ServiceManager $sm
     */
    public function __construct(ServiceManager $sm)
    {
        parent::__construct($sm);
        $this->module = $this->translator->translate('Publico');
        $this->controller = $this->translator->translate('General');
    }

    /**
     * Datatable view.
     * {@inheritDoc}
     * @see \Laminas\Mvc\Controller\AbstractActionController::indexAction()
     */
    public function emergenciasAction()
    {
        $params = [
            'where' => 'frmIdIdioma eq ' . $_COOKIE['idIdioma']
        ];
        $fetch = Api::request('/emergencias', Request::METHOD_GET, $params);
        $json = json_decode($fetch->getBody(), true);
        $data = $json['data'][0];
        
        $retorno = BodyMap::procesaJson($data['frmContenidoEmergencias'], $data['frmBasePath']);

        /* Titulo */
        $titulo = mb_strtoupper($data['frmContenidoEmergencias']['subMenu']);

        /* Subtitulo */
        $subtitulo = mb_strtoupper($data['frmContenidoEmergencias']['contenido'][0]['titulo']);

        /* Listado de parrafos */
        $listado = $data['frmContenidoEmergencias']['contenido'][0]['subtitulo'][0]['listado'];
        $html_listado = HtmlElements::generateListadoConcat2Texts($listado);

        /* btn emergency */
        $btn = HtmlElements::generateBtnEmergency($data['frmContenidoEmergencias']['links'][0]);

        $sections = SectionsModules::generatePostRelacionados(400);

        $viewModel = new ViewModel();
        $viewModel->setVariables([
            'tittle' => $titulo,
            'subtitulo' => $subtitulo,
            'html_listado' => $html_listado,
            'btn' => $btn,
            'sections' => $sections
        ]);
        return $viewModel;
    }

    public function policiaFederalAction()
    {
        $params = [
            'where' => 'frmIdIdioma eq ' . $_COOKIE['idIdioma']
        ];
        $fetch = Api::request('/policia-federal', Request::METHOD_GET, $params);
        $json = json_decode($fetch->getBody(), true);
        $data = $json['data'][0];

        $retorno = BodyMap::procesaJson($data['frmContenidoPoliciaFederal']);

        $links = $data['frmContenidoPoliciaFederal']['links'];

        /* Titulo */
        $titulo = mb_strtoupper($data['frmContenidoPoliciaFederal']['subMenu']);

        /* Subtitulo */
        $subtitulo = $data['frmContenidoPoliciaFederal']['contenido'][0]['titulo'];

        /* Contenido */
        $contain1_text1 = $data['frmContenidoPoliciaFederal']['contenido'][0]['subtitulo'][0]['valor'];
        $contain1_text2 = HtmlElements::generateContenidoConLinks($data['frmContenidoPoliciaFederal']['contenido'][0]['subtitulo'][1]['valor'], $links);

        /* btn emergency */
        $btn = HtmlElements::generateBtnEmergency($data['frmContenidoPoliciaFederal']['links'][0]);

        $sections = SectionsModules::generatePostRelacionados(400);


        $viewModel = new ViewModel();
        $viewModel->setVariables([
            'tittle' => $titulo,
            'subtitulo' => $subtitulo,
            'contain1_text1' => $contain1_text1,
            'contain1_text2' => $contain1_text2,
            'btn' => $btn,
            'sections' => $sections

        ]);
        return $viewModel;
    }

    public function denunciaAnonimaAction()
    {
        $params = [
            'where' => 'frmIdIdioma eq ' . $_COOKIE['idIdioma']
        ];
        $fetch = Api::request('/denuncia-anonima', Request::METHOD_GET, $params);
        $json = json_decode($fetch->getBody(), true);
        $data = $json['data'][0];

        $retorno = BodyMap::procesaJson($data['frmContenidoDenunciaAnonima']);

        $links = $data['frmContenidoDenunciaAnonima']['links'];

        /* Titulo */
        $titulo = $data['frmContenidoDenunciaAnonima']['subMenu'];

        /* Subtitulo */
        $subtitulo = $data['frmContenidoDenunciaAnonima']['contenido'][0]['titulo'];

        /* Contenido */
        $contain1_text1 = $data['frmContenidoDenunciaAnonima']['contenido'][0]['subtitulo'][0]['valor'];
        $contain1_text2 = $data['frmContenidoDenunciaAnonima']['contenido'][0]['subtitulo'][1]['valor'];
        $contain1_text3 = HtmlElements::generateContenidoConLinks($data['frmContenidoDenunciaAnonima']['contenido'][0]['subtitulo'][2]['valor'],$links);

        /* btn emergency */
        $btn = HtmlElements::generateBtnEmergency($data['frmContenidoDenunciaAnonima']['links'][0]);

        $sections = SectionsModules::generatePostRelacionados(400);


        $viewModel = new ViewModel();
        $viewModel->setVariables([
            'tittle' => $titulo,
            'subtitulo' => $subtitulo,
            'contain1_text1' => $contain1_text1,
            'contain1_text2' => $contain1_text2,
            'contain1_text3' => $contain1_text3,
            'btn' => $btn,
            'sections' => $sections

        ]);
        return $viewModel;
    }

    public function informacionTuristicaAction()
    {
        $params = [
            'where' => 'frmIdIdioma eq ' . $_COOKIE['idIdioma']
        ];
        $fetch = Api::request('/informacion-turistica', Request::METHOD_GET, $params);
        $json = json_decode($fetch->getBody(), true);
        $data = $json['data'][0];

        $retorno = BodyMap::procesaJson($data['frmContenidoAsistenciaVial'], $data['frmBasePath']);

        /* Titulo */
        $titulo = $data['frmContenidoAsistenciaVial']['subMenu'];

        /* btn emergency */
        $btn = HtmlElements::generateBtnEmergency($data['frmContenidoAsistenciaVial']['links'][0]);

        /* Contenido  */

        /* Titulo 1*/
        $contain1_tittle1 = $data['frmContenidoAsistenciaVial']['contenido'][0]['titulo'];
        /* Contenido 1*/
        $contain1_text1 = HtmlElements::generateMultiParrafos($data['frmContenidoAsistenciaVial']['contenido'][0]['subtitulo']);


        /* Titulo 2*/
        $contain2_tittle1 = $data['frmContenidoAsistenciaVial']['contenido'][1]['titulo'];
        /* Contenido 2*/
        $contain2_text1 = HtmlElements::generateListasSimples($data['frmContenidoAsistenciaVial']['contenido'][1]['subtitulo']);

        /* Titulo 3*/
        $contain3_tittle1 = $data['frmContenidoAsistenciaVial']['contenido'][2]['titulo'];
        /* Contenido 2*/
        $contain3_text1 = HtmlElements::generateListasSimples($data['frmContenidoAsistenciaVial']['contenido'][2]['subtitulo']);


        /* Titulo 4*/
        $contain4_tittle1 = $data['frmContenidoAsistenciaVial']['contenido'][3]['titulo'];
        /* Contenido 2*/
        $contain4_text1 = HtmlElements::generateListasSimples($data['frmContenidoAsistenciaVial']['contenido'][3]['subtitulo']);

        $sections = SectionsModules::generatePostRelacionados(400);

        $viewModel = new ViewModel();
        $viewModel->setVariables([
            'tittle' => $titulo,
            'btn' => $btn,
            'contain1_tittle1' => $contain1_tittle1,
            'contain1_text1' => $contain1_text1,
            'contain2_tittle1' => $contain2_tittle1,
            'contain2_text1' => $contain2_text1,
            'contain3_tittle1' => $contain3_tittle1,
            'contain3_text1' => $contain3_text1,
            'contain4_tittle1' => $contain4_tittle1,
            'contain4_text1' => $contain4_text1,
            'sections' => $sections

        ]);
        return $viewModel;
    }

    public function callCenterAction()
    {
        $params = [
            'where' => 'frmIdIdioma eq ' . $_COOKIE['idIdioma']
        ];
        $fetch = Api::request('/call-center', Request::METHOD_GET, $params);
        $json = json_decode($fetch->getBody(), true);
        $data = $json['data'][0];

//        $retorno = BodyMap::procesaJson($data['frmContenidoCallCenter']);

        /* Titulo */
        $titulo = $data['frmContenidoCallCenter']['subMenu'];

        /* Primer contenido */
        $Contain1_text1 = $data['frmContenidoCallCenter']['contenido'][0]['subtitulo'][0]['valor'];

        if($_COOKIE['idIdioma'] == 1){
            $Contain1_text2 = $data['frmContenidoCallCenter']['contenido'][0]['subtitulo'][1]['valor'];

            /*Listado*/
            $listado = $data['frmContenidoCallCenter']['contenido'][0]['subtitulo'][2]['listado'];
            $html_listadp = HtmlElements::generateListadoConcatBandera($listado);
        }else{
            $Contain1_text2 = '';

            /*Listado*/
            $listado = $data['frmContenidoCallCenter']['contenido'][0]['subtitulo'][1]['listado'];
            $html_listadp = HtmlElements::generateListadoConcatBandera($listado);
        }

        /* btn emergency */
        $btn = HtmlElements::generateBtnEmergency($data['frmContenidoCallCenter']['links'][0]);

        $sections = SectionsModules::generatePostRelacionados(400);


        $viewModel = new ViewModel();
        $viewModel->setVariables([
            'tittle' => $titulo,
            'Contain1_text1' => $Contain1_text1,
            'Contain1_text2' => $Contain1_text2,
            'html_listado' => $html_listadp,
            'btn' => $btn,
            'sections' => $sections


        ]);
        return $viewModel;
    }

}
