<?php
namespace General\Controller;

use Application\Library\Complements\HtmlElements;
use Laminas\View\Model\ViewModel;
use Application\Controller\MainController;
use Application\Library\Api\Api;
use Application\Library\Complements\BodyMap;
use Application\Library\Complements\MyLogger;
use Laminas\Http\Request;
use Laminas\ServiceManager\ServiceManager;

use function PHPUnit\Framework\returnSelf;

/**
 * It handles the actions for managing users data.
 * @author workstation2
 */
class DirectoriosController extends MainController
{

    /**
     * Constructor.
     * @param ServiceManager $sm
     */
    public function __construct(ServiceManager $sm)
    {
        parent::__construct($sm);
        $this->module = $this->translator->translate('Publico');
        $this->controller = $this->translator->translate('General');
    }

    /**
     * Datatable view.
     * {@inheritDoc}
     * @see \Laminas\Mvc\Controller\AbstractActionController::indexAction()
     */
    public function consuladosYEmbajadasAction()
    {
        HtmlElements::validateTokenSedetur();

        $id = $this->params()->fromRoute('id',0);
//        $params = [
//            'where' => 'frmIdIdioma eq ' . $_COOKIE['idIdioma']
//        ];
//
//        if($id > 0){
//            $fetch = Api::request('/consulados-y-embajadas/'.$id, Request::METHOD_GET, $params);
//        }else{
//            $fetch = Api::request('/consulados-y-embajadas', Request::METHOD_GET, $params);
//        }
//        $json = json_decode($fetch->getBody(), true);
//        foreach ($json['data'] as $i => $v){
//            if ($v['frmIdIdioma'] == $_COOKIE['idIdioma']){
//                $data = $v;
//            }
//            if(!$_COOKIE['idIdioma']){
//                $data = $v;
//                continue;
//            }
//        }

        if($id > 0){
//            $retorno = BodyMap::procesaJsonConsulado($data['frmContenidoConsuladoEmbajada'], $data['frmBasePath']);
            $retorno=  HtmlElements::generateOptionsConsuladoById($id);

        }else{

            $retorno=  HtmlElements::generateOptionsConsulados();

//            $retorno = BodyMap::procesaJsonConsulados($data['frmContenidoConsuladosEmbajadas'], $data['frmBasePath']);
        }

        $viewModel = new ViewModel();
        $viewModel->setVariables([
            'content' => $retorno
        ]);
        return $viewModel;
    }

    public function fiscaliasAction()
    {
        $id = $this->params()->fromRoute('id',0);
//        $params = [
//             'where' => 'frmIdIdioma eq ' . $_COOKIE['idIdioma']
//        ];
//        if($id > 0){
//            $fetch = Api::request('/fiscalias/'.$id, Request::METHOD_GET, $params);
//        }else{
//            $fetch = Api::request('/fiscalias', Request::METHOD_GET, $params);
//        }
//        $json = json_decode($fetch->getBody(), true);
//        foreach ($json['data'] as $i => $v){
//            if ($v['frmIdIdioma'] == $_COOKIE['idIdioma']){
//                $data = $v;
//            }
//            if(!$_COOKIE['idIdioma']){
//                $data = $v;
//                continue;
//            }
//        }

        if($id > 0){
//            $retorno = BodyMap::procesaJsonConsulado($data['frmContenidoFiscalia']);
            $retorno=  HtmlElements::generateOptionsFiscaliaById($id);

        }else{
//            $retorno = BodyMap::procesaJson($data['frmContenidoFiscalias']);
            $retorno = HtmlElements::generateAccordionFiscalias();

        }



        $viewModel = new ViewModel();
        $viewModel->setVariables([
            'content' => $retorno
        ]);
        return $viewModel;
    }

    public function hospitalesAction()
    {
        $id = $this->params()->fromRoute('id',0);
//        $params = [
//            // 'where' => 'frmIdIdioma eq ' . $_COOKIE['idIdioma']
//        ];
//        if($id > 0){
//            $fetch = Api::request('/hospitales/'.$id, Request::METHOD_GET, $params);
//        }else{
//            $fetch = Api::request('/hospitales', Request::METHOD_GET, $params);
//        }
//        $json = json_decode($fetch->getBody(), true);
//        foreach ($json['data'] as $i => $v){
//            if ($v['frmIdIdioma'] == $_COOKIE['idIdioma']){
//                $data = $v;
//            }
//            if(!$_COOKIE['idIdioma']){
//                $data = $v;
//                continue;
//            }
//        }
        if($id > 0){
//            $retorno = BodyMap::procesaJsonConsulado($data['frmContenidoHospital']);
            $retorno=  HtmlElements::generateOptionsHospitalById($id);

        }else{
            $retorno = HtmlElements::generateAccordionHospitales();

//            $retorno = BodyMap::procesaJson($data['frmContenidoHospitales']);
        }

        $viewModel = new ViewModel();
        $viewModel->setVariables([
            'content' => $retorno
        ]);
        return $viewModel;
    }

}
