<?php
namespace General\Controller;

use Laminas\View\Model\ViewModel;
use Application\Controller\MainController;
use Application\Library\Api\Api;
use Application\Library\Complements\BodyMap;
use Application\Library\Complements\MyLogger;
use Laminas\Http\Request;
use Laminas\ServiceManager\ServiceManager;

use function PHPUnit\Framework\returnSelf;

/**
 * It handles the actions for managing users data.
 * @author workstation2
 */
class AvisosController extends MainController
{
    
    /**
     * Constructor.
     * @param ServiceManager $sm
     */
    public function __construct(ServiceManager $sm)
    {
        parent::__construct($sm);
        $this->module = $this->translator->translate('Publico');
        $this->controller = $this->translator->translate('General');
    }

    /**
     * Datatable view.
     * {@inheritDoc}
     * @see \Laminas\Mvc\Controller\AbstractActionController::indexAction()
     */
    public function acercaDeAction()
    {
        $params = [
            'where' => 'frmIdIdioma eq ' . $_COOKIE['idIdioma']
        ];
        $fetch = Api::request('/acerca-de', Request::METHOD_GET, $params);
        $json = json_decode($fetch->getBody(), true);
        $data = $json['data'][0];

        $retorno = BodyMap::procesaJson($data['frmContenidoAcercaNosotros']);

        $viewModel = new ViewModel();
        $viewModel->setVariables([
            'content' => $retorno
        ]);
        return $viewModel;
    }


    public function avisoDePrivacidadAction()
    {
        $params = [
            'where' => 'frmIdIdioma eq ' . $_COOKIE['idIdioma']
        ];
        $authResult = Api::request('/aviso-privacidad', Request::METHOD_GET, $params);
        $json = json_decode($authResult->getBody(), true);
        $data = $json['data'][0];

        $retorno = BodyMap::procesaJson($data['frmContenidoAvisoPrivacidad']);

        $viewModel = new ViewModel();
        $viewModel->setVariables([
            'content' => $retorno
        ]);
        return $viewModel;

    }

    public function terminosYCondicionesAction()
    {
        $params = [
            'where' => 'frmIdIdioma eq ' . $_COOKIE['idIdioma']
        ];
        $authResult = Api::request('/terminos-y-condiciones', Request::METHOD_GET, $params);
        $json = json_decode($authResult->getBody(), true);
        $data = $json['data'][0];

        $retorno = BodyMap::procesaJson($data['frmContenidoTerminosCondiciones']);

        $viewModel = new ViewModel();
        $viewModel->setVariables([
            'content' => $retorno
        ]);
        return $viewModel;
    }
}
