<?php
namespace General;

use Laminas\Router\Http\Segment;
use Laminas\Mvc\Controller\LazyControllerAbstractFactory;

return [
    'router' => [
        'routes' => [
            'publicGeneral' => [
                'type'    => Segment::class,
                'options' => [
                    'route'    => '/',
                    'defaults' => [
                        'controller' => Controller\PublicGeneralController::class,
                        'action'     => 'index',
                    ],
                ],
            ],
            'avisos' => [
                'type'    => Segment::class,
                'options' => [
                    'route'    => '/avisos[/:action]',
                    'defaults' => [
                        'controller' => Controller\AvisosController::class,
                        'action' => 'index'
                    ],
                ],
            ],
            'servicios' => [
                'type'    => Segment::class,
                'options' => [
                    'route'    => '/servicios[/:action]',
                    'defaults' => [
                        'controller' => Controller\ServiciosController::class,
                        'action' => 'index'
                    ],
                ],
            ],
            'emergencias' => [
                'type'    => Segment::class,
                'options' => [
                    'route'    => '/emergencias[/:action]',
                    'defaults' => [
                        'controller' => Controller\EmergenciasController::class,
                        'action' => 'index'
                    ],
                ],
            ],
            'directorios' => [
                'type'    => Segment::class,
                'options' => [
                    'route'    => '/directorios[/:action][/:id]',
                    'defaults' => [
                        'controller' => Controller\DirectoriosController::class,
                        'action' => 'index'
                    ],
                ],
            ],
            'recomendaciones' => [
                'type'    => Segment::class,
                'options' => [
                    'route'    => '/recomendaciones[/:action]',
                    'defaults' => [
                        'controller' => Controller\RecomendacionesController::class,
                        'action' => 'index'
                    ],
                ],
            ],
            'authSocialNetwork' => [
                'type'    => Segment::class,
                'options' => [
                    'route'    => '/auth-social-network[/:action]',
                    'defaults' => [
                        'controller' => Controller\AuthSocialNetworkController::class,
                        'action' => 'index'
                    ],
                ],
            ]
        ],
    ],
    'controllers' => [
        'factories' => [
            Controller\PublicGeneralController::class => LazyControllerAbstractFactory::class,
            Controller\AvisosController::class => LazyControllerAbstractFactory::class,
            Controller\ServiciosController::class => LazyControllerAbstractFactory::class,
            Controller\EmergenciasController::class => LazyControllerAbstractFactory::class,
            Controller\RecomendacionesController::class => LazyControllerAbstractFactory::class,
            Controller\DirectoriosController::class => LazyControllerAbstractFactory::class,
            Controller\AuthSocialNetworkController::class => LazyControllerAbstractFactory::class,
        ]
    ],
    'view_manager' => [
        'template_map' => [
            'general/partial/public-general/datatable'=> __DIR__ . '/../view/partial/public-general/datatable.phtml',
            'general/partial/public-general/form'=> __DIR__ . '/../view/partial/public-general/form.phtml',
            'general/partial/servicios/quejas-sedetur-form'=> __DIR__ . '/../view/partial/servicios/quejas-sedetur-form.phtml',
            'general/partial/servicios/asesoria-legal-formES'=> __DIR__ . '/../view/partial/servicios/asesoria-legal-formES.phtml',
            'general/partial/servicios/asesoria-legal-formEN'=> __DIR__ . '/../view/partial/servicios/asesoria-legal-formEN.phtml',
            'general/partial/servicios/asesoria-legal-form-general'=> __DIR__ . '/../view/partial/servicios/asesoria-legal-form-general.phtml',
            'general/partial/auth-social-network/formES'=> __DIR__ . '/../view/partial/auth-social-network/formES.phtml',
            'general/partial/auth-social-network/form'=> __DIR__ . '/../view/partial/auth-social-network/form.phtml',
            'general/partial/auth-social-network/formEN'=> __DIR__ . '/../view/partial/auth-social-network/formEN.phtml',
            'general/partial/public-general/modalUsuarioES'=> __DIR__ . '/../view/partial/public-general/modalUsuarioES.phtml',
            'general/partial/public-general/modalUsuarioEN'=> __DIR__ . '/../view/partial/public-general/modalUsuarioEN.phtml',
            'general/partial/public-general/chatBot'=> __DIR__ . '/../view/partial/public-general/chatBot.phtml'
        ],
        'template_path_stack' => [
            __DIR__ . '/../view'
        ]
    ]
];