<?php
namespace Configuration;

use Laminas\Router\Http\Segment;
use Laminas\Mvc\Controller\LazyControllerAbstractFactory;

return [
    'router' => [
        'routes' => [
            'storage' => [
                'type'    => Segment::class,
                'options' => [
                    'route'    => '/configuration/storage[/:action]',
                    'defaults' => [
                        'controller' => Controller\StorageController::class,
                        'action'     => 'index',
                    ],
                ],
            ]
        ],
    ],
    'controllers' => [
        'factories' => [
            Controller\StorageController::class => LazyControllerAbstractFactory::class
        ]
    ],
    'view_manager' => [
        'template_map' => [
            'configuration/partial/storage/form'=> __DIR__ . '/../view/partial/storage/form.phtml'
        ],
        'template_path_stack' => [
            __DIR__ . '/../view'
        ]
    ]
];