<?php
namespace Catalogs;

use Laminas\Router\Http\Segment;
use Laminas\Mvc\Controller\LazyControllerAbstractFactory;

return [
    'router' => [
        'routes' => [
            'committees' => [
                'type'    => Segment::class,
                'options' => [
                    'route'    => '/catalogs/committees[/:action][/:id]',
                    'defaults' => [
                        'controller' => Controller\CommitteesController::class,
                        'action'     => 'index',
                    ],
                ],
            ]
        ],
    ],
    'controllers' => [
        'factories' => [
            Controller\CommitteesController::class => LazyControllerAbstractFactory::class
        ]
    ],
    'view_manager' => [
        'template_map' => [
            'catalogs/partial/committees/datatable'=> __DIR__ . '/../view/partial/committees/datatable.phtml',
            'catalogs/partial/committees/form'=> __DIR__ . '/../view/partial/committees/form.phtml',
        ],
        'template_path_stack' => [
            __DIR__ . '/../view'
        ]
    ]
];