<?php
namespace Authentication;

use Laminas\Mvc\Controller\LazyControllerAbstractFactory;
use Laminas\Router\Http\Literal;
use Laminas\Router\Http\Segment;

return [
    'router' => [
        'routes' => [
            // Logout URL is intercepted on MvcListener.php, and is only for cleaning session 
            // and redirect to login no view nor action are implemented.
            'logout' => [
                'type'    => Literal::class,
                'options' => [
                    'route'    => '/app/logout',
                    'defaults' => [
                        'controller' => Controller\LoginController::class,
                        'action'     => 'index',
                    ],
                ],
            ],
            'login' => [
                'type'    => Segment::class,
                'options' => [
                    'route'    => '/admin',
                    'defaults' => [
                        'controller' => Controller\LoginController::class,
                        'action'     => 'index',
                    ],
                ],
            ],
            'publico' => [
                'type'    => Segment::class,
                'options' => [
                    'route'    => '/',
                    'defaults' => [
                        'controller' => Controller\LoginController::class,
                        'action'     => 'publico',
                    ],
                ],
            ]
        ],
    ],
    'controllers' => [
        'factories' => [
            Controller\LoginController::class => LazyControllerAbstractFactory::class
        ]
    ],
    'view_manager' => [
        'template_map' => [
            'layout/authentication' => __DIR__.'/../view/layout/layout.phtml'
        ],
        'template_path_stack' => [
            __DIR__ . '/../view',
        ]
    ]
];